/*
 * Decompiled with CFR 0.152.
 */
package com.caedis.duradisplay.utils;

import java.text.DecimalFormat;
import org.jetbrains.annotations.Nullable;

public class DurabilityFormatter {
    @Nullable
    public static String format(double current, double max, Format format) {
        double percent = current / max * 100.0;
        switch (format) {
            case percent: {
                return Double.isNaN(percent) ? null : String.format("%.0f%%", percent);
            }
            case remaining: {
                return DurabilityFormatter.shortenNumber(current);
            }
            case used: {
                return DurabilityFormatter.shortenNumber(max - current);
            }
            case max: {
                return DurabilityFormatter.shortenNumber(max);
            }
            case fraction: {
                return Double.isNaN(percent) ? null : String.format("%.0f/%.0f", current, max);
            }
        }
        return null;
    }

    public static String shortenNumber(double number) {
        DecimalFormat decimalFormat = new DecimalFormat("0.#");
        if (number >= 1.0E9) {
            return decimalFormat.format(number / 1.0E9) + "b";
        }
        if (number >= 1000000.0) {
            return decimalFormat.format(number / 1000000.0) + "m";
        }
        if (number >= 1000.0) {
            return decimalFormat.format(number / 1000.0) + "k";
        }
        return decimalFormat.format(number);
    }

    public static enum Format {
        percent,
        remaining,
        used,
        max,
        fraction;

    }
}

