/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.config;

import com.falsepattern.lib.internal.core.LowLevelCallMultiplexer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class EarlyConfig {
    @Expose
    private boolean enableLibraryDownloads;
    @Expose
    private boolean enableLetsEncryptRoot;
    private static volatile EarlyConfig instance = null;
    private static final Logger LOG = LogManager.getLogger((String)"FalsePatternLib Early Config");

    @NotNull
    public static EarlyConfig getInstance() {
        EarlyConfig config = instance;
        if (config != null) {
            return config;
        }
        return EarlyConfig.loadFromDisk();
    }

    @NotNull
    private static synchronized EarlyConfig loadFromDisk() {
        EarlyConfig config = instance;
        if (config != null) {
            return config;
        }
        Path configDir = LowLevelCallMultiplexer.gameDir().resolve("config");
        Path configFile = configDir.resolve("falsepatternlib-early.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            if (!Files.exists(configDir, new LinkOption[0])) {
                Files.createDirectories(configDir, new FileAttribute[0]);
            }
            if (Files.exists(configFile, new LinkOption[0])) {
                config = (EarlyConfig)gson.fromJson(new String(Files.readAllBytes(configFile), StandardCharsets.UTF_8), EarlyConfig.class);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to load from disk", (Throwable)e);
        }
        if (config == null) {
            config = new EarlyConfig();
            config.enableLibraryDownloads(true);
            config.enableLetsEncryptRoot(true);
            try {
                Files.write(configFile, gson.toJson((Object)config).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                LOG.error("Failed to write to disk", (Throwable)e);
            }
        }
        instance = config;
        return config;
    }

    @Generated
    public EarlyConfig() {
    }

    @Generated
    public boolean enableLibraryDownloads() {
        return this.enableLibraryDownloads;
    }

    @Generated
    public boolean enableLetsEncryptRoot() {
        return this.enableLetsEncryptRoot;
    }

    @Generated
    public EarlyConfig enableLibraryDownloads(boolean enableLibraryDownloads) {
        this.enableLibraryDownloads = enableLibraryDownloads;
        return this;
    }

    @Generated
    public EarlyConfig enableLetsEncryptRoot(boolean enableLetsEncryptRoot) {
        this.enableLetsEncryptRoot = enableLetsEncryptRoot;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EarlyConfig)) {
            return false;
        }
        EarlyConfig other = (EarlyConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.enableLibraryDownloads() != other.enableLibraryDownloads()) {
            return false;
        }
        return this.enableLetsEncryptRoot() == other.enableLetsEncryptRoot();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EarlyConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.enableLibraryDownloads() ? 79 : 97);
        result = result * 59 + (this.enableLetsEncryptRoot() ? 79 : 97);
        return result;
    }

    @Generated
    public String toString() {
        return "EarlyConfig(enableLibraryDownloads=" + this.enableLibraryDownloads() + ", enableLetsEncryptRoot=" + this.enableLetsEncryptRoot() + ")";
    }
}

