/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config;

import cpw.mods.fml.client.config.ConfigGuiType;
import cpw.mods.fml.client.config.GuiConfigEntries;
import cpw.mods.fml.client.config.GuiEditArrayEntries;
import cpw.mods.fml.client.config.IConfigElement;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Property;

public class ConfigElementProxy<T>
implements IConfigElement<T> {
    private final Supplier<Property> prop;
    private final String comment;
    private final Runnable syncCallback;

    public ConfigElementProxy(Supplier<Property> prop, String comment, Runnable syncCallback) {
        this.prop = prop;
        this.comment = comment;
        this.syncCallback = syncCallback;
    }

    private ConfigElement<T> element() {
        return new ConfigElement(this.prop.get());
    }

    public boolean isProperty() {
        return this.element().isProperty();
    }

    public Class<? extends GuiConfigEntries.IConfigEntry> getConfigEntryClass() {
        return this.element().getConfigEntryClass();
    }

    public Class<? extends GuiEditArrayEntries.IArrayEntry> getArrayEntryClass() {
        return this.element().getArrayEntryClass();
    }

    public String getName() {
        return this.element().getName();
    }

    public String getQualifiedName() {
        return this.element().getQualifiedName();
    }

    public String getLanguageKey() {
        return this.element().getLanguageKey();
    }

    public String getComment() {
        return this.comment;
    }

    public List<IConfigElement> getChildElements() {
        return this.element().getChildElements();
    }

    public ConfigGuiType getType() {
        return this.element().getType();
    }

    public boolean isList() {
        return this.element().isList();
    }

    public boolean isListLengthFixed() {
        return this.element().isListLengthFixed();
    }

    public int getMaxListLength() {
        return this.element().getMaxListLength();
    }

    public boolean isDefault() {
        return this.element().isDefault();
    }

    public Object getDefault() {
        return this.element().getDefault();
    }

    public Object[] getDefaults() {
        return this.element().getDefaults();
    }

    public void setToDefault() {
        this.element().setToDefault();
        this.syncCallback.run();
    }

    public boolean requiresWorldRestart() {
        return this.element().requiresWorldRestart();
    }

    public boolean showInGui() {
        return this.element().showInGui();
    }

    public boolean requiresMcRestart() {
        return this.element().requiresMcRestart();
    }

    public Object get() {
        return this.element().get();
    }

    public Object[] getList() {
        return this.element().getList();
    }

    public void set(T value) {
        this.element().set(value);
        this.syncCallback.run();
    }

    public void set(T[] aVal) {
        this.element().set((Object[])aVal);
        this.syncCallback.run();
    }

    public String[] getValidValues() {
        return this.element().getValidValues();
    }

    public T getMinValue() {
        return (T)this.element().getMinValue();
    }

    public T getMaxValue() {
        return (T)this.element().getMaxValue();
    }

    public Pattern getValidationPattern() {
        return this.element().getValidationPattern();
    }
}

