/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config.fields;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.internal.impl.config.ConfigFieldParameters;
import com.falsepattern.lib.internal.impl.config.DeclOrderInternal;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Optional;
import lombok.Generated;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public abstract class AConfigField<T> {
    public final boolean noSync;
    public final int order;
    public final String name;
    protected final Field field;
    protected final Configuration configuration;
    protected final String category;
    protected final String langKey;
    protected final Property.Type type;
    protected final String comment;
    private boolean uninitialized;

    public static RuntimeException noDefault(Field field, String annotation) {
        return new RuntimeException("The field " + field.getName() + " in class " + field.getDeclaringClass().getName() + " has no " + annotation + " annotation!");
    }

    protected AConfigField(ConfigFieldParameters params, Property.Type type) {
        this(params, type, false);
    }

    protected AConfigField(ConfigFieldParameters params, Property.Type type, boolean isList) {
        this.field = params.field();
        this.configuration = params.configuration();
        this.category = params.category();
        this.comment = Optional.ofNullable(this.field.getAnnotation(Config.Comment.class)).map(Config.Comment::value).map(lines -> String.join((CharSequence)"\n", lines)).orElse("");
        Optional<Config.Name> nameAnnotation = Optional.ofNullable(this.field.getAnnotation(Config.Name.class));
        this.name = nameAnnotation.map(Config.Name::value).orElse(this.field.getName());
        this.langKey = Optional.ofNullable(this.field.getAnnotation(Config.LangKey.class)).map(Config.LangKey::value).map(x -> x.isEmpty() ? "config." + params.modid() + "." + params.category() + "." + this.name : x).orElse(this.name);
        this.type = type;
        ConfigCategory cat = this.configuration.getCategory(this.category);
        this.uninitialized = !cat.containsKey(this.name);
        Property property = isList ? this.configuration.get(this.category, this.name, new String[0], this.comment, type) : this.configuration.get(this.category, this.name, "", this.comment, type);
        property.setLanguageKey(this.langKey);
        property.setRequiresWorldRestart(this.field.isAnnotationPresent(Config.RequiresWorldRestart.class));
        property.setRequiresMcRestart(this.field.isAnnotationPresent(Config.RequiresMcRestart.class));
        this.noSync = this.field.isAnnotationPresent(Config.NoSync.class);
        this.order = Optional.ofNullable(this.field.getAnnotation(DeclOrderInternal.class)).map(DeclOrderInternal::value).orElse(-1);
    }

    protected abstract T getField();

    protected abstract void putField(T var1);

    protected abstract T getConfig();

    protected abstract void putConfig(T var1);

    protected abstract T getDefault();

    public void save() {
        if (!this.validateField()) {
            this.setToDefault();
        } else {
            this.putConfig(this.getField());
        }
    }

    public void load() {
        this.putField(this.getConfig());
        if (!this.validateField()) {
            this.setToDefault();
        }
    }

    public void setToDefault() {
        this.putField(this.getDefault());
        this.putConfig(this.getDefault());
    }

    public void init() {
        if (this.uninitialized) {
            this.uninitialized = false;
            this.putField(this.getDefault());
            this.putConfig(this.getDefault());
        } else {
            this.load();
        }
    }

    public Property getProperty() {
        return this.configuration.getCategory(this.category).get(this.name);
    }

    public abstract boolean validateField();

    public abstract void transmit(DataOutput var1) throws IOException;

    public abstract void receive(DataInput var1) throws IOException;

    public Field getJavaField() {
        return this.field;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }
}

