/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gravisuiteneo.mixins;

import com.gtnewhorizons.gravisuiteneo.common.Properties;
import cpw.mods.fml.common.Optional;
import gravisuite.ItemAdvancedJetPack;
import gravisuite.ItemAdvancedNanoChestPlate;
import gregtech.api.hazards.Hazard;
import gregtech.api.hazards.IHazardProtector;
import ic2.api.item.ElectricItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Optional.Interface(iface="gregtech.api.hazards.IHazardProtector", modid="gregtech_nh")
@Mixin(value={ItemAdvancedNanoChestPlate.class}, remap=false)
public class MixinItemAdvancedNanoChestPlate
extends ItemAdvancedJetPack
implements IHazardProtector {
    @Shadow
    private static byte tickRate = (byte)20;
    @Shadow
    private static byte ticker;
    @Shadow
    private int energyForExtinguish = 50000;

    public MixinItemAdvancedNanoChestPlate(ItemArmor.ArmorMaterial armorMaterial, int par3, int par4) {
        super(armorMaterial, par3, par4);
    }

    @Overwrite
    public double getDamageAbsorptionRatio() {
        return Properties.ArmorPresets.AdvNanoChestPlate.absorptionRatio;
    }

    @Overwrite
    private double getBaseAbsorptionRatio() {
        return 1.0;
    }

    @Inject(method={"onArmorTick"}, at={@At(value="HEAD")}, cancellable=true)
    void onArmorTickLenient(World worldObj, EntityPlayer player, ItemStack itemStack, CallbackInfo ci) {
        super.onArmorTick(worldObj, player, itemStack);
        byte currentTick = ticker;
        ticker = (byte)(currentTick + 1);
        if (currentTick % tickRate == 0 && player.func_70027_ad() && ElectricItem.manager.canUse(itemStack, (double)this.energyForExtinguish)) {
            ItemAdvancedJetPack.use((ItemStack)itemStack, (int)this.energyForExtinguish);
            player.func_70066_B();
        }
        ci.cancel();
    }

    @Optional.Method(modid="gregtech_nh")
    public boolean protectsAgainst(ItemStack itemStack, Hazard hazard) {
        return true;
    }
}

