/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.enums;

import gregtech.api.interfaces.IColorModulationContainer;
import gregtech.api.util.GTUtility;
import gregtech.common.config.Client;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Dyes implements IColorModulationContainer
{
    dyeBlack(0, 0x20202000, "Black", EnumChatFormatting.BLACK),
    dyeRed(1, -16777216, "Red", EnumChatFormatting.RED),
    dyeGreen(2, 0xFF0000, "Green", EnumChatFormatting.DARK_GREEN),
    dyeBrown(3, 0x60400000, "Brown", EnumChatFormatting.GOLD),
    dyeBlue(4, 0x20FF00, "Blue", EnumChatFormatting.DARK_BLUE),
    dyePurple(5, -2147450880, "Purple", EnumChatFormatting.DARK_PURPLE),
    dyeCyan(6, 0xFFFF00, "Cyan", EnumChatFormatting.DARK_AQUA),
    dyeLightGray(7, -1061109760, "Light Gray", EnumChatFormatting.GRAY),
    dyeGray(8, -2139062272, "Gray", EnumChatFormatting.DARK_GRAY),
    dyePink(9, -4145152, "Pink", EnumChatFormatting.LIGHT_PURPLE),
    dyeLime(10, -2130739200, "Lime", EnumChatFormatting.GREEN),
    dyeYellow(11, -65536, "Yellow", EnumChatFormatting.YELLOW),
    dyeLightBlue(12, 1619066624, "Light Blue", EnumChatFormatting.AQUA),
    dyeMagenta(13, -16711936, "Magenta", EnumChatFormatting.LIGHT_PURPLE),
    dyeOrange(14, -8388608, "Orange", EnumChatFormatting.GOLD),
    dyeWhite(15, -256, "White", EnumChatFormatting.WHITE),
    _NULL(-1, -256, "INVALID COLOR"),
    CABLE_INSULATION(-2, Dyes.cableInsulation(), "Cable Insulation"),
    MACHINE_METAL(-3, Dyes.machineMetal(), "Machine Metal");

    public final int rgba;
    @Deprecated
    public final short[] mRGBa;
    public final int mIndex;
    public final String mName;
    public final EnumChatFormatting formatting;
    private final HashSet<Fluid> fluidDyesSet = new HashSet();
    private static final Map<Fluid, Dyes> fluidDyesMap;
    private static final Map<String, Dyes> dyesFromName;
    public static final Dyes[] VALUES;

    private static int cableInsulation() {
        Client.ColorModulation.CableInsulation insulation = Client.colorModulation.cableInsulation;
        int r = GTUtility.clamp(insulation.red, 0, 255);
        int g = GTUtility.clamp(insulation.green, 0, 255);
        int b = GTUtility.clamp(insulation.blue, 0, 255);
        return r << 24 | g << 16 | b << 8;
    }

    private static int machineMetal() {
        Client.ColorModulation.MachineMetal metal = Client.colorModulation.machineMetal;
        int r = GTUtility.clamp(metal.red, 0, 255);
        int g = GTUtility.clamp(metal.green, 0, 255);
        int b = GTUtility.clamp(metal.blue, 0, 255);
        return r << 24 | g << 16 | b << 8;
    }

    private Dyes(@NotNull int index, int rgba, String name) {
        this(index, rgba, name, EnumChatFormatting.GRAY);
    }

    private Dyes(@NotNull int index, @NotNull int rgba, String name, EnumChatFormatting formatting) {
        this.rgba = rgba;
        short r = (short)(rgba >>> 24 & 0xFF);
        short g = (short)(rgba >>> 16 & 0xFF);
        short b = (short)(rgba >>> 8 & 0xFF);
        short a = (short)(rgba & 0xFF);
        this.mRGBa = new short[]{r, g, b, a};
        this.mIndex = index;
        this.mName = name;
        this.formatting = formatting;
    }

    @NotNull
    public static Dyes get(int index) {
        return Dyes.getOrDefault(index, _NULL);
    }

    @NotNull
    public static Dyes getOrDefault(int index, @NotNull Dyes defaultDye) {
        if (Dyes.isDyeIndex(index)) {
            return VALUES[index];
        }
        return defaultDye;
    }

    @NotNull
    public static Dyes get(@NotNull String color) {
        return Dyes.getOrDefault(color, _NULL);
    }

    @NotNull
    public static Dyes getOrDefault(@NotNull String color, @NotNull Dyes defaultDye) {
        return dyesFromName.getOrDefault(color, defaultDye);
    }

    public static boolean isDyeIndex(int index) {
        return 0 <= index && index <= 15;
    }

    public static int transformDyeIndex(int index) {
        if (Dyes.isDyeIndex(index)) {
            return 15 - index;
        }
        throw new IllegalArgumentException("Index passed to `transformDyeIndex` must be between 0 and 15");
    }

    @Deprecated
    public static short @NotNull [] getModulation(int index) {
        return Dyes.getModulation(index, _NULL.getRGBA());
    }

    @Deprecated
    public static short @NotNull [] getModulation(int index, short @NotNull [] defaultModulation) {
        if (Dyes.isDyeIndex(index)) {
            return Dyes.VALUES[index].mRGBa;
        }
        return defaultModulation;
    }

    @Nullable
    public static Dyes getFluidDye(@Nullable FluidStack fluidStack) {
        if (fluidStack == null) {
            return null;
        }
        return Dyes.getFluidDye(fluidStack.getFluid());
    }

    @Nullable
    public static Dyes getFluidDye(@Nullable Fluid fluid) {
        if (fluid == null) {
            return null;
        }
        return fluidDyesMap.get(fluid);
    }

    public static boolean isFluidDye(@Nullable FluidStack fluidStack) {
        if (fluidStack == null) {
            return false;
        }
        return Dyes.isFluidDye(fluidStack.getFluid());
    }

    public static boolean isFluidDye(@Nullable Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        return fluidDyesMap.containsKey(fluid);
    }

    public void addFluidDye(@Nullable Fluid fluid) {
        if (fluid == null) {
            return;
        }
        this.fluidDyesSet.add(fluid);
        fluidDyesMap.put(fluid, this);
    }

    @NotNull
    public @NotNull HashSet<@NotNull Fluid> getFluidDyes() {
        return this.fluidDyesSet;
    }

    @Override
    @Deprecated
    public short @NotNull [] getRGBA() {
        return this.mRGBa;
    }

    @Deprecated
    public int toInt() {
        return this.rgba >>> 8;
    }

    @NotNull
    public String getLocalizedDyeName() {
        return StatCollector.func_74838_a((String)("GT5U.infinite_spray_can.color." + this.mName));
    }

    static {
        fluidDyesMap = new HashMap<Fluid, Dyes>();
        dyesFromName = new HashMap<String, Dyes>();
        VALUES = new Dyes[]{dyeBlack, dyeRed, dyeGreen, dyeBrown, dyeBlue, dyePurple, dyeCyan, dyeLightGray, dyeGray, dyePink, dyeLime, dyeYellow, dyeLightBlue, dyeMagenta, dyeOrange, dyeWhite};
        for (Dyes dye : Dyes.values()) {
            dyesFromName.put(dye.name(), dye);
            dyesFromName.put(dye.mName, dye);
        }
    }
}

