/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import gregtech.api.GregTechAPI;
import gregtech.api.net.GTPacket;
import gregtech.api.net.GTPacketTypes;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GTCoilStatus
extends GTPacket {
    public int worldId;
    public boolean isActive;
    public LongCollection coils;

    public GTCoilStatus() {
    }

    public GTCoilStatus(int worldId, boolean isActive, LongCollection coils) {
        this.worldId = worldId;
        this.isActive = isActive;
        this.coils = coils;
    }

    @Override
    public byte getPacketID() {
        return GTPacketTypes.COIL_STATUS.id;
    }

    @Override
    public void encode(ByteBuf buffer) {
        buffer.writeInt(this.worldId);
        buffer.writeBoolean(this.isActive);
        buffer.writeInt(this.coils.size());
        LongIterator longIterator = this.coils.iterator();
        while (longIterator.hasNext()) {
            long l = (Long)longIterator.next();
            buffer.writeLong(l);
        }
    }

    @Override
    public GTPacket decode(ByteArrayDataInput buffer) {
        GTCoilStatus packet = new GTCoilStatus();
        packet.worldId = buffer.readInt();
        packet.isActive = buffer.readBoolean();
        int count = buffer.readInt();
        packet.coils = new LongArrayList(count);
        for (int i = 0; i < count; ++i) {
            packet.coils.add(buffer.readLong());
        }
        return packet;
    }

    @Override
    public void process(IBlockAccess blockAccess) {
        if (!(blockAccess instanceof World)) {
            return;
        }
        World world = (World)blockAccess;
        if (world.field_73011_w.field_76574_g != this.worldId) {
            return;
        }
        LongIterator longIterator = this.coils.iterator();
        while (longIterator.hasNext()) {
            int z;
            int y;
            long coil = (Long)longIterator.next();
            int x = CoordinatePacker.unpackX((long)coil);
            if (world.func_147439_a(x, y = CoordinatePacker.unpackY((long)coil), z = CoordinatePacker.unpackZ((long)coil)) != GregTechAPI.sBlockCasings5) continue;
            int meta = world.func_72805_g(x, y, z);
            meta %= 16;
            if (this.isActive) {
                meta += 16;
            }
            world.func_72921_c(x, y, z, meta, 2);
        }
    }
}

