/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe.maps;

import gregtech.api.recipe.BasicUIPropertiesBuilder;
import gregtech.api.recipe.NEIRecipePropertiesBuilder;
import gregtech.api.recipe.RecipeMapFrontend;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gregtech.nei.RecipeDisplayInfo;

public class IsotopeDecayFrontend
extends RecipeMapFrontend {
    public IsotopeDecayFrontend(BasicUIPropertiesBuilder uiPropertiesBuilder, NEIRecipePropertiesBuilder neiPropertiesBuilder) {
        super(uiPropertiesBuilder, neiPropertiesBuilder);
    }

    @Override
    public void drawDescription(RecipeDisplayInfo recipeInfo) {
        String string;
        GTRecipeConstants.DecayType decayType = recipeInfo.recipe.getMetadataOrDefault(GTRecipeConstants.DECAY_TYPE, GTRecipeConstants.DecayType.Unknown);
        Object[] objectArray = new Object[1];
        switch (decayType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case Unknown: {
                string = GTUtility.translate("GT5U.gui.text.unknown", new Object[0]);
                break;
            }
            case Alpha: {
                string = GTUtility.translate("GT5U.gui.text.alpha", new Object[0]);
                break;
            }
            case SpontaneousFission: {
                string = GTUtility.translate("GT5U.gui.text.spontaneous-fission", new Object[0]);
                break;
            }
            case Cluster: {
                string = GTUtility.translate("GT5U.gui.text.cluster", new Object[0]);
                break;
            }
            case AlphaTransfer: {
                string = GTUtility.translate("GT5U.gui.text.alpha-transfer", new Object[0]);
                break;
            }
            case BetaMinus: {
                string = GTUtility.translate("GT5U.gui.text.beta-minus", new Object[0]);
                break;
            }
            case BetaPlus: {
                string = GTUtility.translate("GT5U.gui.text.beta-plus", new Object[0]);
            }
        }
        objectArray[0] = string;
        recipeInfo.drawText(GTUtility.translate("GT5U.gui.text.decay-type", objectArray));
        double halflife = recipeInfo.recipe.getMetadataOrDefault(GTRecipeConstants.HALF_LIFE, 1.0);
        double perStackSecond = 64.0 / halflife;
        String unit = GTUtility.translate("GTPP.time.seconds", new Object[0]).toLowerCase();
        if (halflife > 86400.0) {
            halflife /= 86400.0;
            unit = GTUtility.translate("GTPP.time.days", new Object[0]).toLowerCase();
        } else if (halflife > 3600.0) {
            halflife /= 3600.0;
            unit = GTUtility.translate("GTPP.time.hours", new Object[0]).toLowerCase();
        } else if (halflife > 60.0) {
            halflife /= 60.0;
            unit = GTUtility.translate("GTPP.time.minutes", new Object[0]).toLowerCase();
        }
        recipeInfo.drawText(GTUtility.translate("GT5U.gui.text.half-life", String.format("%.2f", halflife), unit));
        recipeInfo.drawText(GTUtility.translate("GT5U.gui.text.isotope-prod-per-s", perStackSecond));
        this.drawRecipeOwnerInfo(recipeInfo);
    }
}

