/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client;

import appeng.api.util.IOrientable;
import appeng.tile.misc.TileInterface;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import com.gtnewhorizon.structurelib.alignment.IAlignment;
import com.gtnewhorizon.structurelib.alignment.IAlignmentProvider;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregtech.api.GregTechAPI;
import gregtech.api.covers.CoverRegistry;
import gregtech.api.enums.ItemList;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.ITurnable;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.metatileentity.implementations.MTEBasicMachine;
import gregtech.api.objects.GTItemStack;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.BlockFrameBox;
import gregtech.common.blocks.ItemMachines;
import gregtech.common.config.Client;
import ic2.api.tile.IWrenchable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class BlockOverlayRenderer {
    private static final List<Block> ROTATABLE_VANILLA_BLOCKS;
    private static final int ROTATION_MARKER_RESOLUTION = 120;
    private static final int[][] GRID_SWITCH_TABLE;
    private static final Transformation ROTATION_MARKER_TRANSFORM_CENTER;
    private static final Transformation[] ROTATION_MARKER_TRANSFORMS_SIDES_TRANSFORMS;
    private static final int[] ROTATION_MARKER_TRANSFORMS_SIDES;
    private static final Transformation[] ROTATION_MARKER_TRANSFORMS_CORNER;
    private static int rotationMarkerDisplayList;
    private static boolean rotationMarkerDisplayListCompiled;

    @SubscribeEvent
    public void onDrawBlockHighlight(DrawBlockHighlightEvent event) {
        IGregTechTileEntity gtEntity;
        Block aBlock = event.player.field_70170_p.func_147439_a(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d);
        TileEntity aTileEntity = event.player.field_70170_p.func_147438_o(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d);
        if (GTUtility.isStackInList(event.currentItem, (Collection<GTItemStack>)GregTechAPI.sWrenchList)) {
            IOrientable orientable;
            if (aTileEntity instanceof ITurnable || ROTATABLE_VANILLA_BLOCKS.contains(aBlock) || aTileEntity instanceof IWrenchable || aTileEntity instanceof IOrientable && (orientable = (IOrientable)aTileEntity).canBeRotated() || aBlock instanceof BlockFrameBox) {
                BlockOverlayRenderer.drawGrid(event, false, true, event.player.func_70093_af());
            }
            return;
        }
        if (aTileEntity == null && aBlock instanceof BlockFrameBox) {
            if (CoverRegistry.isCover(event.currentItem)) {
                BlockOverlayRenderer.drawGrid(event, true, false, event.player.func_70093_af());
            }
            return;
        }
        if (!(aTileEntity instanceof ICoverable)) {
            return;
        }
        if (event.player.func_70093_af() && aTileEntity instanceof IGregTechTileEntity && (gtEntity = (IGregTechTileEntity)aTileEntity).getMetaTileEntity() instanceof MetaPipeEntity && event.currentItem != null && event.currentItem.func_77973_b() instanceof ItemMachines && GregTechAPI.METATILEENTITIES[event.currentItem.func_77960_j()] instanceof MetaPipeEntity) {
            BlockOverlayRenderer.drawGrid(event, false, false, false);
        }
        if (GTUtility.isStackInList(event.currentItem, (Collection<GTItemStack>)GregTechAPI.sWireCutterList) || GTUtility.isStackInList(event.currentItem, (Collection<GTItemStack>)GregTechAPI.sSolderingToolList) && event.player.func_70093_af()) {
            if (!((ICoverable)aTileEntity).hasCoverAtSide(ForgeDirection.getOrientation((int)event.target.field_72310_e))) {
                BlockOverlayRenderer.drawGrid(event, false, false, event.player.func_70093_af());
            }
            return;
        }
        if (event.currentItem == null && event.player.func_70093_af() || GTUtility.isStackInList(event.currentItem, (Collection<GTItemStack>)GregTechAPI.sCrowbarList) || GTUtility.isStackInList(event.currentItem, (Collection<GTItemStack>)GregTechAPI.sScrewdriverList)) {
            if (!((ICoverable)aTileEntity).hasCoverAtSide(ForgeDirection.getOrientation((int)event.target.field_72310_e))) {
                for (ForgeDirection tSide : ForgeDirection.VALID_DIRECTIONS) {
                    if (!((ICoverable)aTileEntity).hasCoverAtSide(tSide)) continue;
                    BlockOverlayRenderer.drawGrid(event, true, false, true);
                    return;
                }
            }
            return;
        }
        if (CoverRegistry.isCover(event.currentItem) && !((ICoverable)aTileEntity).hasCoverAtSide(ForgeDirection.getOrientation((int)event.target.field_72310_e))) {
            BlockOverlayRenderer.drawGrid(event, true, false, event.player.func_70093_af());
        }
        if (GTUtility.areStacksEqual(ItemList.Tool_Cover_Copy_Paste.get(1L, new Object[0]), event.currentItem, true) && !((ICoverable)aTileEntity).hasCoverAtSide(ForgeDirection.getOrientation((int)event.target.field_72310_e))) {
            BlockOverlayRenderer.drawGrid(event, true, false, event.player.func_70093_af());
        }
    }

    private static void drawGrid(DrawBlockHighlightEvent aEvent, boolean showCoverConnections, boolean aIsWrench, boolean aIsSneaking) {
        IAlignment tAlignment;
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        int program = GL11.glGetInteger((int)35725);
        GL20.glUseProgram((int)0);
        MovingObjectPosition target = aEvent.target;
        EntityPlayer player = aEvent.player;
        double camX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)aEvent.partialTicks;
        double camY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)aEvent.partialTicks;
        double camZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)aEvent.partialTicks;
        GL11.glTranslated((double)(target.field_72311_b - (int)camX), (double)(target.field_72312_c - (int)camY), (double)(target.field_72309_d - (int)camZ));
        GL11.glTranslated((double)(0.5 - (camX - (double)((int)camX))), (double)(0.5 - (camY - (double)((int)camY))), (double)(0.5 - (camZ - (double)((int)camZ))));
        int tSideHit = target.field_72310_e;
        Rotation.sideRotations[tSideHit].glApply();
        GL11.glTranslated((double)0.0, (double)-0.502, (double)0.0);
        GL11.glLineWidth((float)BlockOverlayRenderer.calculateLineWidth());
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78371_b(1);
        int red = Client.blockoverlay.red;
        int green = Client.blockoverlay.green;
        int blue = Client.blockoverlay.blue;
        int alpha = Client.blockoverlay.alpha;
        tess.func_78370_a(red, green, blue, alpha);
        tess.func_78377_a(0.5, 0.0, -0.25);
        tess.func_78377_a(-0.5, 0.0, -0.25);
        tess.func_78377_a(0.5, 0.0, 0.25);
        tess.func_78377_a(-0.5, 0.0, 0.25);
        tess.func_78377_a(0.25, 0.0, -0.5);
        tess.func_78377_a(0.25, 0.0, 0.5);
        tess.func_78377_a(-0.25, 0.0, -0.5);
        tess.func_78377_a(-0.25, 0.0, 0.5);
        TileEntity tTile = player.field_70170_p.func_147438_o(target.field_72311_b, target.field_72312_c, target.field_72309_d);
        Block block = player.field_70170_p.func_147439_a(target.field_72311_b, target.field_72312_c, target.field_72309_d);
        int meta = player.field_70170_p.func_72805_g(target.field_72311_b, target.field_72312_c, target.field_72309_d);
        int tConnections = 0;
        if (tTile instanceof ICoverable) {
            BaseMetaTileEntity baseMetaTile;
            ForgeDirection[] iCoverable = (ForgeDirection[])tTile;
            if (showCoverConnections) {
                for (ForgeDirection tSide : ForgeDirection.VALID_DIRECTIONS) {
                    if (!iCoverable.hasCoverAtSide(tSide)) continue;
                    tConnections |= tSide.flag;
                }
            } else if (tTile instanceof BaseMetaTileEntity && (baseMetaTile = (BaseMetaTileEntity)tTile).getAlignment() == null) {
                if (!aIsSneaking) {
                    tConnections |= baseMetaTile.getFrontFacing().flag;
                } else {
                    IMetaTileEntity iMetaTileEntity = baseMetaTile.getMetaTileEntity();
                    if (iMetaTileEntity instanceof MTEBasicMachine) {
                        MTEBasicMachine basicMachine = (MTEBasicMachine)iMetaTileEntity;
                        tConnections |= basicMachine.mMainFacing.flag;
                    }
                }
            } else if (tTile instanceof BaseMetaPipeEntity) {
                BaseMetaPipeEntity pipeEntity = (BaseMetaPipeEntity)tTile;
                tConnections = pipeEntity.mConnections;
            }
        } else if (tTile instanceof IWrenchable) {
            IWrenchable wrenchable = (IWrenchable)tTile;
            tConnections |= ForgeDirection.getOrientation((int)wrenchable.getFacing()).flag;
        } else if (ROTATABLE_VANILLA_BLOCKS.contains(block)) {
            tConnections |= ForgeDirection.getOrientation((int)meta).flag;
        } else if (tTile instanceof TileInterface) {
            TileInterface tileInterface = (TileInterface)tTile;
            tConnections |= tileInterface.getUp().getOpposite().flag;
        }
        if (tConnections != 0) {
            block9: for (ForgeDirection tSide : ForgeDirection.VALID_DIRECTIONS) {
                if ((tConnections & tSide.flag) == 0) continue;
                switch (GRID_SWITCH_TABLE[target.field_72310_e][tSide.ordinal()]) {
                    case 0: {
                        tess.func_78377_a(0.25, 0.0, 0.25);
                        tess.func_78377_a(-0.25, 0.0, -0.25);
                        tess.func_78377_a(-0.25, 0.0, 0.25);
                        tess.func_78377_a(0.25, 0.0, -0.25);
                        continue block9;
                    }
                    case 1: {
                        tess.func_78377_a(-0.25, 0.0, 0.5);
                        tess.func_78377_a(0.25, 0.0, 0.25);
                        tess.func_78377_a(-0.25, 0.0, 0.25);
                        tess.func_78377_a(0.25, 0.0, 0.5);
                        continue block9;
                    }
                    case 2: {
                        tess.func_78377_a(-0.5, 0.0, -0.25);
                        tess.func_78377_a(-0.25, 0.0, 0.25);
                        tess.func_78377_a(-0.5, 0.0, 0.25);
                        tess.func_78377_a(-0.25, 0.0, -0.25);
                        continue block9;
                    }
                    case 3: {
                        tess.func_78377_a(-0.25, 0.0, -0.5);
                        tess.func_78377_a(0.25, 0.0, -0.25);
                        tess.func_78377_a(-0.25, 0.0, -0.25);
                        tess.func_78377_a(0.25, 0.0, -0.5);
                        continue block9;
                    }
                    case 4: {
                        tess.func_78377_a(0.5, 0.0, -0.25);
                        tess.func_78377_a(0.25, 0.0, 0.25);
                        tess.func_78377_a(0.5, 0.0, 0.25);
                        tess.func_78377_a(0.25, 0.0, -0.25);
                        continue block9;
                    }
                    case 5: {
                        tess.func_78377_a(0.5, 0.0, 0.5);
                        tess.func_78377_a(0.25, 0.0, 0.25);
                        tess.func_78377_a(0.5, 0.0, 0.25);
                        tess.func_78377_a(0.25, 0.0, 0.5);
                        tess.func_78377_a(0.5, 0.0, -0.5);
                        tess.func_78377_a(0.25, 0.0, -0.25);
                        tess.func_78377_a(0.5, 0.0, -0.25);
                        tess.func_78377_a(0.25, 0.0, -0.5);
                        tess.func_78377_a(-0.5, 0.0, 0.5);
                        tess.func_78377_a(-0.25, 0.0, 0.25);
                        tess.func_78377_a(-0.5, 0.0, 0.25);
                        tess.func_78377_a(-0.25, 0.0, 0.5);
                        tess.func_78377_a(-0.5, 0.0, -0.5);
                        tess.func_78377_a(-0.25, 0.0, -0.25);
                        tess.func_78377_a(-0.5, 0.0, -0.25);
                        tess.func_78377_a(-0.25, 0.0, -0.5);
                    }
                }
            }
        }
        tess.func_78381_a();
        Function<ForgeDirection, Transformation[]> getTransform = direction -> {
            try {
                if (direction.ordinal() == tSideHit) {
                    return new Transformation[]{ROTATION_MARKER_TRANSFORM_CENTER};
                }
                if (direction.getOpposite().ordinal() == tSideHit) {
                    return ROTATION_MARKER_TRANSFORMS_CORNER;
                }
                return new Transformation[]{ROTATION_MARKER_TRANSFORMS_SIDES_TRANSFORMS[ROTATION_MARKER_TRANSFORMS_SIDES[tSideHit * 6 + direction.ordinal()]]};
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return new Transformation[0];
            }
        };
        if (aIsWrench && tTile instanceof IAlignmentProvider && (tAlignment = ((IAlignmentProvider)tTile).getAlignment()) != null) {
            for (Transformation transform : getTransform.apply(tAlignment.getDirection())) {
                BlockOverlayRenderer.drawExtendedRotationMarker(transform, aIsSneaking, tAlignment);
            }
        }
        if (aIsWrench && tTile instanceof IOrientable) {
            IOrientable orientable = (IOrientable)tTile;
            if (!(tTile instanceof TileInterface) && orientable.canBeRotated()) {
                for (Transformation transform : getTransform.apply(aIsSneaking ? orientable.getForward() : orientable.getUp())) {
                    BlockOverlayRenderer.drawExtendedRotationMarker(transform, aIsSneaking, orientable);
                }
            }
        }
        GL20.glUseProgram((int)program);
        GL11.glPopMatrix();
    }

    private static void drawExtendedRotationMarker(Transformation transform, boolean sneaking, IAlignment alignment) {
        if (sneaking) {
            if (alignment.isFlipChangeAllowed()) {
                BlockOverlayRenderer.drawFlipMarker(transform);
            }
        } else if (alignment.isRotationChangeAllowed()) {
            BlockOverlayRenderer.drawRotationMarker(transform);
        }
    }

    private static void drawExtendedRotationMarker(Transformation transform, boolean sneaking, IOrientable orientable) {
        BlockOverlayRenderer.drawRotationMarker(transform);
    }

    private static void drawRotationMarker(Transformation transform) {
        if (!rotationMarkerDisplayListCompiled) {
            rotationMarkerDisplayList = GLAllocation.func_74526_a((int)1);
            BlockOverlayRenderer.compileRotationMarkerDisplayList(rotationMarkerDisplayList);
            rotationMarkerDisplayListCompiled = true;
        }
        GL11.glPushMatrix();
        transform.glApply();
        GL11.glCallList((int)rotationMarkerDisplayList);
        GL11.glPopMatrix();
    }

    private static void compileRotationMarkerDisplayList(int displayList) {
        int i;
        GL11.glNewList((int)displayList, (int)4864);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78371_b(2);
        for (i = 0; i <= 120; ++i) {
            tess.func_78377_a(Math.cos((double)i * Math.PI * 1.75 / 120.0) * 0.4, 0.0, Math.sin((double)i * Math.PI * 1.75 / 120.0) * 0.4);
        }
        for (i = 120; i >= 0; --i) {
            tess.func_78377_a(Math.cos((double)i * Math.PI * 1.75 / 120.0) * 0.24, 0.0, Math.sin((double)i * Math.PI * 1.75 / 120.0) * 0.24);
        }
        tess.func_78377_a(0.1411145618, 0.0, 0.0);
        tess.func_78377_a(0.32, 0.0, -0.178885438199);
        tess.func_78377_a(0.498885438199, 0.0, 0.0);
        tess.func_78381_a();
        GL11.glEndList();
    }

    private static void drawFlipMarker(Transformation transform) {
        GL11.glPushMatrix();
        transform.glApply();
        Tessellator t = Tessellator.field_78398_a;
        GL11.glLineStipple((int)4, (short)-21846);
        GL11.glEnable((int)2852);
        t.func_78371_b(3);
        t.func_78377_a(0.1, 0.0, 0.04);
        t.func_78377_a(0.1, 0.0, 0.2);
        t.func_78377_a(0.35, 0.0, 0.35);
        t.func_78377_a(0.35, 0.0, -0.35);
        t.func_78377_a(0.1, 0.0, -0.2);
        t.func_78377_a(0.1, 0.0, -0.04);
        t.func_78381_a();
        GL11.glDisable((int)2852);
        t.func_78371_b(3);
        t.func_78377_a(-0.1, 0.0, 0.04);
        t.func_78377_a(-0.1, 0.0, 0.2);
        t.func_78377_a(-0.35, 0.0, 0.35);
        t.func_78377_a(-0.35, 0.0, -0.35);
        t.func_78377_a(-0.1, 0.0, -0.2);
        t.func_78377_a(-0.1, 0.0, -0.04);
        t.func_78381_a();
        t.func_78371_b(2);
        t.func_78377_a(0.15, 0.0, -0.04);
        t.func_78377_a(0.15, 0.0, -0.1);
        t.func_78377_a(0.25, 0.0, 0.0);
        t.func_78377_a(0.15, 0.0, 0.1);
        t.func_78377_a(0.15, 0.0, 0.04);
        t.func_78377_a(-0.15, 0.0, 0.04);
        t.func_78377_a(-0.15, 0.0, 0.1);
        t.func_78377_a(-0.25, 0.0, 0.0);
        t.func_78377_a(-0.15, 0.0, -0.1);
        t.func_78377_a(-0.15, 0.0, -0.04);
        t.func_78381_a();
        GL11.glPopMatrix();
    }

    private static float calculateLineWidth() {
        float baseHeight = 1080.0f;
        return Client.blockoverlay.lineWidth * ((float)Minecraft.func_71410_x().field_71440_d / 1080.0f);
    }

    static {
        GRID_SWITCH_TABLE = new int[][]{{0, 5, 3, 1, 2, 4}, {5, 0, 1, 3, 2, 4}, {1, 3, 0, 5, 2, 4}, {3, 1, 5, 0, 2, 4}, {4, 2, 3, 1, 0, 5}, {2, 4, 3, 1, 5, 0}};
        ROTATION_MARKER_TRANSFORM_CENTER = new Scale(0.5);
        ROTATION_MARKER_TRANSFORMS_SIDES_TRANSFORMS = new Transformation[]{new Scale(0.25).with((Transformation)new Translation(0.0, 0.0, 0.375)).compile(), new Scale(0.25).with((Transformation)new Translation(0.375, 0.0, 0.0)).compile(), new Scale(0.25).with((Transformation)new Translation(0.0, 0.0, -0.375)).compile(), new Scale(0.25).with((Transformation)new Translation(-0.375, 0.0, 0.0)).compile()};
        ROTATION_MARKER_TRANSFORMS_SIDES = new int[]{-1, -1, 2, 0, 3, 1, -1, -1, 0, 2, 3, 1, 0, 2, -1, -1, 3, 1, 2, 0, -1, -1, 3, 1, 1, 3, 2, 0, -1, -1, 3, 1, 2, 0, -1, -1};
        ROTATION_MARKER_TRANSFORMS_CORNER = new Transformation[]{new Scale(0.25).with((Transformation)new Translation(0.375, 0.0, 0.375)).compile(), new Scale(0.25).with((Transformation)new Translation(-0.375, 0.0, 0.375)).compile(), new Scale(0.25).with((Transformation)new Translation(0.375, 0.0, -0.375)).compile(), new Scale(0.25).with((Transformation)new Translation(-0.375, 0.0, -0.375)).compile()};
        rotationMarkerDisplayListCompiled = false;
        ROTATABLE_VANILLA_BLOCKS = Arrays.asList(Blocks.field_150331_J, Blocks.field_150320_F, Blocks.field_150460_al, Blocks.field_150470_am, Blocks.field_150409_cd, Blocks.field_150367_z, Blocks.field_150486_ae, Blocks.field_150447_bR, Blocks.field_150477_bB, Blocks.field_150438_bZ, Blocks.field_150423_aK, Blocks.field_150428_aP);
    }
}

