/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.covers.CoverContext;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.common.covers.CoverLegacyData;
import gregtech.common.misc.WirelessNetworkManager;
import java.util.UUID;

public class CoverEnergyWireless
extends CoverLegacyData {
    private final long transferred_energy_per_operation;

    public CoverEnergyWireless(CoverContext context, int voltage) {
        super(context);
        this.transferred_energy_per_operation = (long)(2 * voltage) * WirelessNetworkManager.ticks_between_energy_addition;
    }

    @Override
    public boolean isRedstoneSensitive(long aTimer) {
        return false;
    }

    @Override
    public boolean allowsCopyPasteTool() {
        return false;
    }

    @Override
    public boolean allowsTickRateAddition() {
        return false;
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        if (this.coverData == 0 || aTimer % WirelessNetworkManager.ticks_between_energy_addition == 0L) {
            this.tryFetchingEnergy((ICoverable)this.coveredTile.get());
        }
        this.coverData = 1;
    }

    private static UUID getOwner(Object te) {
        if (te instanceof BaseMetaTileEntity) {
            BaseMetaTileEntity igte = (BaseMetaTileEntity)te;
            return igte.getOwnerUuid();
        }
        return null;
    }

    private void tryFetchingEnergy(ICoverable tileEntity) {
        if (tileEntity instanceof BaseMetaTileEntity) {
            BaseMetaTileEntity bmte = (BaseMetaTileEntity)tileEntity;
            long currentEU = bmte.getStoredEUuncapped();
            long euToTransfer = Long.min(this.transferred_energy_per_operation - currentEU, this.transferred_energy_per_operation);
            if (euToTransfer <= 0L) {
                return;
            }
            if (!WirelessNetworkManager.addEUToGlobalEnergyMap(CoverEnergyWireless.getOwner(tileEntity), -euToTransfer)) {
                return;
            }
            bmte.increaseStoredEnergyUnits(euToTransfer, true);
        }
    }

    @Override
    public boolean alwaysLookConnected() {
        return true;
    }

    @Override
    public int getMinimumTickRate() {
        return 20;
    }
}

