/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.redstone;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.GregTechAPI;
import gregtech.api.covers.CoverContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.common.covers.Cover;
import gregtech.common.covers.CoverPosition;
import gregtech.common.covers.redstone.CoverAdvancedRedstoneReceiverBase;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import org.jetbrains.annotations.NotNull;

public abstract class CoverAdvancedWirelessRedstoneBase
extends Cover {
    protected String frequency = "0";
    protected UUID uuid = null;

    public CoverAdvancedWirelessRedstoneBase(CoverContext context, ITexture coverTexture) {
        super(context, coverTexture);
    }

    public String getFrequency() {
        return this.frequency;
    }

    public CoverAdvancedWirelessRedstoneBase setFrequency(String frequency) {
        this.frequency = frequency;
        return this;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public CoverAdvancedWirelessRedstoneBase setUuid(UUID uuid) {
        this.uuid = uuid;
        return this;
    }

    @Override
    protected void readDataFromNbt(NBTBase nbt) {
        NBTTagCompound tag = (NBTTagCompound)nbt;
        ICoverable cover = (ICoverable)this.coveredTile.get();
        if (cover != null && cover.getWorld() != null) {
            GregTechAPI.sAdvancedWirelessRedstone.computeIfAbsent(this.uuid == null ? "null" : this.uuid.toString(), k -> new ConcurrentHashMap()).computeIfAbsent(this.frequency, k -> new ConcurrentHashMap()).remove(CoverAdvancedWirelessRedstoneBase.getCoverKey(cover, this.coverSide));
        }
        this.frequency = tag.func_74779_i("frequency");
        this.uuid = tag.func_74764_b("uuid") ? UUID.fromString(tag.func_74779_i("uuid")) : null;
    }

    @Override
    public void readDataFromPacket(ByteArrayDataInput byteData) {
        if (byteData.readBoolean()) {
            this.uuid = new UUID(byteData.readLong(), byteData.readLong());
        }
        int length = byteData.readInt();
        StringBuilder freqBuilder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            freqBuilder.append(byteData.readChar());
        }
        this.frequency = freqBuilder.toString();
    }

    @Override
    @NotNull
    protected NBTBase saveDataToNbt() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("frequency", this.frequency);
        if (this.uuid != null) {
            tag.func_74778_a("uuid", this.uuid.toString());
        }
        return tag;
    }

    @Override
    protected void writeDataToByteBuf(ByteBuf byteBuf) {
        byteBuf.writeBoolean(this.uuid != null);
        if (this.uuid != null) {
            byteBuf.writeLong(this.uuid.getMostSignificantBits());
            byteBuf.writeLong(this.uuid.getLeastSignificantBits());
        }
        byteBuf.writeInt(this.frequency.length());
        for (int i = 0; i < this.frequency.length(); ++i) {
            byteBuf.writeChar((int)this.frequency.charAt(i));
        }
    }

    public static Byte getSignalAt(UUID uuid, String frequency, CoverAdvancedRedstoneReceiverBase.GateMode mode) {
        Map<String, Map<CoverPosition, Byte>> frequencies = GregTechAPI.sAdvancedWirelessRedstone.get(String.valueOf(uuid));
        if (frequencies == null) {
            return (byte)0;
        }
        Map<CoverPosition, Byte> signals = frequencies.get(frequency);
        if (signals == null) {
            signals = new ConcurrentHashMap<CoverPosition, Byte>();
        }
        switch (mode) {
            case AND: {
                return (byte)(signals.values().stream().map(signal -> signal > 0).reduce(true, (signalA, signalB) -> signalA != false && signalB != false) != false ? 15 : 0);
            }
            case NAND: {
                return (byte)(signals.values().stream().map(signal -> signal > 0).reduce(true, (signalA, signalB) -> signalA != false && signalB != false) != false ? 0 : 15);
            }
            case OR: {
                return (byte)(signals.values().stream().map(signal -> signal > 0).reduce(false, (signalA, signalB) -> signalA != false || signalB != false) != false ? 15 : 0);
            }
            case NOR: {
                return (byte)(signals.values().stream().map(signal -> signal > 0).reduce(false, (signalA, signalB) -> signalA != false || signalB != false) != false ? 0 : 15);
            }
            case SINGLE_SOURCE: {
                if (signals.values().isEmpty()) {
                    return (byte)0;
                }
                return signals.values().iterator().next();
            }
        }
        return (byte)0;
    }

    public static void removeSignalAt(UUID uuid, String frequency, CoverPosition key) {
        Map<String, Map<CoverPosition, Byte>> frequencies = GregTechAPI.sAdvancedWirelessRedstone.get(String.valueOf(uuid));
        if (frequencies == null) {
            return;
        }
        frequencies.computeIfPresent(frequency, (freq, coverPositionByteMap) -> {
            coverPositionByteMap.remove(key);
            return coverPositionByteMap.isEmpty() ? null : coverPositionByteMap;
        });
    }

    public static void setSignalAt(UUID uuid, String frequency, CoverPosition key, byte value) {
        Map frequencies = GregTechAPI.sAdvancedWirelessRedstone.computeIfAbsent(String.valueOf(uuid), k -> new ConcurrentHashMap());
        Map signals = frequencies.computeIfAbsent(frequency, k -> new ConcurrentHashMap());
        signals.put(key, value);
    }

    public static CoverPosition getCoverKey(@NotNull ICoverable tile, ForgeDirection side) {
        return new CoverPosition(tile.getCoords(), tile.getWorld().field_73011_w.func_80007_l(), tile.getWorld().field_73011_w.field_76574_g, side.ordinal());
    }

    @Override
    public boolean letsEnergyIn() {
        return true;
    }

    @Override
    public boolean letsEnergyOut() {
        return true;
    }

    @Override
    public boolean letsFluidIn(Fluid aFluid) {
        return true;
    }

    @Override
    public boolean letsFluidOut(Fluid aFluid) {
        return true;
    }

    @Override
    public boolean letsItemsIn(int aSlot) {
        return true;
    }

    @Override
    public boolean letsItemsOut(int aSlot) {
        return true;
    }

    @Override
    public String getDescription() {
        return StatCollector.func_74837_a((String)"gt.interact.desc.freq_perm", (Object[])new Object[]{this.frequency, this.uuid == null ? StatCollector.func_74838_a((String)"gt.interact.desc.public") : StatCollector.func_74838_a((String)"gt.interact.desc.private")});
    }

    @Override
    public int getMinimumTickRate() {
        return 1;
    }

    @Override
    public int getDefaultTickRate() {
        return 5;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }
}

