/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.ChatMessage;
import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.net.GTPacket;
import gregtech.api.net.GTPacketClearPowerfail;
import gregtech.api.net.GTPacketOnPowerfail;
import gregtech.api.net.GTPacketUpdatePowerfails;
import gregtech.api.util.GTDataUtils;
import gregtech.api.util.GTTextBuilder;
import gregtech.api.util.Localized;
import gregtech.api.util.NBTPersist;
import gregtech.common.config.Gregtech;
import gregtech.common.misc.spaceprojects.SpaceProjectManager;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.event.world.WorldEvent;
import org.jetbrains.annotations.Nullable;

public class GTPowerfailTracker {
    public static final String DATA_NAME = "gt.powerfails";
    private SaveData instance;
    private final HashSet<UUID> pendingUpdates = new HashSet();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(MachineOwner.class, (Object)new TeamAdapter()).registerTypeAdapter(TeamOwner.class, (Object)new TeamAdapter()).registerTypeAdapter(PlayerOwner.class, (Object)new TeamAdapter()).create();

    private static MachineOwner getMachineOwner(UUID player) {
        UUID leader = SpaceProjectManager.getLeader(player);
        if (leader == null) {
            return new PlayerOwner(player);
        }
        return new TeamOwner(leader);
    }

    public void createPowerfailEvent(IGregTechTileEntity igte) {
        if (!Gregtech.machines.enablePowerfailNotifications) {
            return;
        }
        MachineOwner owner = GTPowerfailTracker.getMachineOwner(igte.getOwnerUuid());
        TeamInfo teamInfo = this.instance.powerfailInfo.computeIfAbsent(owner, ignored -> new TeamInfo());
        DimensionInfo dimensionInfo = (DimensionInfo)teamInfo.byWorld.computeIfAbsent(igte.getWorld().field_73011_w.field_76574_g, ignored -> new DimensionInfo());
        long coord = CoordinatePacker.pack((int)igte.getXCoord(), (int)igte.getYCoord(), (int)igte.getZCoord());
        Powerfail powerfail = (Powerfail)dimensionInfo.byCoord.computeIfAbsent(coord, ignored -> new Powerfail());
        powerfail.update(igte);
        owner.sendPacket(new GTPacketOnPowerfail(powerfail));
        this.instance.func_76185_a();
    }

    public void removePowerfailEvents(IGregTechTileEntity igte) {
        this.removePowerfailEvents(igte.getOwnerUuid(), igte.getWorld().field_73011_w.field_76574_g, igte.getXCoord(), igte.getYCoord(), igte.getZCoord());
    }

    public void removePowerfailEvents(UUID ownerId, int worldId, int x, int y, int z) {
        MachineOwner owner = GTPowerfailTracker.getMachineOwner(ownerId);
        TeamInfo teamInfo = this.instance.powerfailInfo.get(owner);
        if (teamInfo == null) {
            return;
        }
        DimensionInfo dimensionInfo = (DimensionInfo)teamInfo.byWorld.get(worldId);
        if (dimensionInfo == null) {
            return;
        }
        long coord = CoordinatePacker.pack((int)x, (int)y, (int)z);
        Powerfail p = (Powerfail)dimensionInfo.byCoord.remove(coord);
        if (p != null) {
            owner.sendPacket(new GTPacketClearPowerfail(p));
            this.instance.func_76185_a();
        }
    }

    public List<Powerfail> getPowerfails(UUID player, OptionalInt inDim) {
        MachineOwner owner = GTPowerfailTracker.getMachineOwner(player);
        return GTDataUtils.ofNullableStream(this.instance.powerfailInfo.get(owner)).flatMap(team -> inDim.isPresent() ? GTDataUtils.ofNullableStream((DimensionInfo)team.byWorld.get(inDim.getAsInt())) : team.byWorld.values().stream()).flatMap(dim -> dim.byCoord.values().stream()).collect(Collectors.toList());
    }

    public void clearPowerfails(EntityPlayerMP player, OptionalInt inDim) {
        MachineOwner owner = GTPowerfailTracker.getMachineOwner(player.func_146103_bH().getId());
        TeamInfo teamInfo = this.instance.powerfailInfo.get(owner);
        if (teamInfo == null) {
            return;
        }
        if (inDim.isPresent()) {
            teamInfo.byWorld.remove(inDim.getAsInt());
        } else {
            teamInfo.byWorld.clear();
        }
        this.pendingUpdates.addAll(owner.getPlayers());
        this.instance.func_76185_a();
    }

    public void sendPlayerPowerfailStatus(EntityPlayerMP player) {
        List<Powerfail> powerfails = this.getPowerfails(player.func_146103_bH().getId(), OptionalInt.of(player.field_71093_bK));
        GTPacketUpdatePowerfails packet = new GTPacketUpdatePowerfails(player.field_71093_bK, powerfails);
        GTValues.NW.sendToPlayer(packet, player);
    }

    @SubscribeEvent
    public void onPlayerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer entityPlayer = event.player;
        if (!(entityPlayer instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)entityPlayer;
        List<Powerfail> powerfails = this.getPowerfails(event.player.func_146103_bH().getId(), OptionalInt.empty());
        if (!powerfails.isEmpty()) {
            new GTTextBuilder(ChatMessage.PowerfailGreeting).setBase(EnumChatFormatting.GRAY).addNumber(powerfails.size()).toLocalized().sendChat(event.player);
            ChatMessage.PowerfailCommandHint.send(event.player, new Object[0]);
        }
        this.sendPlayerPowerfailStatus(playerMP);
    }

    @SubscribeEvent
    public void onPlayerTeleported(PlayerEvent.PlayerChangedDimensionEvent event) {
        EntityPlayer entityPlayer = event.player;
        if (!(entityPlayer instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)entityPlayer;
        this.sendPlayerPowerfailStatus(playerMP);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        EntityPlayer entityPlayer = event.player;
        if (!(entityPlayer instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)entityPlayer;
        this.sendPlayerPowerfailStatus(playerMP);
    }

    @SubscribeEvent
    public void onPostTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (UUID playerId : this.pendingUpdates) {
            EntityPlayerMP player = GTPowerfailTracker.getPlayer(playerId);
            if (player == null) continue;
            this.sendPlayerPowerfailStatus(player);
        }
        this.pendingUpdates.clear();
    }

    private static EntityPlayerMP getPlayer(UUID id) {
        return GTMod.proxy.getPlayerMP(id);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K && event.world.field_73011_w.field_76574_g == 0) {
            this.instance = (SaveData)event.world.field_72988_C.func_75742_a(SaveData.class, DATA_NAME);
            if (this.instance == null) {
                this.instance = new SaveData(DATA_NAME);
                event.world.field_72988_C.func_75745_a(DATA_NAME, (WorldSavedData)this.instance);
            }
            this.instance.func_76185_a();
            this.pendingUpdates.clear();
            MinecraftServer.func_71276_C().func_71203_ab().field_72404_b.stream().map(p -> p.func_146103_bH().getId()).forEach(this.pendingUpdates::add);
        }
    }

    private static final class PlayerOwner
    implements MachineOwner {
        private final UUID player;

        private PlayerOwner(UUID player) {
            this.player = player;
        }

        @Override
        public Set<UUID> getPlayers() {
            return new HashSet<UUID>(Collections.singletonList(this.player));
        }

        @Override
        public boolean isOnline() {
            return GTPowerfailTracker.getPlayer(this.player) != null;
        }

        public String toString() {
            return "PlayerOwner[" + "player=" + this.player + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.player != null ? this.player.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            return Objects.equals(((PlayerOwner)arg0).player, this.player);
            {
            }
        }

        public UUID player() {
            return this.player;
        }
    }

    private static final class TeamOwner
    implements MachineOwner {
        private final UUID leader;

        private TeamOwner(UUID leader) {
            this.leader = leader;
        }

        @Override
        public Set<UUID> getPlayers() {
            return SpaceProjectManager.getTeamMembers(this.leader);
        }

        @Override
        public boolean isOnline() {
            return !this.getPlayers().isEmpty();
        }

        public String toString() {
            return "TeamOwner[" + "leader=" + this.leader + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.leader != null ? this.leader.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            return Objects.equals(((TeamOwner)arg0).leader, this.leader);
            {
            }
        }

        public UUID leader() {
            return this.leader;
        }
    }

    static interface MachineOwner {
        public Set<UUID> getPlayers();

        public boolean isOnline();

        default public List<EntityPlayerMP> getPlayerEntities() {
            return this.getPlayers().stream().map(x$0 -> GTPowerfailTracker.getPlayer(x$0)).filter(Objects::nonNull).collect(Collectors.toList());
        }

        default public void sendPacket(GTPacket packet) {
            for (EntityPlayerMP player : this.getPlayerEntities()) {
                GTValues.NW.sendToPlayer(packet, player);
            }
        }
    }

    public static class SaveData
    extends WorldSavedData {
        final Map<MachineOwner, TeamInfo> powerfailInfo = new HashMap<MachineOwner, TeamInfo>();

        public SaveData(String key) {
            super(key);
        }

        public void func_76184_a(NBTTagCompound tag) {
            this.powerfailInfo.clear();
            try {
                State state = (State)GSON.fromJson(NBTPersist.toJsonObject((NBTBase)tag), State.class);
                if (state != null) {
                    for (TeamPair pair : state.powerfailInfo) {
                        TeamInfo teamInfo = new TeamInfo();
                        this.powerfailInfo.put(pair.owner, teamInfo);
                        for (Int2ObjectMap.Entry dimState : pair.teamState.byWorld.int2ObjectEntrySet()) {
                            DimensionInfo dimInfo = new DimensionInfo();
                            teamInfo.byWorld.put(dimState.getIntKey(), (Object)dimInfo);
                            for (Powerfail powerfail : ((DimState)dimState.getValue()).powerfails) {
                                dimInfo.byCoord.put(powerfail.getCoord(), (Object)powerfail);
                            }
                        }
                    }
                }
            }
            catch (Throwable t) {
                GTMod.GT_FML_LOGGER.warn("Could not load powerfail data", t);
            }
        }

        public void func_76187_b(NBTTagCompound tag) {
            State state = new State();
            this.powerfailInfo.forEach((machineOwner, teamInfo) -> {
                TeamState teamState = new TeamState();
                state.powerfailInfo.add(new TeamPair((MachineOwner)machineOwner, teamState));
                for (Int2ObjectMap.Entry dimInfo : teamInfo.byWorld.int2ObjectEntrySet()) {
                    DimState dimState = new DimState();
                    dimState.powerfails.addAll((Collection<Powerfail>)((DimensionInfo)dimInfo.getValue()).byCoord.values());
                    if (dimState.powerfails.isEmpty()) continue;
                    teamState.byWorld.put(dimInfo.getIntKey(), (Object)dimState);
                }
            });
            JsonElement json = GSON.toJsonTree((Object)state);
            NBTTagCompound nbt = (NBTTagCompound)NBTPersist.toNbt(json);
            tag.field_74784_a.putAll(nbt.field_74784_a);
        }

        static class State {
            final ArrayList<TeamPair> powerfailInfo = new ArrayList();

            State() {
            }
        }

        static class TeamPair {
            public MachineOwner owner;
            public TeamState teamState;

            public TeamPair() {
            }

            public TeamPair(MachineOwner owner, TeamState teamState) {
                this.owner = owner;
                this.teamState = teamState;
            }
        }

        static class TeamState {
            public Int2ObjectOpenHashMap<DimState> byWorld = new Int2ObjectOpenHashMap();

            TeamState() {
            }
        }

        static class DimState {
            public ArrayList<Powerfail> powerfails = new ArrayList();

            DimState() {
            }
        }
    }

    private static class TeamInfo {
        public Int2ObjectOpenHashMap<DimensionInfo> byWorld = new Int2ObjectOpenHashMap();

        private TeamInfo() {
        }
    }

    private static class DimensionInfo {
        public Long2ObjectOpenHashMap<Powerfail> byCoord = new Long2ObjectOpenHashMap();

        private DimensionInfo() {
        }
    }

    public static class Powerfail {
        public int dim;
        public int x;
        public int y;
        public int z;
        public int mteId;
        public int count;
        public Date lastOccurrence;

        public Powerfail copy() {
            Powerfail copy = new Powerfail();
            copy.dim = this.dim;
            copy.x = this.x;
            copy.y = this.y;
            copy.z = this.z;
            copy.mteId = this.mteId;
            copy.count = this.count;
            copy.lastOccurrence = (Date)this.lastOccurrence.clone();
            return copy;
        }

        public long getCoord() {
            return CoordinatePacker.pack((int)this.x, (int)this.y, (int)this.z);
        }

        public void setCoord(long coord) {
            this.x = CoordinatePacker.unpackX((long)coord);
            this.y = CoordinatePacker.unpackY((long)coord);
            this.z = CoordinatePacker.unpackZ((long)coord);
        }

        public float getSecs() {
            return this.lastOccurrence == null ? 0.0f : (float)(new Date().getTime() - this.lastOccurrence.getTime()) / 1000.0f;
        }

        public void update(IGregTechTileEntity igte) {
            this.dim = igte.getWorld().field_73011_w.field_76574_g;
            this.x = igte.getXCoord();
            this.y = igte.getYCoord();
            this.z = igte.getZCoord();
            this.mteId = igte.getMetaTileID();
            ++this.count;
            this.lastOccurrence = new Date();
        }

        @Nullable
        public IMetaTileEntity getMTE() {
            return GTDataUtils.getIndexSafe(GregTechAPI.METATILEENTITIES, this.mteId);
        }

        public String getMTEName() {
            IMetaTileEntity imte = this.getMTE();
            return imte == null ? "<error>" : imte.getLocalName();
        }

        public Localized getDurationText() {
            String key;
            int value;
            float secs = this.getSecs();
            if (secs > 86400.0f) {
                value = (int)(secs / 60.0f / 60.0f / 24.0f);
                key = "GT5U.gui.text.day";
            } else if (secs > 3600.0f) {
                value = (int)(secs / 60.0f / 60.0f);
                key = "GT5U.gui.text.hour";
            } else if (secs > 60.0f) {
                value = (int)(secs / 60.0f);
                key = "GT5U.gui.text.minute";
            } else {
                value = (int)secs;
                key = "GT5U.gui.text.second";
            }
            if (value != 1) {
                key = key + ".plural";
            }
            return new Localized(key, value).setBase(GTTextBuilder.NUMERIC);
        }

        public Localized toSummary() {
            return new GTTextBuilder(ChatMessage.PowerfailWaypoint).setBase(EnumChatFormatting.GRAY).addName(this.getMTEName()).addNumber(this.count).addLocalized(this.getDurationText()).toLocalized();
        }

        public Localized toDescription() {
            return new GTTextBuilder(ChatMessage.PowerfailDescription).setBase(EnumChatFormatting.GRAY).addName(this.getMTEName()).addCoord(this.x, this.y, this.z).addLocalized(new Localized(ChatMessage.Dimension, this.dim).setBase(GTTextBuilder.VALUE)).addNumber(this.count).addLocalized(this.getDurationText()).toLocalized();
        }
    }

    private static class TeamAdapter
    implements JsonSerializer<MachineOwner>,
    JsonDeserializer<MachineOwner> {
        private TeamAdapter() {
        }

        public MachineOwner deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (!(json instanceof JsonPrimitive)) {
                throw new JsonParseException("team must be a string");
            }
            JsonPrimitive primitive = (JsonPrimitive)json;
            if (!primitive.isString()) {
                throw new JsonParseException("team must be a string");
            }
            String string = json.getAsString();
            String[] ownerText = string.split(":");
            if (ownerText.length != 2) {
                throw new JsonParseException("team must be a string of the format [prefix:uuid]");
            }
            try {
                switch (ownerText[0]) {
                    case "team": {
                        return new TeamOwner(UUID.fromString(ownerText[1]));
                    }
                    case "player": {
                        return new PlayerOwner(UUID.fromString(ownerText[1]));
                    }
                }
                throw new JsonParseException("team prefix must be 'team' or 'player'");
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException("invalid team uuid: " + ownerText[1]);
            }
        }

        public JsonElement serialize(MachineOwner src, Type typeOfSrc, JsonSerializationContext context) {
            if (src instanceof TeamOwner) {
                TeamOwner team = (TeamOwner)src;
                return new JsonPrimitive("team:" + team.leader.toString());
            }
            if (src instanceof PlayerOwner) {
                PlayerOwner player = (PlayerOwner)src;
                return new JsonPrimitive("player:" + player.player.toString());
            }
            throw new IllegalArgumentException("expected TeamOwner or PlayerOwner");
        }
    }
}

