/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.render.ISBRWorldContext;
import gregtech.api.render.SBRContextHolder;
import gregtech.common.render.IRenderedBlockSideCheck;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public interface IRenderedBlock {
    @SideOnly(value=Side.CLIENT)
    public ITexture[] getTexture(Block var1, ForgeDirection var2, int var3, boolean[] var4);

    @SideOnly(value=Side.CLIENT)
    public ITexture[] getTexture(Block var1, ForgeDirection var2, boolean var3, int var4);

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(Block var1);

    @SideOnly(value=Side.CLIENT)
    public boolean usesRenderPass(int var1);

    @SideOnly(value=Side.CLIENT)
    public boolean setBlockBounds(Block var1, int var2);

    @SideOnly(value=Side.CLIENT)
    default public boolean renderItem(Block aBlock, RenderBlocks aRenderer) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean renderBlock(Block aBlock, RenderBlocks aRenderer, IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderedBlock passRenderingToObject(ItemStack var1);

    @SideOnly(value=Side.CLIENT)
    public IRenderedBlock passRenderingToObject(IBlockAccess var1, int var2, int var3, int var4);

    public static class ErrorRenderer
    implements IRenderedBlockSideCheck,
    IRenderedBlock {
        public static final ErrorRenderer INSTANCE = new ErrorRenderer();
        public ITexture[] mErrorTexture = Textures.BlockIcons.ERROR_RENDERING;
        private final SBRContextHolder contextHolder = new SBRContextHolder();

        @Override
        public ITexture[] getTexture(Block aBlock, ForgeDirection side, int aRenderPass, boolean[] aShouldSideBeRendered) {
            return this.mErrorTexture;
        }

        @Override
        public ITexture[] getTexture(Block aBlock, ForgeDirection side, boolean isActive, int aRenderPass) {
            return this.mErrorTexture;
        }

        @Override
        public int getRenderPasses(Block aBlock) {
            return 1;
        }

        @Override
        public boolean usesRenderPass(int aRenderPass) {
            return true;
        }

        @Override
        public boolean setBlockBounds(Block aBlock, int aRenderPass) {
            aBlock.func_149676_a(-0.25f, -0.25f, -0.25f, 1.25f, 1.25f, 1.25f);
            return true;
        }

        @Override
        public boolean renderFullBlockSide(Block aBlock, RenderBlocks aRenderer, ForgeDirection side) {
            return true;
        }

        @Override
        public IRenderedBlock passRenderingToObject(ItemStack aStack) {
            return this;
        }

        @Override
        public IRenderedBlock passRenderingToObject(IBlockAccess aWorld, int aX, int aY, int aZ) {
            return this;
        }

        @Override
        public boolean renderBlock(Block aBlock, RenderBlocks aRenderer, IBlockAccess aWorld, int aX, int aY, int aZ) {
            ISBRWorldContext ctx = this.contextHolder.getSBRWorldContext(aX, aY, aZ, aBlock, 0, aRenderer);
            aBlock.func_149676_a(-0.25f, -0.25f, -0.25f, 1.25f, 1.25f, 1.25f);
            ctx.renderNegativeYFacing(this.mErrorTexture);
            ctx.renderPositiveYFacing(this.mErrorTexture);
            ctx.renderNegativeZFacing(this.mErrorTexture);
            ctx.renderPositiveZFacing(this.mErrorTexture);
            ctx.renderNegativeXFacing(this.mErrorTexture);
            ctx.renderPositiveXFacing(this.mErrorTexture);
            return true;
        }
    }
}

