/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.loaders;

import bartworks.common.loaders.ElectricImplosionCompressorRecipes;
import bartworks.system.material.Werkstoff;
import bartworks.system.material.WerkstoffLoader;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.Element;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.objects.GTItemStack;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMapBackend;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class StaticRecipeChangeLoaders {
    private StaticRecipeChangeLoaders() {
    }

    public static void unificationRecipeEnforcer() {
        ArrayList<GTRecipe> toRemove = new ArrayList<GTRecipe>();
        OrePrefixes[] OREPREFIX_VALUES = OrePrefixes.values();
        for (Werkstoff werkstoff : Werkstoff.werkstoffHashSet) {
            StaticRecipeChangeLoaders.runMaterialLinker(werkstoff);
            if (!werkstoff.getGenerationFeatures().enforceUnification) continue;
            HashSet<String> oreDictNames = new HashSet<String>(werkstoff.getADDITIONAL_OREDICT());
            oreDictNames.add(werkstoff.getVarName());
            StaticRecipeChangeLoaders.runMoltenUnificationEnforcement(werkstoff);
            StaticRecipeChangeLoaders.runUnficationDeleter(werkstoff);
            for (String s : oreDictNames) {
                for (OrePrefixes prefixes : OREPREFIX_VALUES) {
                    String fullOreName;
                    List ores;
                    if (!werkstoff.hasItemType(prefixes) || (ores = OreDictionary.getOres((String)(fullOreName = (Object)((Object)prefixes) + s), (boolean)false)).size() <= 1) continue;
                    for (ItemStack toReplace : ores) {
                        ItemStack replacement = werkstoff.get(prefixes);
                        if (toReplace == null || GTUtility.areStacksEqual(toReplace, replacement) || replacement == null || replacement.func_77973_b() == null) continue;
                        for (RecipeMap<?> map : RecipeMap.ALL_RECIPE_MAPS.values()) {
                            toRemove.clear();
                            block5: for (GTRecipe recipe : map.getAllRecipes()) {
                                ItemStack specialItemStack;
                                int i;
                                boolean removal = map.equals(RecipeMaps.fluidExtractionRecipes) || map.equals(RecipeMaps.fluidSolidifierRecipes);
                                for (i = 0; i < recipe.mInputs.length; ++i) {
                                    if (!GTUtility.areStacksEqual(recipe.mInputs[i], toReplace)) continue;
                                    if (removal) {
                                        toRemove.add(recipe);
                                        continue block5;
                                    }
                                    recipe.mInputs[i] = GTUtility.copyAmount(recipe.mInputs[i].field_77994_a, replacement);
                                }
                                for (i = 0; i < recipe.mOutputs.length; ++i) {
                                    if (!GTUtility.areStacksEqual(recipe.mOutputs[i], toReplace)) continue;
                                    if (removal) {
                                        toRemove.add(recipe);
                                        continue block5;
                                    }
                                    recipe.mOutputs[i] = GTUtility.copyAmount(recipe.mOutputs[i].field_77994_a, replacement);
                                }
                                Object object = recipe.mSpecialItems;
                                if (!(object instanceof ItemStack) || !GTUtility.areStacksEqual(specialItemStack = (ItemStack)object, toReplace)) continue;
                                if (removal) {
                                    toRemove.add(recipe);
                                    continue;
                                }
                                recipe.mSpecialItems = GTUtility.copyAmount(specialItemStack.field_77994_a, replacement);
                            }
                            ((RecipeMapBackend)map.getBackend()).removeRecipes(toRemove);
                        }
                    }
                }
            }
        }
    }

    private static void runMoltenUnificationEnforcement(Werkstoff werkstoff) {
        if (werkstoff.getGenerationFeatures().enforceUnification && werkstoff.hasItemType(OrePrefixes.cellMolten)) {
            FluidContainerRegistry.FluidContainerData data = new FluidContainerRegistry.FluidContainerData(new FluidStack(Objects.requireNonNull((Fluid)WerkstoffLoader.molten.get((Object)werkstoff)), 144), werkstoff.get(OrePrefixes.cellMolten), Materials.Empty.getCells(1));
            ItemStack toReplace = null;
            Iterator<Map.Entry<GTItemStack, FluidContainerRegistry.FluidContainerData>> iterator = GTUtility.getFilledContainerToData().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<GTItemStack, FluidContainerRegistry.FluidContainerData> entry = iterator.next();
                String MODID = GameRegistry.findUniqueIdentifierFor((Item)data.filledContainer.func_77973_b()).modId;
                if ("bartworks".equals(MODID) || "bartworkscrossmod".equals(MODID) || !entry.getValue().fluid.equals((Object)data.fluid) || entry.getValue().filledContainer.equals(data.filledContainer)) continue;
                toReplace = entry.getValue().filledContainer;
                iterator.remove();
            }
            HashSet<GTRecipe> toremRecipeList = new HashSet<GTRecipe>();
            if (toReplace != null) {
                for (RecipeMap<?> map : RecipeMap.ALL_RECIPE_MAPS.values()) {
                    toremRecipeList.clear();
                    for (GTRecipe recipe : map.getAllRecipes()) {
                        for (ItemStack mInput : recipe.mInputs) {
                            if (!GTUtility.areStacksEqual(mInput, toReplace)) continue;
                            toremRecipeList.add(recipe);
                        }
                        for (ItemStack mOutput : recipe.mOutputs) {
                            if (!GTUtility.areStacksEqual(mOutput, toReplace)) continue;
                            toremRecipeList.add(recipe);
                            if (map != RecipeMaps.fluidCannerRecipes || !GTUtility.areStacksEqual(mOutput, data.filledContainer) || recipe.mFluidInputs[0].equals((Object)data.fluid)) continue;
                            toremRecipeList.add(recipe);
                        }
                        if (!(recipe.mSpecialItems instanceof ItemStack) || !GTUtility.areStacksEqual((ItemStack)recipe.mSpecialItems, toReplace)) continue;
                        toremRecipeList.add(recipe);
                    }
                    ((RecipeMapBackend)map.getBackend()).removeRecipes(toremRecipeList);
                }
            }
            GTUtility.addFluidContainerData(data);
        }
    }

    private static void runUnficationDeleter(Werkstoff werkstoff) {
        if (werkstoff.getType() == Werkstoff.Types.ELEMENT && werkstoff.getBridgeMaterial() != null && Element.get(werkstoff.getToolTip()) != Element._NULL) {
            werkstoff.getBridgeMaterial().mElement = Element.get(werkstoff.getToolTip());
            Element.get((String)werkstoff.getToolTip()).mLinkedMaterials = new ArrayList();
            Element.get((String)werkstoff.getToolTip()).mLinkedMaterials.add(werkstoff.getBridgeMaterial());
        }
        for (OrePrefixes prefixes : OrePrefixes.values()) {
            if (!werkstoff.hasItemType(prefixes)) continue;
            GTOreDictUnificator.set(prefixes, werkstoff.getBridgeMaterial(), werkstoff.get(prefixes), true, true);
            for (ItemStack stack : OreDictionary.getOres((String)((Object)((Object)prefixes) + werkstoff.getVarName()))) {
                GTOreDictUnificator.addAssociation(prefixes, werkstoff.getBridgeMaterial(), stack, false);
                GTOreDictUnificator.getAssociation((ItemStack)stack).mUnificationTarget = werkstoff.get(prefixes);
            }
        }
    }

    private static void runMaterialLinker(Werkstoff werkstoff) {
        if (werkstoff.getType() == Werkstoff.Types.ELEMENT && werkstoff.getBridgeMaterial() != null && Element.get(werkstoff.getToolTip()) != Element._NULL) {
            werkstoff.getBridgeMaterial().mElement = Element.get(werkstoff.getToolTip());
            Element.get((String)werkstoff.getToolTip()).mLinkedMaterials = new ArrayList();
            Element.get((String)werkstoff.getToolTip()).mLinkedMaterials.add(werkstoff.getBridgeMaterial());
        }
        for (OrePrefixes prefixes : OrePrefixes.values()) {
            if (!werkstoff.hasItemType(prefixes) || werkstoff.getBridgeMaterial() == null) continue;
            GTOreDictUnificator.set(prefixes, werkstoff.getBridgeMaterial(), werkstoff.get(prefixes), true, true);
            for (ItemStack stack : OreDictionary.getOres((String)((Object)((Object)prefixes) + werkstoff.getVarName()))) {
                GTOreDictUnificator.addAssociation(prefixes, werkstoff.getBridgeMaterial(), stack, false);
            }
        }
    }

    public static void addElectricImplosionCompressorRecipes() {
        new ElectricImplosionCompressorRecipes().run();
    }
}

