/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.AssemblyLineUtils;
import gregtech.api.util.GTRecipe;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEHatchDataAccess
extends MTEHatch
implements IAddUIWidgets {
    private int timeout = 4;
    private List<GTRecipe.RecipeAssemblyLine> cachedRecipes = null;

    public MTEHatchDataAccess(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 16, new String[]{"Data Access for Multiblocks", "Adds " + (aTier == 4 ? 4 : 16) + " extra slots for Data Sticks"}, new ITexture[0]);
    }

    public MTEHatchDataAccess(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aTier == 4 ? 4 : 16, aDescription, aTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_DATA_ACCESS)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_DATA_ACCESS)};
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchDataAccess(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        this.openGui(aPlayer);
        return true;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return this.mTier >= 8 && !aBaseMetaTileEntity.isActive();
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return this.mTier >= 8 && !aBaseMetaTileEntity.isActive();
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.isActive()) {
            --this.timeout;
            if (this.timeout <= 0) {
                aBaseMetaTileEntity.setActive(false);
            }
        }
    }

    public void setActive(boolean mActive) {
        this.getBaseMetaTileEntity().setActive(mActive);
        this.timeout = mActive ? 4 : 0;
    }

    @Override
    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.cachedRecipes = null;
    }

    public List<GTRecipe.RecipeAssemblyLine> getAssemblyLineRecipes() {
        if (this.cachedRecipes == null) {
            this.cachedRecipes = new ArrayList<GTRecipe.RecipeAssemblyLine>();
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                this.cachedRecipes.addAll(AssemblyLineUtils.findALRecipeFromDataStick(this.func_70301_a(i)));
            }
        }
        return this.cachedRecipes;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        if (this.mTier == 4) {
            this.getBaseMetaTileEntity().add2by2Slots(builder, new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_CIRCUIT});
        } else {
            this.getBaseMetaTileEntity().add4by4Slots(builder, new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_CIRCUIT});
        }
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("recipeCount", this.getAssemblyLineRecipes().size());
    }

    protected String getWailaDataI18nKey() {
        return "tt.keyphrase.AL_Recipe_Providing";
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currenttip.add(this.translate(this.getWailaDataI18nKey(), tag.func_74762_e("recipeCount")));
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> lines = new ArrayList<String>();
        if (!this.getAssemblyLineRecipes().isEmpty()) {
            for (GTRecipe.RecipeAssemblyLine recipe : this.getAssemblyLineRecipes()) {
                lines.add(this.translate("tt.keyphrase.AL_Recipe_Desc", recipe.mOutput.func_82833_r()));
            }
        } else {
            lines.add(this.translate("tt.keyphrase.AL_Recipe_None"));
        }
        lines.sort(String::compareTo);
        lines.add(0, this.translate("tt.keyphrase.AL_Recipe_Header"));
        return lines.toArray(new String[lines.size()]);
    }
}

