/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import gregtech.api.enums.Textures;
import gregtech.api.gui.widgets.PhantomItemButton;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchOutputBus;
import gregtech.api.render.TextureFactory;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEHatchVoidBus
extends MTEHatchOutputBus {
    private static final String DATA_STICK_DATA_TYPE = "voidBusFilter";
    private static final String LOCKED_ITEMS_NBT_KEY = "lockedItems";
    private final ItemStack[] lockedItems = new ItemStack[4];
    private final IItemHandlerModifiable lockedInventoryHandler = new ItemStackHandler(this.lockedItems);

    public MTEHatchVoidBus(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 1, new String[]{"Voids items from Multiblocks", "Must be configured to work"}, 0);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.ITEM_VOID_SIGN)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.ITEM_VOID_SIGN)};
    }

    public MTEHatchVoidBus(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return false;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchVoidBus(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    protected void setDataStickName(ItemStack dataStick) {
        dataStick.func_151001_c("Void Bus Configuration");
    }

    @Override
    public NBTTagCompound getCopiedData(EntityPlayer player) {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList lockedItemList = new NBTTagList();
        nbt.func_74778_a("type", DATA_STICK_DATA_TYPE);
        for (int i = 0; i < this.lockedItems.length; ++i) {
            if (this.lockedItems[i] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)i);
            this.lockedItems[i].func_77955_b(itemTag);
            lockedItemList.func_74742_a((NBTBase)itemTag);
        }
        nbt.func_74782_a(LOCKED_ITEMS_NBT_KEY, (NBTBase)lockedItemList);
        return nbt;
    }

    @Override
    public boolean pasteCopiedData(EntityPlayer player, NBTTagCompound nbt) {
        if (nbt == null || !DATA_STICK_DATA_TYPE.equals(nbt.func_74779_i("type"))) {
            return false;
        }
        if (!nbt.func_74764_b(LOCKED_ITEMS_NBT_KEY)) {
            return false;
        }
        Arrays.fill(this.lockedItems, null);
        NBTTagList lockedItemList = nbt.func_150295_c(LOCKED_ITEMS_NBT_KEY, 10);
        for (int i = 0; i < lockedItemList.func_74745_c(); ++i) {
            NBTTagCompound itemTag = lockedItemList.func_150305_b(i);
            byte slot = itemTag.func_74771_c("Slot");
            if (slot >= this.lockedItems.length) continue;
            this.lockedItems[slot] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
        }
        return true;
    }

    @Override
    public String getCopiedDataIdentifier(EntityPlayer player) {
        return DATA_STICK_DATA_TYPE;
    }

    @Override
    public boolean storePartial(ItemStack stack, boolean simulate) {
        for (ItemStack lockedItem : this.lockedItems) {
            if (lockedItem == null || !lockedItem.func_77969_a(stack)) continue;
            stack.field_77994_a = 0;
            return true;
        }
        return false;
    }

    @Override
    public boolean pushOutputInventory() {
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        NBTTagList lockedItemList = new NBTTagList();
        for (int i = 0; i < this.lockedItems.length; ++i) {
            if (this.lockedItems[i] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)i);
            this.lockedItems[i].func_77955_b(itemTag);
            lockedItemList.func_74742_a((NBTBase)itemTag);
        }
        aNBT.func_74782_a(LOCKED_ITEMS_NBT_KEY, (NBTBase)lockedItemList);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        NBTTagList lockedItemList = aNBT.func_150295_c(LOCKED_ITEMS_NBT_KEY, 10);
        for (int i = 0; i < lockedItemList.func_74745_c(); ++i) {
            NBTTagCompound itemTag = lockedItemList.func_150305_b(i);
            byte slot = itemTag.func_74771_c("Slot");
            if (slot >= this.lockedItems.length) continue;
            this.lockedItems[slot] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
        }
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        if (this.lockedInventoryHandler == null) {
            return;
        }
        builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.lockedInventoryHandler, (int)2).startFromSlot(0).endAtSlot(3).background(PhantomItemButton.FILTER_BACKGROUND).phantom(true).build().setPos(70, 25));
    }

    public ItemStack[] getLockedItems() {
        return this.lockedItems;
    }

    @Override
    public boolean isLocked() {
        for (ItemStack lockedItem : this.lockedItems) {
            if (lockedItem == null) continue;
            return true;
        }
        return false;
    }
}

