/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.structure;

import gregtech.api.casing.ICasing;
import gregtech.api.casing.ICasingGroup;
import gregtech.api.enums.StructureError;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.structure.CasingInfo;
import gregtech.api.structure.IStructureInstance;
import gregtech.api.structure.IStructureProvider;
import gregtech.api.structure.StructureWrapper;
import gregtech.api.util.GTUtility;
import it.unimi.dsi.fastutil.chars.Char2IntArrayMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class StructureWrapperInstanceInfo<MTE extends MTEMultiBlockBase & IStructureProvider<MTE>>
implements IStructureInstance<MTE> {
    public final StructureWrapper<MTE> structure;
    public Char2IntArrayMap actualCasingCounts = new Char2IntArrayMap();
    public final Object2IntOpenHashMap<ICasingGroup> casingTiers = new Object2IntOpenHashMap();
    private final List<PendingHatch<MTE>> pendingHatches = new ArrayList<PendingHatch<MTE>>();

    public StructureWrapperInstanceInfo(StructureWrapper<MTE> structure) {
        this.structure = structure;
    }

    public void clearHatches() {
        this.actualCasingCounts.clear();
        this.casingTiers.clear();
        this.pendingHatches.clear();
    }

    public void onPostCheck(MTE multi) {
        for (PendingHatch<MTE> hatch : this.pendingHatches) {
            int textureId = ((PendingHatch)hatch).casing.getTextureId(multi, ((PendingHatch)hatch).context);
            ((PendingHatch)hatch).hatch.updateTexture(textureId);
        }
        this.pendingHatches.clear();
    }

    public void validate(Collection<StructureError> errors, NBTTagCompound context) {
        NBTTagList data = new NBTTagList();
        for (Char2ObjectMap.Entry e : this.structure.casings.char2ObjectEntrySet()) {
            int minCasings;
            int presentCasings;
            if (!this.actualCasingCounts.containsKey(e.getCharKey()) || (presentCasings = this.actualCasingCounts.get(e.getCharKey())) >= (minCasings = this.structure.getCasingMin(e.getCharKey()))) continue;
            NBTTagCompound error = new NBTTagCompound();
            error.func_74778_a("casing", Character.toString(e.getCharKey()));
            error.func_74768_a("req", minCasings);
            error.func_74768_a("pres", presentCasings);
            data.func_74742_a((NBTBase)error);
        }
        if (!data.field_74747_a.isEmpty()) {
            errors.add(StructureError.MISSING_STRUCTURE_WRAPPER_CASINGS);
            context.func_74782_a("structureWrapper", (NBTBase)data);
        }
    }

    public void localizeStructureErrors(Collection<StructureError> errors, NBTTagCompound context, List<String> lines) {
        if (!errors.contains((Object)StructureError.MISSING_STRUCTURE_WRAPPER_CASINGS)) {
            return;
        }
        NBTTagList list = context.func_150295_c("structureWrapper", 10);
        for (NBTTagCompound tag : list.field_74747_a) {
            char casing = tag.func_74779_i("casing").charAt(0);
            lines.add(GTUtility.translate("GT5U.gui.missing_casings_specific", ((CasingInfo)this.structure.casings.get((char)casing)).casing.getLocalizedName(), tag.func_74762_e("req"), tag.func_74762_e("pres")));
        }
    }

    @Override
    public void onCasingEncountered(char casing) {
        this.actualCasingCounts.put(casing, this.actualCasingCounts.get(casing) + 1);
    }

    @Override
    public int getCasingTier(ICasingGroup casing, int unset) {
        return this.casingTiers.getOrDefault((Object)casing, unset);
    }

    @Override
    public void setCasingTier(ICasingGroup casing, int tier) {
        this.casingTiers.put((Object)casing, tier);
    }

    @Override
    public void addTieredHatch(MTEHatch hatch, ICasing casing, ICasing.CasingElementContext<MTE> context) {
        this.pendingHatches.add(new PendingHatch(hatch, casing, context));
    }

    private static final class PendingHatch<MTE> {
        private final MTEHatch hatch;
        private final ICasing casing;
        private final ICasing.CasingElementContext<MTE> context;

        private PendingHatch(MTEHatch hatch, ICasing casing, ICasing.CasingElementContext<MTE> context) {
            this.hatch = hatch;
            this.casing = casing;
            this.context = context;
        }

        public String toString() {
            return "PendingHatch[" + "hatch=" + this.hatch + "," + "casing=" + this.casing + "," + "context=" + this.context + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.hatch != null ? this.hatch.hashCode() : 0);
            result = 31 * result + (this.casing != null ? this.casing.hashCode() : 0);
            result = 31 * result + (this.context != null ? this.context.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((PendingHatch)arg0).hatch, this.hatch)) {
                return false;
            }
            if (!Objects.equals(((PendingHatch)arg0).casing, this.casing)) {
                return false;
            }
            return Objects.equals(((PendingHatch)arg0).context, this.context);
            {
            }
        }

        public MTEHatch hatch() {
            return this.hatch;
        }

        public ICasing casing() {
            return this.casing;
        }

        public ICasing.CasingElementContext<MTE> context() {
            return this.context;
        }
    }
}

