/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import gregtech.api.covers.CoverContext;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IBasicEnergyContainer;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicBatteryBuffer;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.Cover;
import gregtech.common.covers.Invertable;
import gregtech.common.covers.gui.CoverEUMeterGui;
import gregtech.common.covers.gui.CoverGui;
import gregtech.common.gui.mui1.cover.EUMeterUIFactory;
import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import org.jetbrains.annotations.NotNull;

public class CoverEUMeter
extends Cover
implements Invertable {
    private EnergyType type = EnergyType.UNIVERSAL_STORAGE;
    private boolean inverted = false;
    private long threshold = 0L;

    public CoverEUMeter(CoverContext context, ITexture coverTexture) {
        super(context, coverTexture);
    }

    public EnergyType getType() {
        return this.type;
    }

    public CoverEUMeter setType(EnergyType type) {
        this.type = type;
        return this;
    }

    @Override
    public boolean isInverted() {
        return this.inverted;
    }

    @Override
    public CoverEUMeter setInverted(boolean inverted) {
        this.inverted = inverted;
        return this;
    }

    public long getThreshold() {
        return this.threshold;
    }

    public CoverEUMeter setThresdhold(long threshold) {
        this.threshold = threshold;
        return this;
    }

    public int getNum() {
        return this.type.ordinal() * 2 + (this.inverted ? 1 : 0);
    }

    public void setNum(int num) {
        this.type = EnergyType.getEnergyType(num / 2);
        this.inverted = num % 2 == 1;
    }

    @Override
    protected void readDataFromNbt(NBTBase nbt) {
        NBTTagCompound tag = (NBTTagCompound)nbt;
        int typeOrdinal = tag.func_74762_e("typeOrdinal");
        this.type = EnergyType.getEnergyType(typeOrdinal);
        this.inverted = tag.func_74767_n("inverted");
        this.threshold = tag.func_74763_f("threshold");
    }

    @Override
    public void readDataFromPacket(ByteArrayDataInput byteData) {
        int typeOrdinal = byteData.readInt();
        this.type = EnergyType.getEnergyType(typeOrdinal);
        this.inverted = byteData.readBoolean();
        this.threshold = byteData.readLong();
    }

    @Override
    @NotNull
    protected NBTBase saveDataToNbt() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("typeOrdinal", this.type.ordinal());
        tag.func_74757_a("inverted", this.inverted);
        tag.func_74772_a("threshold", this.threshold);
        return tag;
    }

    @Override
    protected void writeDataToByteBuf(ByteBuf byteBuf) {
        byteBuf.writeInt(this.type.ordinal());
        byteBuf.writeBoolean(this.inverted);
        byteBuf.writeLong(this.threshold);
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable == null) {
            return;
        }
        long stored = this.type.getTileEntityStoredEnergy(coverable);
        long capacity = this.type.getTileEntityEnergyCapacity(coverable);
        byte redstoneSignal = stored == 0L ? (byte)0 : (stored >= capacity ? (byte)15 : (byte)((byte)(1L + 14L * stored / capacity)));
        if (this.inverted) {
            redstoneSignal = (byte)(15 - redstoneSignal);
        }
        if (this.threshold > 0L) {
            if (this.inverted && stored >= this.threshold) {
                redstoneSignal = 0;
            } else if (!this.inverted && stored < this.threshold) {
                redstoneSignal = 0;
            }
        }
        coverable.setOutputRedstoneSignal(this.coverSide, redstoneSignal);
    }

    @Override
    public void onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        int num = (this.getNum() + (aPlayer.func_70093_af() ? -1 : 1) + EnergyType.values().length * 2) % (EnergyType.values().length * 2);
        switch (num) {
            case 0: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.univ_normal"));
                break;
            }
            case 1: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.univ_invert"));
                break;
            }
            case 2: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.eu_normal"));
                break;
            }
            case 3: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.eu_invert"));
                break;
            }
            case 4: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.steam_normal"));
                break;
            }
            case 5: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.steam_invert"));
                break;
            }
            case 6: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.eu_avg_i_normal"));
                break;
            }
            case 7: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.eu_avg_i_invert"));
                break;
            }
            case 8: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.eu_avg_o_normal"));
                break;
            }
            case 9: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.eu_avg_o_invert"));
                break;
            }
            case 10: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.eu_batt_normal"));
                break;
            }
            case 11: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.eu_batt_invert"));
            }
        }
        this.setNum(num);
    }

    @Override
    public boolean isRedstoneSensitive(long aTimer) {
        return false;
    }

    @Override
    public boolean letsEnergyIn() {
        return true;
    }

    @Override
    public boolean letsEnergyOut() {
        return true;
    }

    @Override
    public boolean letsFluidIn(Fluid aFluid) {
        return true;
    }

    @Override
    public boolean letsFluidOut(Fluid aFluid) {
        return true;
    }

    @Override
    public boolean letsItemsIn(int aSlot) {
        return true;
    }

    @Override
    public boolean letsItemsOut(int aSlot) {
        return true;
    }

    @Override
    public boolean manipulatesSidedRedstoneOutput() {
        return true;
    }

    @Override
    public int getMinimumTickRate() {
        return 20;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    @NotNull
    protected CoverGui<?> getCoverGui() {
        return new CoverEUMeterGui(this);
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new EUMeterUIFactory(buildContext).createWindow();
    }

    public static enum EnergyType {
        UNIVERSAL_STORAGE(StatCollector.func_74838_a((String)"gt.interact.desc.Energy_Detector.universal"), StatCollector.func_74838_a((String)"gt.interact.desc.Energy_Detector.universal.tooltip"), IBasicEnergyContainer::getUniversalEnergyStored, IBasicEnergyContainer::getUniversalEnergyCapacity),
        ELECTRICITY_STORAGE(StatCollector.func_74838_a((String)"gt.interact.desc.Energy_Detector.electricity"), StatCollector.func_74838_a((String)"gt.interact.desc.Energy_Detector.electricity.tooltip"), IBasicEnergyContainer::getStoredEU, IBasicEnergyContainer::getEUCapacity),
        STEAM_STORAGE(StatCollector.func_74838_a((String)"gt.interact.desc.Energy_Detector.steam"), StatCollector.func_74838_a((String)"gt.interact.desc.Energy_Detector.steam.tooltip"), IBasicEnergyContainer::getStoredSteam, IBasicEnergyContainer::getSteamCapacity),
        AVERAGE_ELECTRIC_INPUT(StatCollector.func_74838_a((String)"gt.interact.desc.Energy_Detector.average_in"), StatCollector.func_74838_a((String)"gt.interact.desc.Energy_Detector.average_in.tooltip"), IBasicEnergyContainer::getAverageElectricInput, te -> te.getInputVoltage() * te.getInputAmperage()),
        AVERAGE_ELECTRIC_OUTPUT(StatCollector.func_74838_a((String)"gt.interact.desc.Energy_Detector.average_out"), StatCollector.func_74838_a((String)"gt.interact.desc.Energy_Detector.average_out.tooltip"), IBasicEnergyContainer::getAverageElectricOutput, te -> te.getOutputVoltage() * te.getOutputAmperage()),
        ELECTRICITY_STORAGE_INCLUDING_BATTERIES(StatCollector.func_74838_a((String)"gt.interact.desc.Energy_Detector.eu_stored"), StatCollector.func_74838_a((String)"gt.interact.desc.Energy_Detector.eu_stored.tooltip"), te -> {
            IMetaTileEntity mte;
            if (te instanceof IGregTechTileEntity && (mte = ((IGregTechTileEntity)te).getMetaTileEntity()) instanceof MTEBasicBatteryBuffer) {
                MTEBasicBatteryBuffer buffer = (MTEBasicBatteryBuffer)mte;
                return buffer.getStoredEnergy()[0];
            }
            return te.getStoredEU();
        }, te -> {
            IMetaTileEntity mte;
            if (te instanceof IGregTechTileEntity && (mte = ((IGregTechTileEntity)te).getMetaTileEntity()) instanceof MTEBasicBatteryBuffer) {
                MTEBasicBatteryBuffer buffer = (MTEBasicBatteryBuffer)mte;
                return buffer.getStoredEnergy()[1];
            }
            return te.getEUCapacity();
        });

        private final String title;
        private final String tooltip;
        private final Function<ICoverable, Long> getTileEntityStoredEnergyFunc;
        private final Function<ICoverable, Long> getTileEntityEnergyCapacityFunc;

        private EnergyType(String title, String tooltip, Function<ICoverable, Long> getTileEntityStoredEnergyFunc, Function<ICoverable, Long> getTileEntityEnergyCapacityFunc) {
            this.title = title;
            this.tooltip = tooltip;
            this.getTileEntityStoredEnergyFunc = getTileEntityStoredEnergyFunc;
            this.getTileEntityEnergyCapacityFunc = getTileEntityEnergyCapacityFunc;
        }

        public String getTitle() {
            return this.title;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public long getTileEntityStoredEnergy(ICoverable coverable) {
            return this.getTileEntityStoredEnergyFunc.apply(coverable);
        }

        public long getTileEntityEnergyCapacity(ICoverable coverable) {
            return this.getTileEntityEnergyCapacityFunc.apply(coverable);
        }

        public EnergyType getNext() {
            return EnergyType.values()[(this.ordinal() + 1) % EnergyType.values().length];
        }

        public static EnergyType getEnergyType(int ordinal) {
            if (ordinal < 0 || EnergyType.values().length <= ordinal) {
                ordinal = 0;
            }
            return EnergyType.values()[ordinal];
        }
    }
}

