/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import gregtech.api.covers.CoverContext;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.Cover;
import gregtech.common.gui.mui1.cover.FluidLimiterUIFactory;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class CoverFluidLimiter
extends Cover {
    private float threshold = 1.0f;

    public CoverFluidLimiter(CoverContext context, ITexture coverTexture) {
        super(context, coverTexture);
    }

    public float getThreshold() {
        return this.threshold;
    }

    public CoverFluidLimiter setThreshold(float threshold) {
        this.threshold = threshold;
        return this;
    }

    @Override
    protected void readDataFromNbt(NBTBase nbt) {
        if (nbt instanceof NBTTagCompound) {
            NBTTagCompound tag = (NBTTagCompound)nbt;
            this.threshold = tag.func_74760_g("threshold");
        }
    }

    @Override
    public void readDataFromPacket(ByteArrayDataInput byteData) {
        this.threshold = byteData.readFloat();
    }

    @Override
    @NotNull
    protected NBTBase saveDataToNbt() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74776_a("threshold", this.threshold);
        return tag;
    }

    @Override
    protected void writeDataToByteBuf(ByteBuf byteBuf) {
        byteBuf.writeFloat(this.threshold);
    }

    @Override
    public void onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.coveredTile.get() instanceof IFluidHandler) {
            this.adjustThreshold(!aPlayer.func_70093_af());
            GTUtility.sendChatToPlayer(aPlayer, String.format("Threshold: %f", Float.valueOf(this.threshold)));
        }
    }

    @Override
    public boolean letsFluidIn(Fluid aFluid) {
        Object t = this.coveredTile.get();
        if (t instanceof IFluidHandler) {
            IFluidHandler fluidHandler = (IFluidHandler)t;
            return this.threshold > this.getFillLevelInputSlots(fluidHandler);
        }
        return false;
    }

    @Override
    public boolean alwaysLookConnected() {
        return true;
    }

    private void adjustThreshold(boolean way) {
        if (way) {
            if (this.threshold + 0.05f > 1.0f) {
                this.threshold = 0.0f;
                return;
            }
            this.threshold += 0.05f;
        } else {
            if (Math.abs(this.threshold) - 0.05f < 0.0f) {
                this.threshold = 1.0f;
                return;
            }
            this.threshold -= 0.05f;
        }
    }

    private float getFillLevelInputSlots(IFluidHandler fh) {
        FluidTankInfo[] tankInfo = fh.getTankInfo(ForgeDirection.UNKNOWN);
        if (tankInfo != null) {
            FluidTankInfo inputSlot = tankInfo[0];
            if (inputSlot.fluid != null) {
                long tMax = inputSlot.capacity;
                long tUsed = inputSlot.fluid.amount;
                return (float)tUsed / (float)tMax;
            }
        }
        return 0.0f;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new FluidLimiterUIFactory(buildContext).createWindow();
    }
}

