/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import gregtech.api.covers.CoverContext;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.Cover;
import gregtech.common.covers.Invertable;
import gregtech.common.covers.gui.CoverGui;
import gregtech.common.covers.gui.CoverLiquidMeterGui;
import gregtech.common.gui.mui1.cover.LiquidMeterUIFactory;
import gregtech.common.tileentities.storage.MTEDigitalTankBase;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class CoverLiquidMeter
extends Cover
implements Invertable {
    private boolean inverted = false;
    private int threshold = 0;

    public CoverLiquidMeter(CoverContext context, ITexture coverTexture) {
        super(context, coverTexture);
    }

    @Override
    public boolean isInverted() {
        return this.inverted;
    }

    @Override
    public CoverLiquidMeter setInverted(boolean inverted) {
        this.inverted = inverted;
        return this;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public CoverLiquidMeter setThreshold(int threshold) {
        this.threshold = threshold;
        return this;
    }

    @Override
    protected void readDataFromNbt(NBTBase nbt) {
        NBTTagCompound tag = (NBTTagCompound)nbt;
        this.inverted = tag.func_74767_n("invert");
        this.threshold = tag.func_74762_e("threshold");
    }

    @Override
    public void readDataFromPacket(ByteArrayDataInput byteData) {
        this.inverted = byteData.readBoolean();
        this.threshold = byteData.readInt();
    }

    @Override
    @NotNull
    protected NBTBase saveDataToNbt() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("invert", this.inverted);
        tag.func_74768_a("threshold", this.threshold);
        return tag;
    }

    @Override
    protected void writeDataToByteBuf(ByteBuf byteBuf) {
        byteBuf.writeBoolean(this.inverted);
        byteBuf.writeInt(this.threshold);
    }

    public static byte computeSignalBasedOnFluid(ICoverable tileEntity, boolean inverted, int threshold) {
        if (tileEntity instanceof IFluidHandler) {
            FluidTankInfo[] tanks = ((IFluidHandler)tileEntity).getTankInfo(ForgeDirection.UNKNOWN);
            long max = 0L;
            long used = 0L;
            if (tanks != null) {
                for (FluidTankInfo tank : tanks) {
                    if (tank == null) continue;
                    max = tileEntity instanceof BaseMetaTileEntity && ((BaseMetaTileEntity)tileEntity).getMetaTileEntity() instanceof MTEDigitalTankBase ? (max += (long)((MTEDigitalTankBase)((BaseMetaTileEntity)tileEntity).getMetaTileEntity()).getRealCapacity()) : (max += (long)tank.capacity);
                    FluidStack tLiquid = tank.fluid;
                    if (tLiquid == null) continue;
                    used += (long)tLiquid.amount;
                }
            }
            return GTUtility.convertRatioToRedstone(used, max, threshold, inverted);
        }
        return 0;
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable != null) {
            byte signal = CoverLiquidMeter.computeSignalBasedOnFluid(coverable, this.inverted, this.threshold);
            coverable.setOutputRedstoneSignal(this.coverSide, signal);
        }
    }

    @Override
    public void onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.inverted) {
            this.inverted = false;
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.normal"));
        } else {
            this.inverted = true;
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.inverted"));
        }
    }

    @Override
    public boolean letsEnergyIn() {
        return true;
    }

    @Override
    public boolean letsEnergyOut() {
        return true;
    }

    @Override
    public boolean letsFluidIn(Fluid aFluid) {
        return true;
    }

    @Override
    public boolean letsFluidOut(Fluid aFluid) {
        return true;
    }

    @Override
    public boolean letsItemsIn(int aSlot) {
        return true;
    }

    @Override
    public boolean letsItemsOut(int aSlot) {
        return true;
    }

    @Override
    public boolean manipulatesSidedRedstoneOutput() {
        return true;
    }

    @Override
    public int getMinimumTickRate() {
        return 1;
    }

    @Override
    public int getDefaultTickRate() {
        return 5;
    }

    private int getMaxCapacity() {
        ICoverable tile = this.getTile();
        if (!tile.isDead() && tile instanceof IFluidHandler) {
            FluidTankInfo[] tanks = ((IFluidHandler)tile).getTankInfo(ForgeDirection.UNKNOWN);
            return Arrays.stream(tanks).mapToInt(tank -> tank.capacity).sum();
        }
        return -1;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @NotNull
    protected CoverGui<CoverLiquidMeter> getCoverGui() {
        return new CoverLiquidMeterGui(this, this.getMaxCapacity());
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new LiquidMeterUIFactory(buildContext, this.getMaxCapacity()).createWindow();
    }
}

