/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.redstone;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import gregtech.api.covers.CoverContext;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.common.covers.CoverPosition;
import gregtech.common.covers.redstone.CoverAdvancedRedstoneTransmitterBase;
import gregtech.common.gui.mui1.cover.WirelessActivityDetectorUIFactory;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class CoverWirelessDoesWorkDetector
extends CoverAdvancedRedstoneTransmitterBase {
    private ActivityMode mode = ActivityMode.MACHINE_IDLE;
    private boolean physical = true;

    public CoverWirelessDoesWorkDetector(CoverContext context, ITexture coverTexture) {
        super(context, coverTexture);
    }

    public ActivityMode getMode() {
        return this.mode;
    }

    public CoverWirelessDoesWorkDetector setMode(ActivityMode mode) {
        this.mode = mode;
        return this;
    }

    public boolean isPhysical() {
        return this.physical;
    }

    public CoverWirelessDoesWorkDetector setPhysical(boolean physical) {
        this.physical = physical;
        return this;
    }

    @Override
    protected void readDataFromNbt(NBTBase nbt) {
        super.readDataFromNbt(nbt);
        NBTTagCompound tag = (NBTTagCompound)nbt;
        this.mode = ActivityMode.values()[tag.func_74762_e("mode")];
        this.physical = tag.func_74764_b("physical") ? tag.func_74767_n("physical") : false;
    }

    @Override
    public void readDataFromPacket(ByteArrayDataInput byteData) {
        super.readDataFromPacket(byteData);
        this.mode = ActivityMode.values()[byteData.readInt()];
        this.physical = byteData.readBoolean();
    }

    @Override
    @NotNull
    protected NBTBase saveDataToNbt() {
        NBTTagCompound tag = (NBTTagCompound)super.saveDataToNbt();
        tag.func_74768_a("mode", this.mode.ordinal());
        tag.func_74757_a("physical", this.physical);
        return tag;
    }

    @Override
    protected void writeDataToByteBuf(ByteBuf byteBuf) {
        super.writeDataToByteBuf(byteBuf);
        byteBuf.writeInt(this.mode.ordinal());
        byteBuf.writeBoolean(this.physical);
    }

    private byte computeSignalBasedOnActivity(ICoverable tileEntity) {
        if (tileEntity instanceof IMachineProgress) {
            IMachineProgress mProgress = (IMachineProgress)((Object)tileEntity);
            boolean inverted = this.invert;
            int signal = 0;
            switch (this.mode) {
                case MACHINE_ENABLED: {
                    signal = inverted == mProgress.isAllowedToWork() ? 0 : 15;
                    break;
                }
                case MACHINE_IDLE: {
                    signal = inverted == (mProgress.getMaxProgress() == 0) ? 0 : 15;
                    break;
                }
                case RECIPE_PROGRESS: {
                    int tScale = mProgress.getMaxProgress() / 15;
                    signal = tScale > 0 && mProgress.hasThingsToDo() ? (inverted ? 15 - mProgress.getProgress() / tScale : mProgress.getProgress() / tScale) : (inverted ? 15 : 0);
                }
            }
            return (byte)signal;
        }
        return 0;
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable == null) {
            return;
        }
        byte signal = this.computeSignalBasedOnActivity(coverable);
        CoverPosition key = CoverWirelessDoesWorkDetector.getCoverKey(coverable, this.coverSide);
        CoverWirelessDoesWorkDetector.setSignalAt(this.getUuid(), this.getFrequency(), key, signal);
        if (this.physical) {
            coverable.setOutputRedstoneSignal(this.coverSide, signal);
        } else {
            coverable.setOutputRedstoneSignal(this.coverSide, (byte)0);
        }
    }

    @Override
    public boolean letsRedstoneGoOut() {
        return true;
    }

    @Override
    public boolean manipulatesSidedRedstoneOutput() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new WirelessActivityDetectorUIFactory(buildContext).createWindow();
    }

    public static enum ActivityMode {
        RECIPE_PROGRESS,
        MACHINE_IDLE,
        MACHINE_ENABLED;

    }
}

