/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.redstone;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import gregtech.api.covers.CoverContext;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.common.covers.CoverNeedMaintainance;
import gregtech.common.covers.CoverPosition;
import gregtech.common.covers.redstone.CoverAdvancedRedstoneTransmitterBase;
import gregtech.common.gui.mui1.cover.WirelessMaintenanceDetectorUIFactory;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class CoverWirelessMaintenanceDetector
extends CoverAdvancedRedstoneTransmitterBase {
    private MaintenanceMode mode = MaintenanceMode.ONE_ISSUE;
    private boolean physical = true;

    public CoverWirelessMaintenanceDetector(CoverContext context, ITexture coverTexture) {
        super(context, coverTexture);
    }

    public MaintenanceMode getMode() {
        return this.mode;
    }

    public CoverWirelessMaintenanceDetector setMode(MaintenanceMode mode) {
        this.mode = mode;
        return this;
    }

    public boolean isPhysical() {
        return this.physical;
    }

    public CoverWirelessMaintenanceDetector setPhysical(boolean physical) {
        this.physical = physical;
        return this;
    }

    @Override
    protected void readDataFromNbt(NBTBase nbt) {
        super.readDataFromNbt(nbt);
        NBTTagCompound tag = (NBTTagCompound)nbt;
        this.mode = MaintenanceMode.values()[tag.func_74762_e("mode")];
        this.physical = tag.func_74764_b("physical") ? tag.func_74767_n("physical") : false;
    }

    @Override
    public void readDataFromPacket(ByteArrayDataInput byteData) {
        super.readDataFromPacket(byteData);
        this.mode = MaintenanceMode.values()[byteData.readInt()];
        this.physical = byteData.readBoolean();
    }

    @Override
    @NotNull
    protected NBTBase saveDataToNbt() {
        NBTTagCompound tag = (NBTTagCompound)super.saveDataToNbt();
        tag.func_74768_a("mode", this.mode.ordinal());
        tag.func_74757_a("physical", this.physical);
        return tag;
    }

    @Override
    protected void writeDataToByteBuf(ByteBuf byteBuf) {
        super.writeDataToByteBuf(byteBuf);
        byteBuf.writeInt(this.mode.ordinal());
        byteBuf.writeBoolean(this.physical);
    }

    private byte computeSignalBasedOnMaintenance(ICoverable tileEntity) {
        IMetaTileEntity metaTE;
        boolean signal = false;
        if (tileEntity instanceof IGregTechTileEntity && (metaTE = ((IGregTechTileEntity)tileEntity).getMetaTileEntity()) instanceof MTEMultiBlockBase) {
            MTEMultiBlockBase multiTE = (MTEMultiBlockBase)metaTE;
            int ideal = multiTE.getIdealStatus();
            int real = multiTE.getRepairStatus();
            switch (this.mode) {
                case NO_ISSUE: {
                    signal = ideal == real;
                    break;
                }
                case ONE_ISSUE: 
                case TWO_ISSUES: 
                case THREE_ISSUES: 
                case FOUR_ISSUES: 
                case FIVE_ISSUES: {
                    signal = ideal - real >= this.mode.ordinal();
                    break;
                }
                case ROTOR_80: 
                case ROTOR_100: {
                    ItemStack rotor = multiTE.getRealInventory()[1];
                    if (CoverNeedMaintainance.isRotor(rotor)) {
                        long max = MetaGeneratedTool.getToolMaxDamage(rotor);
                        long current = MetaGeneratedTool.getToolDamage(rotor);
                        if (this.mode == MaintenanceMode.ROTOR_80) {
                            signal = current >= max * 8L / 10L;
                            break;
                        }
                        long expectedDamage = Math.round(Math.min((double)multiTE.mEUt / (double)multiTE.damageFactorLow, Math.pow(multiTE.mEUt, multiTE.damageFactorHigh)));
                        signal = current + expectedDamage * 2L >= max;
                        break;
                    }
                    signal = true;
                }
            }
        }
        if (this.invert) {
            signal = !signal;
        }
        return (byte)(signal ? 15 : 0);
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable == null) {
            return;
        }
        byte signal = this.computeSignalBasedOnMaintenance(coverable);
        CoverPosition key = CoverWirelessMaintenanceDetector.getCoverKey(coverable, this.coverSide);
        CoverWirelessMaintenanceDetector.setSignalAt(this.getUuid(), this.getFrequency(), key, signal);
        if (this.physical) {
            coverable.setOutputRedstoneSignal(this.coverSide, signal);
        } else {
            coverable.setOutputRedstoneSignal(this.coverSide, (byte)0);
        }
    }

    @Override
    public boolean letsRedstoneGoOut() {
        return true;
    }

    @Override
    public boolean manipulatesSidedRedstoneOutput() {
        return true;
    }

    @Override
    public int getMinimumTickRate() {
        return 60;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new WirelessMaintenanceDetectorUIFactory(buildContext).createWindow();
    }

    public static enum MaintenanceMode {
        NO_ISSUE,
        ONE_ISSUE,
        TWO_ISSUES,
        THREE_ISSUES,
        FOUR_ISSUES,
        FIVE_ISSUES,
        ROTOR_80,
        ROTOR_100;

    }
}

