/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.misc.spaceprojects.interfaces;

import com.gtnewhorizons.modularui.api.drawable.UITexture;
import gregtech.common.misc.spaceprojects.enums.SpaceBodyType;
import gregtech.common.misc.spaceprojects.enums.StarType;
import gregtech.common.misc.spaceprojects.enums.UpgradeStatus;
import gregtech.common.misc.spaceprojects.interfaces.ISpaceBody;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public interface ISpaceProject {
    public String getProjectName();

    public String getUnlocalizedName();

    public String getLocalizedName();

    public long getProjectVoltage();

    public int getProjectBuildTime();

    public float getProjectCurrentProgress();

    public int getProjectTier();

    public int getCurrentStage();

    public int getTotalStages();

    public Collection<ISP_Upgrade> getAllUpgrades();

    public Map<String, ISP_Upgrade> getUpgradesBuiltMap();

    public Collection<ISP_Upgrade> getAllBuiltUpgrades();

    public ISP_Upgrade getUpgrade(String var1);

    public ItemStack[] getItemsCostPerStage();

    public ItemStack getItemCostPerStage(int var1);

    public ItemStack[] getCurrentItemsProgress();

    public ItemStack getCurrentItemProgress(int var1);

    public ItemStack[] getTotalItemsCost();

    public ItemStack getTotalItemCost(int var1);

    public FluidStack[] getFluidsCostPerStage();

    public FluidStack getFluidCostPerStage(int var1);

    public FluidStack[] getCurrentFluidsProgress();

    public FluidStack getCurrentFluidProgress(int var1);

    public FluidStack[] getTotalFluidsCost();

    public FluidStack getTotalFluidCost(int var1);

    public ISP_Upgrade getUpgradeBeingBuilt();

    public ISpaceBody getProjectLocation();

    public UITexture getTexture();

    public void setProjectCurrentStage(int var1);

    public void setCurrentUpgradeBeingBuilt(ISP_Upgrade var1);

    public void setProjectLocation(ISpaceBody var1);

    public void setBuiltUpgrade(ISP_Upgrade ... var1);

    public void goToNextStage();

    public ISpaceProject copy();

    public boolean meetsRequirements(UUID var1);

    public boolean meetsRequirements(UUID var1, boolean var2);

    public boolean isFinished();

    public boolean hasUpgrade(String var1);

    public static interface ISP_Requirements {
        public SpaceBodyType getBodyType();

        public StarType getStarType();

        public List<ISpaceProject> getProjects();

        public List<ISP_Upgrade> getUpgrades();
    }

    public static interface ISP_Upgrade {
        public String getUpgradeName();

        public String getUnlocalizedName();

        public String getLocalizedName();

        public ItemStack[] getItemsCostPerStage();

        public ItemStack getItemCostPerStage(int var1);

        public ItemStack[] getCurrentItemsProgress();

        public ItemStack getCurrentItemProgress(int var1);

        public ItemStack[] getTotalItemsCost();

        public ItemStack getTotalItemCost(int var1);

        public FluidStack[] getFluidsCostPerStage();

        public FluidStack getFluidCostPerStage(int var1);

        public FluidStack[] getCurrentFluidsProgress();

        public FluidStack getCurrentFluidProgress(int var1);

        public FluidStack[] getTotalFluidsCost();

        public FluidStack getTotalFluidCost(int var1);

        public int getTotalStages();

        public int getUpgradeBuildTime();

        public int getCurrentStage();

        public float getCurrentProgress();

        public long getVoltage();

        public UpgradeStatus getStatus();

        public ISP_Requirements getUpgradeRequirements();

        public ISpaceProject getParentProject();

        public void setUpgradeProject(ISpaceProject var1);

        public void setUpgradeCurrentStage(int var1);

        public boolean meetsRequirements(UUID var1);

        public ISP_Upgrade copy();

        public void goToNextStage();

        public boolean isFinished();
    }
}

