/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.modularui2.widget;

import com.cleanroommc.modularui.api.IPanelHandler;
import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.drawable.DrawableStack;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.MouseData;
import com.cleanroommc.modularui.value.sync.IntSyncValue;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import com.cleanroommc.modularui.widgets.slot.PhantomItemSlot;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.modularui2.GTGuiTextures;
import gregtech.api.modularui2.GTGuis;
import gregtech.api.util.GTUtility;
import gregtech.common.modularui2.factory.SelectItemGuiBuilder;
import gregtech.common.modularui2.sync.GhostCircuitSyncHandler;
import org.jetbrains.annotations.NotNull;

public class GhostCircuitSlotWidget
extends PhantomItemSlot {
    private static final String GUI_ID = "circuit_selector";
    private final IMetaTileEntity mte;
    private final IntSyncValue selectedSyncHandler;
    private IPanelHandler selectorPanelHandler;

    public GhostCircuitSlotWidget(IMetaTileEntity mte, IntSyncValue selectedSyncHandler) {
        this.mte = mte;
        this.selectedSyncHandler = selectedSyncHandler;
        this.tooltipBuilder(this::getCircuitSlotTooltip);
    }

    public IDrawable getCurrentBackground(ITheme theme, WidgetTheme widgetTheme) {
        IDrawable background = super.getCurrentBackground(theme, widgetTheme);
        return new DrawableStack(new IDrawable[]{background, GTGuiTextures.OVERLAY_SLOT_INT_CIRCUIT});
    }

    @NotNull
    public Interactable.Result onMousePressed(int mouseButton) {
        if (!this.isSelectorPanelOpen()) {
            if (mouseButton == 0 && Interactable.hasShiftDown()) {
                this.openSelectorPanel();
            } else {
                MouseData mouseData = MouseData.create((int)mouseButton);
                this.getSyncHandler().syncToServer(100, arg_0 -> ((MouseData)mouseData).writeToPacket(arg_0));
            }
        }
        return Interactable.Result.SUCCESS;
    }

    public boolean onMouseScroll(ModularScreen.UpOrDown scrollDirection, int amount) {
        if (this.isSelectorPanelOpen()) {
            return true;
        }
        MouseData mouseData = MouseData.create((int)scrollDirection.modifier);
        this.getSyncHandler().syncToServer(101, arg_0 -> ((MouseData)mouseData).writeToPacket(arg_0));
        return true;
    }

    public PhantomItemSlot slot(ModularSlot slot) {
        GhostCircuitSyncHandler sh = new GhostCircuitSyncHandler(slot);
        this.isValidSyncHandler((SyncHandler)sh);
        this.setSyncHandler((SyncHandler)sh);
        return this;
    }

    private void getCircuitSlotTooltip(RichTooltip tooltip) {
        int config = this.getSyncHandler().getGhostCircuitHandler().getCircuitConfig();
        String configString = config == -1 ? IKey.lang((String)"GT5U.machines.select_circuit.tooltip.configuration.none").get() : String.valueOf(config);
        ((RichTooltip)((RichTooltip)((RichTooltip)((RichTooltip)((RichTooltip)((RichTooltip)tooltip.clearText()).addLine((IDrawable)IKey.lang((String)"GT5U.machines.select_circuit.tooltip"))).spaceLine(2)).addLine((IDrawable)IKey.lang((String)"GT5U.machines.select_circuit.tooltip.configuration", (Object[])new Object[]{configString}))).addLine((IDrawable)IKey.lang((String)"GT5U.machines.select_circuit.tooltip.1"))).addLine((IDrawable)IKey.lang((String)"GT5U.machines.select_circuit.tooltip.2"))).addLine((IDrawable)IKey.lang((String)"GT5U.machines.select_circuit.tooltip.3"));
    }

    @NotNull
    public GhostCircuitSyncHandler getSyncHandler() {
        return (GhostCircuitSyncHandler)super.getSyncHandler();
    }

    private boolean isSelectorPanelOpen() {
        return this.getPanel().getScreen().isPanelOpen(GUI_ID);
    }

    private void openSelectorPanel() {
        if (this.selectorPanelHandler == null) {
            this.selectorPanelHandler = this.buildSelectorPanel(this.selectedSyncHandler);
        }
        this.selectorPanelHandler.openPanel();
    }

    private IPanelHandler buildSelectorPanel(IntSyncValue selectedSyncHandler) {
        return IPanelHandler.simple((ModularPanel)this.getPanel(), (mainPanel, player) -> {
            ModularPanel panel = GTGuis.createPopUpPanel(GUI_ID);
            return new SelectItemGuiBuilder(panel, GTUtility.getAllIntegratedCircuits()).setHeaderItem(this.mte.getStackForm(1L)).setTitle(IKey.lang((String)"GT5U.machines.select_circuit")).setSelectedSyncHandler(selectedSyncHandler).setOnSelectedClientAction((selected, mouseData) -> {
                this.getSyncHandler().syncToServer(10, buffer -> {
                    int circuitConfig = selected == -1 ? -1 : selected + 1;
                    buffer.writeShort(circuitConfig);
                });
                if (mouseData.shift) {
                    panel.animateClose();
                }
            }).setCurrentItemSlotOverlay((IDrawable)GTGuiTextures.OVERLAY_SLOT_INT_CIRCUIT).setAllowDeselected(true).build();
        }, (boolean)true);
    }
}

