/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import gregtech.api.interfaces.IColorModulationContainer;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.render.ISBRContext;
import gregtech.api.render.TextureFactory;
import gregtech.common.render.GTTextureBase;

public class GTSidedTextureRender
extends GTTextureBase
implements ITexture,
IColorModulationContainer {
    protected final ITexture[] mTextures;
    private final short[] mRGBa;

    protected GTSidedTextureRender(IIconContainer aIcon0, IIconContainer aIcon1, IIconContainer aIcon2, IIconContainer aIcon3, IIconContainer aIcon4, IIconContainer aIcon5, short[] aRGBa, boolean aAllowAlpha) {
        if (aRGBa.length != 4) {
            throw new IllegalArgumentException("RGBa doesn't have 4 Values @ GTSidedTextureRender");
        }
        this.mTextures = new ITexture[]{TextureFactory.of(aIcon0, aRGBa, aAllowAlpha), TextureFactory.of(aIcon1, aRGBa, aAllowAlpha), TextureFactory.of(aIcon2, aRGBa, aAllowAlpha), TextureFactory.of(aIcon3, aRGBa, aAllowAlpha), TextureFactory.of(aIcon4, aRGBa, aAllowAlpha), TextureFactory.of(aIcon5, aRGBa, aAllowAlpha)};
        this.mRGBa = aRGBa;
    }

    @Override
    public void renderXPos(ISBRContext ctx) {
        this.mTextures[5].renderXPos(ctx);
    }

    @Override
    public void renderXNeg(ISBRContext ctx) {
        this.mTextures[4].renderXNeg(ctx);
    }

    @Override
    public void renderYPos(ISBRContext ctx) {
        this.mTextures[1].renderYPos(ctx);
    }

    @Override
    public void renderYNeg(ISBRContext ctx) {
        this.mTextures[0].renderYNeg(ctx);
    }

    @Override
    public void renderZPos(ISBRContext ctx) {
        this.mTextures[3].renderZPos(ctx);
    }

    @Override
    public void renderZNeg(ISBRContext ctx) {
        this.mTextures[2].renderZNeg(ctx);
    }

    @Override
    public short[] getRGBA() {
        return this.mRGBa;
    }

    @Override
    public boolean isValidTexture() {
        for (ITexture renderedTexture : this.mTextures) {
            if (renderedTexture.isValidTexture()) continue;
            return false;
        }
        return true;
    }
}

