/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.automation;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTESpecialFilter;
import gregtech.api.objects.ItemData;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class MTETypeFilter
extends MTESpecialFilter {
    private static final String REPRESENTATION_SLOT_TOOLTIP = "GT5U.type_filter.representation_slot.tooltip";
    public int mRotationIndex = 0;
    public OrePrefixes mPrefix = OrePrefixes.ore;
    public static ImmutableList<OrePrefixes> OREBLOCK_PREFIXES = ImmutableList.of((Object)((Object)OrePrefixes.oreBlackgranite), (Object)((Object)OrePrefixes.oreDense), (Object)((Object)OrePrefixes.oreEnd), (Object)((Object)OrePrefixes.oreEndstone), (Object)((Object)OrePrefixes.oreNether), (Object)((Object)OrePrefixes.oreNetherrack), (Object)((Object)OrePrefixes.oreNormal), (Object)((Object)OrePrefixes.orePoor), (Object)((Object)OrePrefixes.oreRedgranite), (Object)((Object)OrePrefixes.oreRich), (Object)((Object)OrePrefixes.oreSmall), (Object)((Object)OrePrefixes.oreBasalt), (Object[])new OrePrefixes[]{OrePrefixes.oreMarble});

    public MTETypeFilter(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, new String[]{"Filters 1 Item Type", "Use Screwdriver to regulate output stack size"});
    }

    public MTETypeFilter(String aName, int aTier, int aInvSlotCount, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTETypeFilter(this.mName, this.mTier, this.mInventory.length, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public ITexture getOverlayIcon() {
        return TextureFactory.of(TextureFactory.of(Textures.BlockIcons.AUTOMATION_TYPEFILTER), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.AUTOMATION_TYPEFILTER_GLOW).glow().build());
    }

    public void clickTypeIcon(boolean aRightClick, ItemStack aHandStack) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (aHandStack != null) {
                this.copyHeldItemPrefix(aHandStack);
            } else {
                this.cyclePrefix(aRightClick);
            }
        }
    }

    private void copyHeldItemPrefix(ItemStack handStack) {
        ItemData data = GTOreDictUnificator.getAssociation(handStack);
        if (data != null && data.hasValidPrefixData()) {
            this.mPrefix = data.mPrefix;
            this.mRotationIndex = -1;
        }
    }

    private void cyclePrefix(boolean aRightClick) {
        OrePrefixes[] ORE_VALUES = OrePrefixes.values();
        for (int i = 0; i < ORE_VALUES.length; ++i) {
            if (this.mPrefix == ORE_VALUES[i]) {
                this.mPrefix = null;
                while (this.mPrefix == null) {
                    if (aRightClick) {
                        do {
                            if (--i >= 0) continue;
                            i = ORE_VALUES.length - 1;
                        } while (ORE_VALUES[i].mPrefixedItems.isEmpty());
                    } else {
                        do {
                            if (++i < ORE_VALUES.length) continue;
                            i = 0;
                        } while (ORE_VALUES[i].mPrefixedItems.isEmpty());
                    }
                    if (!ORE_VALUES[i].mPrefixedItems.isEmpty() && ORE_VALUES[i].mPrefixInto == ORE_VALUES[i]) {
                        this.mPrefix = ORE_VALUES[i];
                    }
                    this.mPrefix = ORE_VALUES[i];
                }
            }
            this.mRotationIndex = -1;
        }
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (!this.getBaseMetaTileEntity().isServerSide() || aTick % 8L != 0L && this.mRotationIndex != -1) {
            return;
        }
        if (this.mPrefix.mPrefixedItems.isEmpty()) {
            this.mInventory[9] = null;
            return;
        }
        this.mRotationIndex = (this.mRotationIndex + 1) % this.mPrefix.mPrefixedItems.size();
        this.mInventory[9] = GTUtility.copyAmount(1, this.mPrefix.mPrefixedItems.get(this.mRotationIndex));
        if (this.mInventory[9] == null) {
            return;
        }
        if (this.mInventory[9].func_77960_j() == Short.MAX_VALUE) {
            this.mInventory[9].func_77964_b(0);
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74778_a("mPrefix", this.mPrefix.toString());
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mPrefix = OrePrefixes.getPrefix(aNBT.func_74779_i("mPrefix"), this.mPrefix);
    }

    @Override
    protected boolean isStackAllowed(ItemStack aStack) {
        ItemData data;
        if (this.mPrefix == OrePrefixes.ore && (data = GTOreDictUnificator.getItemData(aStack)) != null && data.mPrefix != null && OREBLOCK_PREFIXES.contains((Object)data.mPrefix)) {
            return true;
        }
        return this.mPrefix.contains(aStack);
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        builder.widget((Widget)new FakeSyncWidget.StringSyncer(() -> this.mPrefix.toString(), prefix -> {
            this.mPrefix = OrePrefixes.getPrefix(prefix, this.mPrefix);
        }));
    }

    @Override
    protected Function<List<String>, List<String>> getItemStackReplacementTooltip() {
        return itemTooltip -> {
            ArrayList<String> replacementTooltip = new ArrayList<String>();
            replacementTooltip.add("Filter set to " + this.mPrefix.mRegularLocalName);
            replacementTooltip.add("Ore prefix: \u00a7e" + (Object)((Object)this.mPrefix) + "\u00a7r");
            replacementTooltip.add("Filter size: \u00a7e" + this.mPrefix.mPrefixedItems.size() + "\u00a7r");
            replacementTooltip.addAll(this.mTooltipCache.getData((String)REPRESENTATION_SLOT_TOOLTIP, (Object[])new Object[0]).text);
            return replacementTooltip;
        };
    }

    @Override
    protected SlotWidget createFilterIconSlot(BaseSlot slot) {
        return new TypeFilterIconSlotWidget(slot);
    }

    private class TypeFilterIconSlotWidget
    extends MTESpecialFilter.FilterIconSlotWidget {
        public TypeFilterIconSlotWidget(BaseSlot slot) {
            super(slot);
        }

        @Override
        protected void phantomClick(Widget.ClickData clickData, ItemStack cursorStack) {
            MTETypeFilter.this.clickTypeIcon(clickData.mouseButton != 0, cursorStack);
        }
    }
}

