/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines;

import gregtech.common.tileentities.machines.IDualInputInventory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public interface IDualInputHatch {
    public boolean justUpdated();

    public Iterator<? extends IDualInputInventory> inventories();

    public void updateTexture(int var1);

    public void updateCraftingIcon(ItemStack var1);

    public Optional<IDualInputInventory> getFirstNonEmptyInventory();

    public boolean supportsFluids();

    public ItemStack[] getSharedItems();

    default public ItemStack[] getAllItems() {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        for (ItemStack item : this.getSharedItems()) {
            if (item == null) continue;
            rList.add(item);
        }
        Iterator<? extends IDualInputInventory> inventoryIterator = this.inventories();
        while (inventoryIterator.hasNext()) {
            ItemStack[] items = inventoryIterator.next().getItemInputs();
            if (items == null) continue;
            for (ItemStack item : items) {
                if (item == null) continue;
                rList.add(item);
            }
        }
        return rList.toArray(new ItemStack[rList.size()]);
    }

    default public FluidStack[] getAllFluids() {
        ArrayList<FluidStack> rList = new ArrayList<FluidStack>();
        Iterator<? extends IDualInputInventory> inventoryIterator = this.inventories();
        while (inventoryIterator.hasNext()) {
            FluidStack[] fluids = inventoryIterator.next().getFluidInputs();
            if (fluids == null) continue;
            for (FluidStack fluid : fluids) {
                if (fluid == null) continue;
                rList.add(fluid);
            }
        }
        return rList.toArray(new FluidStack[rList.size()]);
    }
}

