/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi.purification;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.drawable.shapes.Rectangle;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedRow;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.Row;
import com.gtnewhorizons.modularui.common.widget.Scrollable;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.gui.widgets.LockedWhileActiveButton;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReason;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gregtech.common.gui.modularui.widget.ShutDownReasonSyncer;
import gregtech.common.gui.modularui.widget.TextButtonWidget;
import gregtech.common.tileentities.machines.multi.purification.LinkedPurificationUnit;
import gregtech.common.tileentities.machines.multi.purification.MTEPurificationUnitBase;
import gregtech.common.tileentities.machines.multi.purification.PurificationPlantStructureString;
import gregtech.common.tileentities.machines.multi.purification.PurificationUnitStatus;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEPurificationPlant
extends MTEExtendedPowerMultiBlockBase<MTEPurificationPlant>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final String STRUCTURE_PIECE_MAIN_SURVIVAL = "main_survival";
    public static final int MAX_UNIT_DISTANCE = 32;
    public static final int CYCLE_TIME_TICKS = 2400;
    private final List<LinkedPurificationUnit> mLinkedUnits = new ArrayList<LinkedPurificationUnit>();
    private boolean debugMode = false;
    public static final int CYCLE_TIME_IN_DEBUG = 600;
    private static final IStructureDefinition<MTEPurificationPlant> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", PurificationPlantStructureString.STRUCTURE_STRING).addShape("main_survival", (String[][])Arrays.stream(PurificationPlantStructureString.STRUCTURE_STRING).map(sa -> (String[])Arrays.stream(sa).map(s -> s.replaceAll("F", " ")).toArray(String[]::new)).toArray(x$0 -> new String[x$0][])).addElement('A', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)3)).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)4)).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)5)).addElement('D', StructureUtility.ofBlockAnyMeta((Block)GregTechAPI.sBlockTintedGlass, (int)0)).addElement('F', GTStructureUtility.ofAnyWater()).addElement('G', GTStructureUtility.ofFrame(Materials.Tungsten)).addElement('H', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.lazy(t -> GTStructureUtility.buildHatchAdder().atLeastList(t.getAllowedHatches()).dot(1).casingIndex(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings9, 4)).build()), StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)4)})).build();
    private final int STATUS_WINDOW_ID = 10;

    public MTEPurificationPlant(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEPurificationPlant(String aName) {
        super(aName);
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 3, 6, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        int built = this.survivalBuildPiece(STRUCTURE_PIECE_MAIN_SURVIVAL, stackSize, 3, 6, 0, elementBudget, env, true);
        if (built == -1) {
            GTUtility.sendChatToPlayer(env.getActor(), EnumChatFormatting.GREEN + "Auto placing done ! Now go place the water yourself !");
            return 0;
        }
        return built;
    }

    @Override
    public IStructureDefinition<MTEPurificationPlant> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Purification Plant, WPP").addInfo("Main controller block for the Water Purification Plant").addInfo("Freely place " + EnumChatFormatting.YELLOW + "Purification Units " + EnumChatFormatting.GRAY + "within " + EnumChatFormatting.RED + 32 + EnumChatFormatting.GRAY + " blocks along each axis").addInfo("Left click this controller with a data stick, then right click a purification unit to link").addInfo("Supplies power to linked purification units").addTecTechHatchInfo().addSeparator().addInfo("Works in fixed time processing cycles of " + EnumChatFormatting.RED + 120 + EnumChatFormatting.GRAY + " seconds").addInfo("All linked units follow this cycle").addSeparator().addInfo("Every recipe has a base chance of success. Success rate can be boosted").addInfo("by using a portion of the target output as a secondary input").addInfo(EnumChatFormatting.RED + GTUtility.formatNumbers(10.0) + "%" + EnumChatFormatting.GRAY + " of output yield will be consumed in exchange for an").addInfo("additive " + EnumChatFormatting.RED + GTUtility.formatNumbers(15.000000953674316) + "%" + EnumChatFormatting.GRAY + " increase to success").addInfo("On recipe failure, each purification unit has a " + EnumChatFormatting.RED + "50%" + EnumChatFormatting.GRAY + " chance").addInfo("to return water of the same quality as the input or lower").addSeparator().addInfo("Every purification unit has a configuration window to configure maximum parallel amount").addInfo("This will only scale purified water input, ALL fluid output and power usage. Other catalysts and outputs are unchanged").addInfo("Toggle debug mode to reduce cycle time to 30s but disable water I/O").addSeparator().addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "Contaminants and ionized particles in water can cause significant imperfections in delicate").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "processes related to the cutting and engraving of silicon wafers and chips. It is crucial that").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "the water is systematically purified through a series of increasingly precise and complex").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "purification processes, and this multiblock is the heart of the operation").beginStructureBlock(7, 9, 8, false).addController("Front center").addCasingInfoExactlyColored("Superplasticizer-Treated High Strength Concrete", EnumChatFormatting.GRAY, 56, EnumChatFormatting.GOLD, false).addCasingInfoRangeColored("Sterile Water Plant Casing", EnumChatFormatting.GRAY, 71, 72, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Reinforced Sterile Water Plant Casing", EnumChatFormatting.GRAY, 77, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Tungsten Frame Box", EnumChatFormatting.GRAY, 30, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Tinted Industrial Glass", EnumChatFormatting.GRAY, 6, EnumChatFormatting.GOLD, false).addEnergyHatch(EnumChatFormatting.GOLD + "1", 1).addMaintenanceHatch(EnumChatFormatting.GOLD + "1", 1).addStructureInfo("Requires water to be placed in the tank.").toolTipFinisher(GTValues.AuthorNotAPenguin);
        return tt;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEPurificationPlant(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstoneLevel) {
        if (side == facing) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings9, 4)), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_PURIFICATION_PLANT_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_PURIFICATION_PLANT_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings9, 4)), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_PURIFICATION_PLANT).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_PURIFICATION_PLANT_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings9, 4))};
    }

    private List<IHatchElement<? super MTEPurificationPlant>> getAllowedHatches() {
        return ImmutableList.of((Object)HatchElement.Maintenance, (Object)HatchElement.Energy, (Object)HatchElement.ExoticEnergy);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 3, 6, 0)) {
            return false;
        }
        if (!this.checkHatches()) {
            return false;
        }
        return this.checkExoticAndNormalEnergyHatches();
    }

    private boolean checkHatches() {
        return this.mMaintenanceHatches.size() == 1;
    }

    public boolean debugModeOn() {
        return this.debugMode;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide()) {
            for (int i = 0; i < this.mLinkedUnits.size(); ++i) {
                if (aTick % 2400L != (long)i) continue;
                LinkedPurificationUnit unit = this.mLinkedUnits.get(i);
                boolean structure = unit.metaTileEntity().checkStructure(true);
                if (!unit.isActive() || structure) continue;
                unit.setActive(false);
                this.lEUt = -this.calculateEffectivePowerUsage();
            }
        }
    }

    @Override
    protected void runMachine(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        this.updateCycleProgress();
        if (this.mMaxProgresstime > 0) {
            this.mEfficiency = Math.max(0, Math.min(this.mEfficiency + this.mEfficiencyIncrease, this.getMaxEfficiency(this.mInventory[1]) - (this.getIdealStatus() - this.getRepairStatus()) * 1000));
        }
    }

    private void updateCycleProgress() {
        if (this.mMachine) {
            if (this.mMaxProgresstime > 0) {
                if (this.onRunningTick(this.mInventory[1])) {
                    this.func_70296_d();
                    ++this.mProgresstime;
                    for (LinkedPurificationUnit unit : this.mLinkedUnits) {
                        if (!unit.isActive()) continue;
                        MTEPurificationUnitBase<?> metaTileEntity = unit.metaTileEntity();
                        metaTileEntity.mProgresstime = this.mProgresstime;
                    }
                    if (this.mProgresstime >= this.mMaxProgresstime) {
                        this.endCycle();
                    }
                } else {
                    for (LinkedPurificationUnit unit : this.mLinkedUnits) {
                        if (!unit.isActive()) continue;
                        unit.metaTileEntity().stopMachine(ShutDownReasonRegistry.POWER_LOSS);
                    }
                }
            }
            if (this.mMaxProgresstime == 0 && this.isAllowedToWork()) {
                this.startCycle();
            }
        }
    }

    private void startCycle() {
        this.mProgresstime = 0;
        this.mMaxProgresstime = this.debugMode ? 600 : 2400;
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        for (LinkedPurificationUnit unit : this.mLinkedUnits) {
            MTEPurificationUnitBase<?> metaTileEntity = unit.metaTileEntity();
            PurificationUnitStatus status = metaTileEntity.status();
            if (status != PurificationUnitStatus.ONLINE || !metaTileEntity.doPurificationRecipeCheck()) continue;
            unit.setActive(true);
            metaTileEntity.startCycle(this.mMaxProgresstime, this.mProgresstime);
        }
        this.lEUt = -this.calculateEffectivePowerUsage();
    }

    private void endCycle() {
        this.mMaxProgresstime = 0;
        for (LinkedPurificationUnit unit : this.mLinkedUnits) {
            MTEPurificationUnitBase<?> metaTileEntity = unit.metaTileEntity();
            if (unit.isActive()) {
                metaTileEntity.endCycle();
            }
            unit.setActive(false);
        }
    }

    private long calculateEffectivePowerUsage() {
        long euT = 0L;
        for (LinkedPurificationUnit unit : this.mLinkedUnits) {
            if (!unit.isActive()) continue;
            euT += unit.metaTileEntity().getActualPowerUsage();
        }
        return euT;
    }

    public void registerLinkedUnit(MTEPurificationUnitBase<?> unit) {
        LinkedPurificationUnit link = new LinkedPurificationUnit(unit);
        link.setActive(unit.mMaxProgresstime > 0);
        this.mLinkedUnits.add(link);
    }

    public void unregisterLinkedUnit(MTEPurificationUnitBase<?> unit) {
        this.mLinkedUnits.removeIf(link -> link.metaTileEntity() == unit);
    }

    @Override
    public void onLeftclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (!(aPlayer instanceof EntityPlayerMP)) {
            return;
        }
        ItemStack dataStick = aPlayer.field_71071_by.func_70448_g();
        if (!ItemList.Tool_DataStick.isStackEqual(dataStick, false, true)) {
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("type", "PurificationPlant");
        tag.func_74768_a("x", aBaseMetaTileEntity.getXCoord());
        tag.func_74768_a("y", (int)aBaseMetaTileEntity.getYCoord());
        tag.func_74768_a("z", aBaseMetaTileEntity.getZCoord());
        dataStick.field_77990_d = tag;
        dataStick.func_151001_c("Purification Plant Link Data Stick (" + aBaseMetaTileEntity.getXCoord() + ", " + aBaseMetaTileEntity.getYCoord() + ", " + aBaseMetaTileEntity.getZCoord() + ")");
        aPlayer.func_145747_a((IChatComponent)new ChatComponentText("Saved Link Data to Data Stick"));
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(StatCollector.func_74838_a((String)"GT5U.infodata.purification_plant.linked_units"));
        for (LinkedPurificationUnit unit : this.mLinkedUnits) {
            String text = EnumChatFormatting.AQUA + unit.metaTileEntity().getLocalName() + ": ";
            PurificationUnitStatus status = unit.metaTileEntity().status();
            switch (status) {
                case ONLINE: {
                    text = text + EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"GT5U.infodata.purification_plant.linked_units.status.online");
                    break;
                }
                case DISABLED: {
                    text = text + EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"GT5U.infodata.purification_plant.linked_units.status.disabled");
                    break;
                }
                case INCOMPLETE_STRUCTURE: {
                    text = text + EnumChatFormatting.RED + StatCollector.func_74838_a((String)"GT5U.infodata.purification_plant.linked_units.status.incomplete");
                }
            }
            ret.add(text);
        }
        return ret.toArray(new String[0]);
    }

    @Override
    public void onBlockDestroyed() {
        for (LinkedPurificationUnit unit : this.mLinkedUnits) {
            unit.metaTileEntity().unlinkController();
        }
        super.onBlockDestroyed();
    }

    private void drawTopText(DynamicPositionedColumn screenElements) {
        screenElements.setSynced(false).setSpace(0);
        ((Column)screenElements.widget(new TextWidget(GTUtility.trans("138", "Incomplete Structure.")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(EnumChatFormatting.RED).setEnabled(widget -> !this.mMachine))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mMachine, val -> {
            this.mMachine = val;
        }));
        ((Column)((Column)screenElements.widget(new TextWidget(StatCollector.func_74838_a((String)"GT5U.gui.text.purification_plant.hit_to_start")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(EnumChatFormatting.BLACK).setEnabled(widget -> this.getErrorDisplayID() == 0 && !this.getBaseMetaTileEntity().isActive()))).widget((Widget)new FakeSyncWidget.IntegerSyncer(this::getErrorDisplayID, this::setErrorDisplayID))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.getBaseMetaTileEntity().isActive(), val -> this.getBaseMetaTileEntity().setActive((boolean)val)));
        screenElements.widget(new TextWidget(GTUtility.trans("142", "Running perfectly.")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(EnumChatFormatting.GREEN).setEnabled(widget -> this.getErrorDisplayID() == 0 && this.getBaseMetaTileEntity().isActive()));
        ((Column)((Column)screenElements.widget(TextWidget.dynamicString(() -> this.getBaseMetaTileEntity().getLastShutDownReason().getDisplayString()).setSynced(false).setTextAlignment(Alignment.CenterLeft).setEnabled(widget -> this.shouldDisplayShutDownReason() && !this.getBaseMetaTileEntity().isActive() && GTUtility.isStringValid(this.getBaseMetaTileEntity().getLastShutDownReason().getDisplayString()) && this.getBaseMetaTileEntity().wasShutdown()))).widget((Widget)new ShutDownReasonSyncer(() -> this.getBaseMetaTileEntity().getLastShutDownReason(), reason -> this.getBaseMetaTileEntity().setShutDownReason((ShutDownReason)reason)))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.getBaseMetaTileEntity().wasShutdown(), wasShutDown -> this.getBaseMetaTileEntity().setShutdownStatus((boolean)wasShutDown)));
        ((Column)((Column)screenElements.widget(TextWidget.dynamicString(() -> this.generateCurrentProgress()).setSynced(false).setTextAlignment(new Alignment(-1, -1)).setSize(180, 12).setEnabled(widget -> this.mOutputFluids != null && this.mOutputFluids.length > 0 || this.mOutputItems != null && this.mOutputItems.length > 0))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.mProgresstime, val -> {
            this.mProgresstime = val;
        }))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.mMaxProgresstime, val -> {
            this.mMaxProgresstime = val;
        }));
    }

    private ModularWindow createStatusWindow(EntityPlayer player) {
        int windowWidth = 260;
        int windowHeight = 200;
        ModularWindow.Builder builder = ModularWindow.builder((int)260, (int)200);
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.widget(ButtonWidget.closeWindowButton((boolean)true).setPos(245, 3));
        builder.widget(new TextWidget(StatCollector.func_74838_a((String)"GT5U.infodata.purification_plant.status_title")).setTextAlignment(Alignment.Center).setPos(5, 10).setSize(260, 8));
        int currentYPosition = 20;
        Scrollable mainDisp = new Scrollable().setVerticalScroll().setHorizontalScroll();
        int rowHeight = 20;
        for (int i = 0; i < this.mLinkedUnits.size(); ++i) {
            mainDisp.widget(this.makeUnitStatusWidget(this.mLinkedUnits.get(i)).setPos(0, rowHeight * (i + 1)));
        }
        builder.widget(mainDisp.setPos(5, currentYPosition).setSize(250, 200 - currentYPosition - 5));
        return builder.build();
    }

    private Widget makeStatusWindowButton() {
        TextButtonWidget widget = (TextButtonWidget)new TextButtonWidget(StatCollector.func_74838_a((String)"GT5U.infodata.purification_plant.status_button")).setLeftMargin(4).setSize(40, 16).setPos(10, 40);
        widget.button().setOnClick((clickData, w) -> {
            if (!w.isClient()) {
                w.getContext().openSyncedWindow(10);
            }
        }).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD});
        widget.text().setTextAlignment(Alignment.CenterLeft).setDefaultColor(EnumChatFormatting.BLACK);
        return widget;
    }

    private Widget makeUnitStatusWidget(LinkedPurificationUnit unit) {
        DynamicPositionedRow row = new DynamicPositionedRow();
        ItemStackHandler machineIcon = new ItemStackHandler(1);
        machineIcon.setStackInSlot(0, unit.metaTileEntity().getStackForm(1L));
        ((Row)row.widget(SlotWidget.phantom((IItemHandlerModifiable)machineIcon, (int)0).disableInteraction().setPos(0, 0))).setSize(20, 20);
        String name = unit.metaTileEntity().getLocalName();
        String statusString = name + "  " + unit.getStatusString();
        int widgetWidth = 0;
        if (NetworkUtils.isClient()) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            widgetWidth = fontRenderer.func_78256_a(statusString) + 25;
        }
        ((Row)((Row)((Row)((Row)row.widget(TextWidget.dynamicString(() -> statusString).setSynced(false).setTextAlignment(Alignment.CenterLeft).setPos(25, 0).fillParent())).widget((Widget)new FakeSyncWidget.StringSyncer(() -> name, _name -> {}))).widget(unit.metaTileEntity().makeSyncerWidgets())).widget((Widget)new FakeSyncWidget.BooleanSyncer(unit::isActive, unit::setActive))).setSize(widgetWidth, 20);
        return row;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        buildContext.addSyncedWindow(10, this::createStatusWindow);
        DynamicPositionedColumn controlTextArea = new DynamicPositionedColumn();
        this.drawTopText(controlTextArea);
        builder.widget(((Scrollable)new Scrollable().setVerticalScroll().widget((Widget)controlTextArea)).setPos(10, 7).setSize(182, 24));
        builder.widget(new Rectangle().setColor(Color.rgb((int)114, (int)120, (int)139)).asWidget().setSizeProvider((screenSize, window, parent) -> new Size(window.getSize().width - 8, 2)).setPos(3, 32));
        builder.widget(this.makeStatusWindowButton());
        builder.widget(new LockedWhileActiveButton(this.getBaseMetaTileEntity(), builder).setPlayClickSound(true).setOnClick((c, w) -> {
            this.debugMode = !this.debugMode;
        }).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            if (this.debugMode) {
                ret.add(GTUITextures.BUTTON_STANDARD_PRESSED);
                ret.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_DEFAULT);
            } else {
                ret.add(GTUITextures.BUTTON_STANDARD);
                ret.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_DEFAULT);
            }
            return ret.toArray(new IDrawable[0]);
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(() -> this.debugMode, b -> {
            this.debugMode = b;
        }), (IWidgetBuilder)builder).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.tooltip.purification_plant.debug_mode")).setTooltipShowUpDelay(5).setPos(174, 112).setSize(16, 16));
        builder.widget((Widget)this.createPowerSwitchButton((IWidgetBuilder)builder));
        this.addSyncers(builder);
    }

    private void addSyncers(ModularWindow.Builder builder) {
        builder.widget((Widget)new FakeSyncWidget.ListSyncer(() -> this.mLinkedUnits, links -> {
            this.mLinkedUnits.clear();
            this.mLinkedUnits.addAll((Collection<LinkedPurificationUnit>)links);
        }, (buffer, link) -> {
            try {
                buffer.func_150786_a(link.writeLinkDataToNBT());
            }
            catch (IOException e) {
                GTLog.err.println(e.getCause());
            }
        }, buffer -> {
            try {
                return new LinkedPurificationUnit(buffer.func_150793_b());
            }
            catch (IOException e) {
                GTLog.err.println(e.getCause());
                return null;
            }
        }));
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.debugMode = aNBT.func_74767_n("debugMode");
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("debugMode", this.debugMode);
    }
}

