/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tools;

import bartworks.system.material.BWMetaGeneratedOres;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Mods;
import gregtech.api.items.ItemTool;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.BaseTileEntity;
import gregtech.common.blocks.BlockFrameBox;
import gregtech.common.blocks.BlockOres;
import gtPlusPlus.core.block.base.BlockBaseOre;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.crop.TileEntityCrop;
import java.util.List;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import thaumcraft.common.tiles.TileOwned;

public class ToolVajra
extends ItemTool
implements IElectricItem {
    public int maxCharge = 100000000;
    public int baseCost = 3333;
    public int tier = 5;
    public double transferLimit = GTValues.V[this.tier];
    private final String tooltip;

    public ToolVajra(String aUnlocalized, String aEnglish, String aTooltip, int aMaxDamage, int aEntityDamage, boolean aSwingIfUsed) {
        super(aUnlocalized, aEnglish, aTooltip, aMaxDamage, aEntityDamage, aSwingIfUsed);
        this.tooltip = aTooltip;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> itemList) {
        ItemStack itemStack = new ItemStack((Item)this, 1);
        if (this.getChargedItem(itemStack) == this) {
            ItemStack charged = new ItemStack((Item)this, 1);
            ElectricItem.manager.charge(charged, 2.147483647E9, Integer.MAX_VALUE, true, false);
            itemList.add(charged);
        }
        if (this.getEmptyItem(itemStack) == this) {
            itemList.add(new ItemStack((Item)this, 1, this.func_77612_l()));
        }
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int par4, int par5, int par6, EntityLivingBase entityLiving) {
        ElectricItem.manager.use(stack, (double)this.baseCost, entityLiving);
        return true;
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return ElectricItem.manager.canUse(stack, (double)this.baseCost);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        return Integer.MAX_VALUE;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (!ElectricItem.manager.canUse(stack, (double)this.baseCost)) {
            return 0.0f;
        }
        return 2.1474836E9f;
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase target, EntityLivingBase source) {
        if (source instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source;
            target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), (float)this.attackDamage);
        } else {
            target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)source), (float)this.attackDamage);
        }
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return false;
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer par2EntityPlayer, List<String> list, boolean par4) {
        list.add(EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"gt.vajra.tooltip.flavor"));
        list.add(EnumChatFormatting.WHITE + StatCollector.func_74837_a((String)"gt.vajra.tooltip.charge", (Object[])new Object[]{GTValues.VN[this.tier]}));
        list.add(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"gt.vajra.tooltip.silk_touch"));
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    @Override
    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return this.func_77648_a(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
        }
        return super.onItemUseFirst(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Block target = world.func_147439_a(x, y, z);
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        int metaData = world.func_72805_g(x, y, z);
        if (target.field_149782_v < 0.0f) {
            return super.func_77648_a(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
        }
        if (!ElectricItem.manager.canUse(stack, (double)this.baseCost)) {
            return super.func_77648_a(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
        }
        if (!this.isHarvestableTileEntity(tileEntity, target, player) && !player.func_70093_af() || !this.isHarvestableOwned(tileEntity, player)) {
            return super.func_77648_a(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
        }
        if (world.field_72995_K) {
            Minecraft.func_71410_x().field_71442_b.func_78751_a(x, y, z, side);
            player.func_71038_i();
        } else {
            target.func_149681_a(world, x, y, z, metaData, player);
            if (target.removedByPlayer(world, player, x, y, z, true)) {
                target.func_149664_b(world, x, y, z, metaData);
                target.func_149636_a(world, player, x, y, z, metaData);
            }
        }
        stack.func_77978_p().func_74757_a("harvested", true);
        ElectricItem.manager.use(stack, (double)this.baseCost, (EntityLivingBase)player);
        return super.func_77648_a(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    private boolean isHarvestableOwned(TileEntity tileEntity, EntityPlayer player) {
        if (!Mods.Thaumcraft.isModLoaded() || !(tileEntity instanceof TileOwned)) {
            return true;
        }
        TileOwned owned = (TileOwned)tileEntity;
        return owned.owner.equals(player.getDisplayName());
    }

    private boolean isHarvestableTileEntity(TileEntity tileEntity, Block target, EntityPlayer player) {
        BaseTileEntity bte;
        IInventory inv;
        if (tileEntity instanceof TileEntityCrop) {
            return false;
        }
        if (Mods.Railcraft.isModLoaded() && this.isUnformedRCMulti(tileEntity)) {
            return true;
        }
        if (tileEntity instanceof IInventory && (inv = (IInventory)tileEntity).func_70302_i_() > 0) {
            return false;
        }
        if (this.isHarvestableGTSpecial(target, tileEntity) && !player.func_70093_af()) {
            return true;
        }
        return !(tileEntity instanceof BaseTileEntity) || !(bte = (BaseTileEntity)tileEntity).useModularUI();
    }

    @Optional.Method(modid="Railcraft")
    private boolean isUnformedRCMulti(TileEntity tileEntity) {
        TileMultiBlock tmb;
        return tileEntity instanceof TileMultiBlock && !(tmb = (TileMultiBlock)tileEntity).isStructureValid();
    }

    private boolean isHarvestableGTSpecial(Block target, TileEntity tileEntity) {
        if (target instanceof BlockFrameBox) {
            return tileEntity == null;
        }
        if (target instanceof BlockOres || target instanceof BWMetaGeneratedOres || target instanceof BlockBaseOre) {
            return true;
        }
        return tileEntity instanceof BaseMetaPipeEntity;
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer player) {
        NBTTagCompound tag;
        NBTTagCompound nBTTagCompound = tag = itemStackIn.func_77942_o() ? itemStackIn.func_77978_p() : new NBTTagCompound();
        if (!worldIn.field_72995_K && !itemStackIn.func_77942_o()) {
            itemStackIn.func_77982_d(tag);
        }
        if (tag.func_74767_n("harvested")) {
            tag.func_82580_o("harvested");
            return super.func_77659_a(itemStackIn, worldIn, player);
        }
        if (!worldIn.field_72995_K && player.func_70093_af()) {
            if (itemStackIn.func_77978_p().func_74764_b("ench")) {
                tag.func_82580_o("ench");
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Disabled silk touch"));
            } else {
                itemStackIn.func_77966_a(Enchantment.field_77348_q, 1);
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Enabled silk touch"));
            }
        }
        return super.func_77659_a(itemStackIn, worldIn, player);
    }
}

