/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeBuilder;
import gregtech.api.util.GTUtility;
import net.minecraft.item.ItemStack;

public class ProcessingRecycling
implements IOreRecipeRegistrator {
    public ProcessingRecycling() {
        for (OrePrefixes tPrefix : OrePrefixes.values()) {
            if (!tPrefix.mIsMaterialBased || tPrefix.mMaterialAmount <= 0L || !tPrefix.mIsContainer) continue;
            tPrefix.add(this);
        }
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        if (aMaterial != Materials.Empty && GTUtility.getFluidForFilledItem(aStack, true) == null && !aMaterial.contains(SubTag.SMELTING_TO_FLUID) && GTOreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L) != null) {
            GTRecipeBuilder recipeBuilder = GTValues.RA.stdBuilder();
            recipeBuilder.itemInputs(aStack);
            if (GTUtility.getContainerItem(aStack, true) == null) {
                recipeBuilder.itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, aMaterial, aPrefix.mMaterialAmount / 3628800L));
            } else {
                recipeBuilder.itemOutputs(GTUtility.getContainerItem(aStack, true), GTOreDictUnificator.get(OrePrefixes.dust, aMaterial, aPrefix.mMaterialAmount / 3628800L));
            }
            recipeBuilder.duration((int)Math.max(aMaterial.getMass() / 2L, 1L) * 1).eut(2).addTo(RecipeMaps.cannerRecipes);
        }
    }
}

