/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.general;

import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.Mods;
import gtPlusPlus.core.creative.AddToCreativeTab;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;

public class ItemAirFilter
extends Item {
    public IIcon[] icons = new IIcon[2];

    public ItemAirFilter() {
        this.func_77627_a(true);
        String unlocalizedName = "itemAirFilter";
        this.func_77655_b(unlocalizedName);
        this.func_77637_a(AddToCreativeTab.tabMisc);
        this.func_77625_d(1);
        GameRegistry.registerItem((Item)this, (String)unlocalizedName);
    }

    public void func_94581_a(IIconRegister reg) {
        this.icons[0] = reg.func_94245_a(Mods.GTPlusPlus.ID + ":itemAirFilter1");
        this.icons[1] = reg.func_94245_a(Mods.GTPlusPlus.ID + ":itemAirFilter2");
    }

    public IIcon func_77617_a(int meta) {
        return this.icons[meta];
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 2; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "_" + stack.func_77960_j();
    }

    public String func_77653_i(ItemStack tItem) {
        if (tItem == null) {
            return StatCollector.func_74838_a((String)"item.GTPP.air_filter.name");
        }
        if (tItem.func_77960_j() == 0) {
            return StatCollector.func_74838_a((String)"item.GTPP.air_filter.name.t1");
        }
        if (tItem.func_77960_j() == 1) {
            return StatCollector.func_74838_a((String)"item.GTPP.air_filter.name.t1");
        }
        return StatCollector.func_74838_a((String)"item.GTPP.air_filter.name");
    }

    private static boolean createNBT(ItemStack rStack) {
        NBTTagCompound tagMain = new NBTTagCompound();
        NBTTagCompound tagNBT = new NBTTagCompound();
        tagNBT.func_74772_a("Damage", 0L);
        tagMain.func_74782_a("AirFilter", (NBTBase)tagNBT);
        rStack.func_77982_d(tagMain);
        return true;
    }

    public static long getFilterMaxDamage(ItemStack aStack) {
        return aStack.func_77960_j() == 0 ? 50L : 2500L;
    }

    public static long getFilterDamage(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null) {
            if ((aNBT = aNBT.func_74775_l("AirFilter")) != null) {
                return aNBT.func_74763_f("Damage");
            }
        } else {
            ItemAirFilter.createNBT(aStack);
        }
        return 0L;
    }

    public static boolean setFilterDamage(ItemStack aStack, long aDamage) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && (aNBT = aNBT.func_74775_l("AirFilter")) != null) {
            aNBT.func_74772_a("Damage", aDamage);
            return true;
        }
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            ItemAirFilter.createNBT(stack);
        }
        double currentDamage = ItemAirFilter.getFilterDamage(stack);
        double meta = ItemAirFilter.getFilterMaxDamage(stack);
        return currentDamage / meta;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        list.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"GTPP.tooltip.air_filter.0"));
        long maxDamage = ItemAirFilter.getFilterMaxDamage(stack);
        list.add(EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"GTPP.tooltip.air_filter.1", (Object[])new Object[]{maxDamage - ItemAirFilter.getFilterDamage(stack), maxDamage}));
        super.func_77624_a(stack, player, list, bool);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }
}

