/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.general.books;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Mods;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.handler.BookHandler;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.NBTUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenBook;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWritableBook;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemBaseBook
extends ItemWritableBook {
    public ItemBaseBook() {
        this.func_77637_a(AddToCreativeTab.tabMisc);
        this.func_77625_d(1);
        this.func_111206_d(Mods.GTPlusPlus.ID + ":itemBook");
        this.func_77655_b("itembookgt");
        GameRegistry.registerItem((Item)this, (String)"bookGT");
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < BookHandler.mBookMap.size(); ++i) {
            ItemStack bookstack = new ItemStack(item, 1, i);
            NBTUtils.createIntegerTagCompound(bookstack, "stats", "mMeta", i);
            list.add(bookstack);
        }
    }

    public String func_77653_i(ItemStack tItem) {
        if (NBTUtils.hasKey(tItem, "title")) {
            return NBTUtils.getString(tItem, "title");
        }
        if (tItem.func_77960_j() > -1 && tItem.func_77960_j() < BookHandler.mBookMap.size()) {
            return EnumChatFormatting.ITALIC + Utils.addBookTitleLocalization(BookHandler.mBookMap.get((Object)Integer.valueOf((int)tItem.func_77960_j())).mTitle);
        }
        return "GT++ Storybook";
    }

    public void func_77624_a(ItemStack tItem, EntityPlayer player, List<String> list, boolean bool) {
        BookHandler.BookTemplate bookTemplate = BookHandler.mBookMap.get(tItem.func_77960_j());
        if (bookTemplate == null) {
            return;
        }
        if (NBTUtils.hasKey(tItem, "author")) {
            list.add(EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"gtpp.tooltip.book.author", (Object[])new Object[]{NBTUtils.getString(tItem, "author")}));
        } else if (bookTemplate.mAuthor != null) {
            list.add(EnumChatFormatting.WHITE + StatCollector.func_74837_a((String)"gtpp.tooltip.book.author", (Object[])new Object[]{bookTemplate.mAuthor}));
        }
        if (NBTUtils.hasKey(tItem, "title")) {
            list.add(EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"gtpp.tooltip.book.pages.s", (Object[])new Object[]{NBTUtils.getString(tItem, "pages")}));
        } else if (bookTemplate.mPages != null) {
            list.add(EnumChatFormatting.WHITE + StatCollector.func_74837_a((String)"gtpp.tooltip.book.pages.d", (Object[])new Object[]{bookTemplate.mPages.length}));
        }
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_77659_a(ItemStack item, World world, EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            BookHandler.BookTemplate bookTemplate = BookHandler.mBookMap.get(item.func_77960_j());
            if (bookTemplate == null) {
                return item;
            }
            ItemStack bookstack = Utils.getWrittenBook(null, bookTemplate.mMeta, bookTemplate.mMapping, bookTemplate.mTitle, bookTemplate.mAuthor, bookTemplate.mPages);
            if (bookstack != null) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiScreenBook(player, bookstack, false));
            }
        }
        return item;
    }
}

