/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.plugin.agrichem.logic;

import net.minecraft.nbt.NBTTagCompound;

public class AlgaeGeneticData {
    private final int mLifespan;
    private final int mGeneration;
    private final boolean mIsDominant;
    private final boolean mRequiresLight;
    private final boolean mSaltWater;
    private final boolean mFreshWater;
    private final byte mTempTolerance;
    private final float mFertility;
    private final float mProductionSpeed;

    public AlgaeGeneticData() {
        this(true, true, true, true, 0, 1.0f, 1.0f, 30, 0);
    }

    public AlgaeGeneticData(boolean isDominant, boolean requiresLight, boolean isSalt, boolean isFresh, byte aTempTolerance, float aFertility, float aSpeed, byte aLifespan, int aGeneration) {
        this.mIsDominant = isDominant;
        this.mRequiresLight = requiresLight;
        this.mSaltWater = isSalt;
        this.mFreshWater = isFresh;
        this.mTempTolerance = aTempTolerance;
        this.mFertility = aFertility;
        this.mProductionSpeed = aSpeed;
        this.mLifespan = aLifespan;
        this.mGeneration = aGeneration;
    }

    public AlgaeGeneticData(NBTTagCompound aNBT) {
        if (aNBT == null || aNBT.func_82582_d()) {
            this.mIsDominant = true;
            this.mRequiresLight = true;
            this.mSaltWater = true;
            this.mFreshWater = true;
            this.mTempTolerance = 0;
            this.mFertility = 1.0f;
            this.mProductionSpeed = 1.0f;
            this.mLifespan = 30;
            this.mGeneration = 0;
        } else {
            this.mIsDominant = aNBT.func_74767_n("mIsDominant");
            this.mRequiresLight = aNBT.func_74767_n("mRequiresLight");
            this.mSaltWater = aNBT.func_74767_n("mSaltWater");
            this.mFreshWater = aNBT.func_74767_n("mFreshWater");
            this.mTempTolerance = aNBT.func_74771_c("mTempTolerance");
            this.mFertility = aNBT.func_74760_g("mFertility");
            this.mProductionSpeed = aNBT.func_74760_g("mProductionSpeed");
            this.mLifespan = aNBT.func_74771_c("mLifespan");
            this.mGeneration = aNBT.func_74762_e("mGeneration");
        }
    }

    public final int getLifespan() {
        return this.mLifespan;
    }

    public final boolean isDominant() {
        return this.mIsDominant;
    }

    public final boolean RequiresLight() {
        return this.mRequiresLight;
    }

    public final boolean isSaltWater() {
        return this.mSaltWater;
    }

    public final boolean isFreshWater() {
        return this.mFreshWater;
    }

    public final byte getTempTolerance() {
        return this.mTempTolerance;
    }

    public final float getFertility() {
        return this.mFertility;
    }

    public final float getProductionSpeed() {
        return this.mProductionSpeed;
    }

    public final int getGeneration() {
        return this.mGeneration;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound aGenes = new NBTTagCompound();
        aGenes.func_74757_a("mIsDominant", this.mIsDominant);
        aGenes.func_74757_a("mRequiresLight", this.mRequiresLight);
        aGenes.func_74757_a("mSaltWater", this.mSaltWater);
        aGenes.func_74757_a("mFreshWater", this.mFreshWater);
        aGenes.func_74768_a("mLifespan", this.mLifespan);
        aGenes.func_74768_a("mGeneration", this.mGeneration);
        aGenes.func_74774_a("mTempTolerance", this.mTempTolerance);
        aGenes.func_74776_a("mFertility", this.mFertility);
        aGenes.func_74776_a("mProductionSpeed", this.mProductionSpeed);
        return aGenes;
    }
}

