/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.Scrollable;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gtPlusPlus.core.lib.GTPPCore;

public class MTEHatchSuperBusInput
extends MTEHatchInputBus {
    public MTEHatchSuperBusInput(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, MTEHatchSuperBusInput.getSlots(aTier) + 1);
    }

    public MTEHatchSuperBusInput(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, MTEHatchSuperBusInput.getSlots(aTier) + 1, aDescription, aTextures);
    }

    public static int getSlots(int aTier) {
        return (1 + aTier) * 16;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchSuperBusInput(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Item Input for Multiblocks", MTEHatchSuperBusInput.getSlots(this.mTier) + " Slots", GTPPCore.GT_Tooltip.get()};
    }

    @Override
    public int getCircuitSlot() {
        return MTEHatchSuperBusInput.getSlots(this.mTier);
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        buildContext.addCloseListener(() -> {
            this.uiButtonCount = 0;
        });
        this.addSortStacksButton(builder);
        this.addOneStackLimitButton(builder);
        Scrollable scrollable = new Scrollable().setVerticalScroll();
        int row = 0;
        while (row * 4 < this.inventoryHandler.getSlots() - 1) {
            int columnsToMake = Math.min(this.inventoryHandler.getSlots() - row * 4, 4);
            for (int column = 0; column < columnsToMake; ++column) {
                scrollable.widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, row * 4 + column).setPos(column * 18, row * 18).setSize(18, 18));
            }
            ++row;
        }
        builder.widget(scrollable.setSize(76, 72).setPos(52, 7));
    }
}

