/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.basic;

import cofh.api.energy.IEnergyContainerItem;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Mods;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IWirelessCharger;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.implementations.MTETieredMachineBlock;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEWirelessCharger
extends MTETieredMachineBlock
implements IWirelessCharger {
    private ChargeMode mode = ChargeMode.LONG_RANGE;
    private boolean locked = true;
    private int maxCurrentRange = -1;
    private final Map<String, UUID> longRangeMap = new HashMap<String, UUID>();
    private final Map<String, UUID> localRangeMap = new HashMap<String, UUID>();

    public MTEWirelessCharger(int aID, String aName, String aNameRegional, int aTier, int aSlotCount) {
        super(aID, aName, aNameRegional, aTier, aSlotCount, GTValues.emptyStringArray, new ITexture[0]);
    }

    public MTEWirelessCharger(String name, int tier, String[] description, ITexture[][][] textures, int slotCount) {
        super(name, tier, slotCount, description, textures);
    }

    @Override
    public String[] getDescription() {
        return new String[]{StatCollector.func_74838_a((String)"gtpp.tooltip.wireless_charger.0"), StatCollector.func_74838_a((String)"gtpp.tooltip.wireless_charger.1"), StatCollector.func_74837_a((String)"gtpp.tooltip.wireless_charger.2", (Object[])new Object[]{this.getLongRange(false)}), StatCollector.func_74837_a((String)"gtpp.tooltip.wireless_charger.3", (Object[])new Object[]{this.getLocalRange(false)}), StatCollector.func_74837_a((String)"gtpp.tooltip.wireless_charger.4", (Object[])new Object[]{this.getLongRange(true), this.getLocalRange(true)}), GTPPCore.GT_Tooltip.get()};
    }

    private static String translateChat(String key) {
        return StatCollector.func_74838_a((String)("gtpp.chat.wireless_charger." + key));
    }

    private static String translateChat(String key, Object ... args) {
        return StatCollector.func_74837_a((String)("gtpp.chat.wireless_charger." + key), (Object[])args);
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[10][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getFront(i);
            rTextures[1][i + 1] = this.getBack(i);
            rTextures[2][i + 1] = this.getBottom(i);
            rTextures[3][i + 1] = this.getTop(i);
            rTextures[4][i + 1] = this.getSides(i);
            rTextures[5][i + 1] = this.getFrontActive(i);
            rTextures[6][i + 1] = this.getBackActive(i);
            rTextures[7][i + 1] = this.getBottomActive(i);
            rTextures[8][i + 1] = this.getTopActive(i);
            rTextures[9][i + 1] = this.getSidesActive(i);
        }
        return rTextures;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstone) {
        return this.mTextures[(baseMetaTileEntity.isAllowedToWork() ? 5 : 0) + (side == facing ? 0 : (side == facing.getOpposite() ? 1 : (side == ForgeDirection.DOWN ? 2 : (side == ForgeDirection.UP ? 3 : 4))))][colorIndex + 1];
    }

    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Casing_Machine_Screen_Inactive)};
    }

    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Casing_Machine_Simple_Bottom)};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Casing_Machine_Simple_Bottom)};
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Casing_Machine_Simple_Bottom)};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Casing_Machine_Simple_Bottom)};
    }

    public ITexture[] getFrontActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Casing_Machine_Screen_2)};
    }

    public ITexture[] getBackActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Casing_Machine_Simple_Bottom)};
    }

    public ITexture[] getBottomActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Casing_Machine_Simple_Bottom)};
    }

    public ITexture[] getTopActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Casing_Machine_Simple_Bottom)};
    }

    public ITexture[] getSidesActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Casing_Machine_Simple_Bottom)};
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer player, float x, float y, float z, ItemStack tool) {
        if (player.func_70093_af()) {
            this.locked = !this.locked;
            GTUtility.sendChatToPlayer(player, MTEWirelessCharger.translateChat(this.locked ? "lock" : "unlock"));
            return;
        }
        this.longRangeMap.clear();
        this.localRangeMap.clear();
        this.mode = this.mode.next();
        if (this.mode == ChargeMode.LONG_RANGE) {
            GTUtility.sendChatToPlayer(player, MTEWirelessCharger.translateChat("mode_change", MTEWirelessCharger.translateChat("mode.long"), MTEWirelessCharger.translateChat("mode")));
        } else if (this.mode == ChargeMode.LOCAL) {
            GTUtility.sendChatToPlayer(player, MTEWirelessCharger.translateChat("mode_change", MTEWirelessCharger.translateChat("mode.local"), MTEWirelessCharger.translateChat("mode")));
        } else {
            GTUtility.sendChatToPlayer(player, MTEWirelessCharger.translateChat("mode_change", MTEWirelessCharger.translateChat("mode.mixed"), MTEWirelessCharger.translateChat("mode")));
        }
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEWirelessCharger(this.mName, (int)this.mTier, null, this.mTextures, this.mInventory.length);
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return side != this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isTeleporterCompatible() {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return 0L;
    }

    @Override
    public long maxEUStore() {
        return GTValues.V[this.mTier] * 128L;
    }

    @Override
    public int getCapacity() {
        return (int)(GTValues.V[this.mTier] * 32L);
    }

    @Override
    public long maxEUInput() {
        return GTValues.V[this.mTier];
    }

    @Override
    public long maxAmperesIn() {
        if (this.mode == ChargeMode.LONG_RANGE) {
            return (long)this.longRangeMap.size() + 1L;
        }
        if (this.mode == ChargeMode.LOCAL) {
            return (long)this.localRangeMap.size() * 2L + 1L;
        }
        return (long)(this.localRangeMap.size() + this.longRangeMap.size()) + 1L;
    }

    @Override
    public long maxAmperesOut() {
        return 0L;
    }

    @Override
    public int getProgresstime() {
        return (int)this.getBaseMetaTileEntity().getUniversalEnergyStored();
    }

    @Override
    public int maxProgresstime() {
        return (int)this.getBaseMetaTileEntity().getUniversalEnergyCapacity();
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public String[] getInfoData() {
        return new String[]{this.getLocalName()};
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public int[] func_94128_d(int p_94128_1_) {
        return GTValues.emptyIntArray;
    }

    @Override
    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return false;
    }

    @Override
    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return false;
    }

    @Override
    public int func_70302_i_() {
        return 0;
    }

    @Override
    public ItemStack func_70301_a(int p_70301_1_) {
        return null;
    }

    @Override
    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return null;
    }

    @Override
    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
    }

    @Override
    public String func_145825_b() {
        return null;
    }

    @Override
    public int func_70297_j_() {
        return 0;
    }

    @Override
    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return false;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74757_a("mLocked", this.locked);
        aNBT.func_74768_a("mMode", this.mode.ordinal());
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.locked = aNBT.func_74767_n("mLocked");
        this.mode = ChargeMode.fromOrdinal(aNBT.func_74762_e("mMode"));
    }

    private boolean isValidPlayer(EntityPlayer aPlayer) {
        BaseMetaTileEntity aTile = (BaseMetaTileEntity)this.getBaseMetaTileEntity();
        if (this.locked || aTile != null && aTile.privateAccess()) {
            return aPlayer.func_110124_au().equals(this.getBaseMetaTileEntity().getOwnerUuid());
        }
        return true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity mte, long tick) {
        super.onPostTick(mte, tick);
        if (!mte.isServerSide()) {
            return;
        }
        if (mte.isAllowedToWork()) {
            int prevRange = this.maxCurrentRange;
            this.maxCurrentRange = this.getMaxRange();
            if (prevRange != this.maxCurrentRange) {
                GTMod.proxy.wirelessChargerManager.addCharger(this, this.maxCurrentRange);
            }
        } else if (this.maxCurrentRange != -1) {
            GTMod.proxy.wirelessChargerManager.removeCharger(this);
            this.maxCurrentRange = -1;
        }
        if (tick % 20L == 0L) {
            for (EntityPlayer player : mte.getWorld().field_73010_i) {
                double range;
                double distSq = player.func_70092_e((double)mte.getXCoord(), (double)mte.getYCoord(), (double)mte.getZCoord());
                if (this.mode == ChargeMode.LOCAL || this.mode == ChargeMode.MIXED) {
                    range = this.getLocalRange(this.mode == ChargeMode.MIXED);
                    if (distSq < range * range) {
                        if (this.isValidPlayer(player) && !this.localRangeMap.containsKey(player.func_146103_bH().getName())) {
                            this.localRangeMap.put(player.func_146103_bH().getName(), player.getPersistentID());
                        }
                    } else {
                        this.localRangeMap.remove(player.func_146103_bH().getName());
                    }
                }
                if (this.mode != ChargeMode.LONG_RANGE && this.mode != ChargeMode.MIXED) continue;
                range = this.getLongRange(this.mode == ChargeMode.MIXED);
                if (distSq <= range * range) {
                    if (this.longRangeMap.containsKey(player.func_146103_bH().getName()) || !this.isValidPlayer(player)) continue;
                    this.longRangeMap.put(player.func_146103_bH().getName(), player.getPersistentID());
                    GTUtility.sendChatToPlayer(player, MTEWirelessCharger.translateChat("enter", (int)range, MTEWirelessCharger.translateChat("mode.long")));
                    continue;
                }
                if (!this.longRangeMap.containsKey(player.func_146103_bH().getName()) || this.longRangeMap.remove(player.func_146103_bH().getName()) == null) continue;
                GTUtility.sendChatToPlayer(player, MTEWirelessCharger.translateChat("leave", (int)range, MTEWirelessCharger.translateChat("mode.long")));
            }
        }
    }

    @Override
    public void onRemoval() {
        IGregTechTileEntity mte = this.getBaseMetaTileEntity();
        if (mte.isServerSide()) {
            GTMod.proxy.wirelessChargerManager.removeCharger(this);
        }
        super.onRemoval();
    }

    @Override
    public void onUnload() {
        IGregTechTileEntity mte = this.getBaseMetaTileEntity();
        if (mte.isServerSide()) {
            GTMod.proxy.wirelessChargerManager.removeCharger(this);
        }
        super.onUnload();
    }

    private int getLongRange(boolean mixed) {
        return (int)GTValues.V[this.mTier] * (mixed ? 2 : 4);
    }

    private int getLocalRange(boolean mixed) {
        return this.mTier * (mixed ? 10 : 20);
    }

    private int getMaxRange() {
        int n;
        switch (this.mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case LONG_RANGE: {
                n = this.getLongRange(false);
                break;
            }
            case LOCAL: {
                n = this.getLocalRange(false);
                break;
            }
            case MIXED: {
                n = this.getLongRange(true);
            }
        }
        return n;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity baseMetaTileEntity, EntityPlayer player, ForgeDirection side, float x, float y, float z) {
        if (this.mode == ChargeMode.LONG_RANGE) {
            GTUtility.sendChatToPlayer(player, MTEWirelessCharger.translateChat("mode_info", MTEWirelessCharger.translateChat("mode.long"), MTEWirelessCharger.translateChat("mode")));
            GTUtility.sendChatToPlayer(player, MTEWirelessCharger.translateChat("range") + String.format(": %sm", NumberFormat.getInstance().format(this.getLongRange(false))));
            GTUtility.sendChatToPlayer(player, MTEWirelessCharger.translateChat("mode_info_player"));
            for (String name : this.longRangeMap.keySet()) {
                GTUtility.sendChatToPlayer(player, name);
            }
        } else if (this.mode == ChargeMode.LOCAL) {
            GTUtility.sendChatToPlayer(player, MTEWirelessCharger.translateChat("mode_info", MTEWirelessCharger.translateChat("mode.local"), MTEWirelessCharger.translateChat("mode")));
            GTUtility.sendChatToPlayer(player, MTEWirelessCharger.translateChat("range") + String.format(": %sm", NumberFormat.getInstance().format(this.getLocalRange(false))));
            GTUtility.sendChatToPlayer(player, MTEWirelessCharger.translateChat("mode_info_player"));
            for (String name : this.localRangeMap.keySet()) {
                GTUtility.sendChatToPlayer(player, name);
            }
        } else {
            GTUtility.sendChatToPlayer(player, MTEWirelessCharger.translateChat("mode_info", MTEWirelessCharger.translateChat("mode.mixed"), MTEWirelessCharger.translateChat("mode")));
            NumberFormat numberFormat = NumberFormat.getInstance();
            GTUtility.sendChatToPlayer(player, String.format("%s: %sm (%s: %sm)", MTEWirelessCharger.translateChat("range"), numberFormat.format(this.getLongRange(true)), MTEWirelessCharger.translateChat("mode.local"), numberFormat.format(this.getLocalRange(true))));
            GTUtility.sendChatToPlayer(player, MTEWirelessCharger.translateChat("mode_info_player"));
            for (String name : this.localRangeMap.keySet()) {
                GTUtility.sendChatToPlayer(player, MTEWirelessCharger.translateChat("mode.local") + ": " + name);
            }
            for (String name : this.longRangeMap.keySet()) {
                GTUtility.sendChatToPlayer(player, MTEWirelessCharger.translateChat("mode.long") + ": " + name);
            }
        }
        return super.onRightclick(baseMetaTileEntity, player, side, x, y, z);
    }

    @Override
    public IGregTechTileEntity getChargerTE() {
        return this.getBaseMetaTileEntity();
    }

    @Override
    public boolean canChargePlayerItems(EntityPlayer player) {
        if (this.mode == ChargeMode.LONG_RANGE) {
            return this.longRangeMap.containsKey(player.func_146103_bH().getName());
        }
        if (this.mode == ChargeMode.LOCAL) {
            return this.localRangeMap.containsKey(player.func_146103_bH().getName());
        }
        if (this.longRangeMap.containsKey(player.func_146103_bH().getName())) {
            return true;
        }
        return this.localRangeMap.containsKey(player.func_146103_bH().getName());
    }

    @Override
    public void chargePlayerItems(EntityPlayer player, ItemStack[] ... inventories) {
        int amp;
        if (this.localRangeMap.containsKey(player.func_146103_bH().getName())) {
            amp = 2;
        } else if (this.longRangeMap.containsKey(player.func_146103_bH().getName())) {
            amp = 1;
        } else {
            return;
        }
        long storedEU = this.getEUVar();
        long maxChargeableEU = Math.min(storedEU, this.maxEUInput() * (long)amp * 20L);
        long chargedEU = 0L;
        block0: for (ItemStack[] stacks : inventories) {
            if (chargedEU >= maxChargeableEU) break;
            if (stacks == null) continue;
            for (ItemStack stack : stacks) {
                Item charged2;
                if (chargedEU >= maxChargeableEU) continue block0;
                if (stack == null) continue;
                int chargeableEU = (int)Math.min(Integer.MAX_VALUE, Math.min(maxChargeableEU - chargedEU, this.maxEUInput() * 20L));
                if (stack.func_77973_b() instanceof IElectricItem) {
                    int charged2 = Math.max(0, (int)ElectricItem.manager.charge(stack, (double)chargeableEU, Integer.MAX_VALUE, true, false));
                    chargedEU += (long)charged2;
                    continue;
                }
                if (!Mods.COFHCore.isModLoaded() || !((charged2 = stack.func_77973_b()) instanceof IEnergyContainerItem)) continue;
                IEnergyContainerItem rfItem = (IEnergyContainerItem)charged2;
                int chargeableRF = Math.min(rfItem.getMaxEnergyStored(stack) - rfItem.getEnergyStored(stack), (int)Math.min(Integer.MAX_VALUE, (long)chargeableEU * (long)GregTechAPI.mEUtoRF / 100L));
                int chargedRF = rfItem.receiveEnergy(stack, chargeableRF, false);
                chargedEU += (long)chargedRF * 100L / (long)GregTechAPI.mEUtoRF;
            }
        }
        this.setEUVar(storedEU - chargedEU);
    }

    private static enum ChargeMode {
        LONG_RANGE,
        LOCAL,
        MIXED;


        public ChargeMode next() {
            ChargeMode chargeMode;
            switch (this) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case LONG_RANGE: {
                    chargeMode = LOCAL;
                    break;
                }
                case LOCAL: {
                    chargeMode = MIXED;
                    break;
                }
                case MIXED: {
                    chargeMode = LONG_RANGE;
                }
            }
            return chargeMode;
        }

        public static ChargeMode fromOrdinal(int ordinal) {
            ChargeMode chargeMode;
            switch (ordinal) {
                case 1: {
                    chargeMode = LOCAL;
                    break;
                }
                case 2: {
                    chargeMode = MIXED;
                    break;
                }
                default: {
                    chargeMode = LONG_RANGE;
                }
            }
            return chargeMode;
        }
    }
}

