/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.cover;

import gregtech.api.covers.CoverContext;
import gregtech.api.hazards.HazardProtection;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.common.covers.Cover;
import ic2.api.info.Info;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.mechanics.tesla.ITeslaConnectable;
import tectech.mechanics.tesla.TeslaCoverConnection;

public class CoverTeslaCoil
extends Cover {
    public CoverTeslaCoil(CoverContext context) {
        super(context, null);
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable != null && this.coverSide == ForgeDirection.UP || coverable.getEUCapacity() > 0L) {
            ITeslaConnectable.TeslaUtil.teslaSimpleNodeSetAdd(new TeslaCoverConnection(coverable.getIGregTechTileEntityOffset(0, 0, 0), this.getTeslaReceptionCapability()));
        }
    }

    @Override
    public void onCoverUnload() {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable instanceof IGregTechTileEntity) {
            IGregTechTileEntity IGT = (IGregTechTileEntity)coverable;
            if (!coverable.isClientSide()) {
                ITeslaConnectable.TeslaUtil.teslaSimpleNodeSetRemove(new TeslaCoverConnection(IGT, this.getTeslaReceptionCapability()));
            }
        }
    }

    @Override
    public void onCoverRemoval() {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable instanceof IGregTechTileEntity) {
            IGregTechTileEntity IGT = (IGregTechTileEntity)coverable;
            ITeslaConnectable.TeslaUtil.teslaSimpleNodeSetRemove(new TeslaCoverConnection(IGT, this.getTeslaReceptionCapability()));
        }
    }

    @Override
    public void onBaseTEDestroyed() {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable instanceof IGregTechTileEntity) {
            IGregTechTileEntity IGT = (IGregTechTileEntity)coverable;
            ITeslaConnectable.TeslaUtil.teslaSimpleNodeSetRemove(new TeslaCoverConnection(IGT, this.getTeslaReceptionCapability()));
        }
    }

    @Override
    public String getDescription() {
        return "Do not attempt to use screwdriver!";
    }

    @Override
    public boolean letsEnergyIn() {
        return true;
    }

    @Override
    public void onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable != null && coverable.getStoredEU() > 0L && !HazardProtection.isWearingFullElectroHazmat((EntityLivingBase)aPlayer)) {
            aPlayer.func_70097_a(Info.DMG_ELECTRIC, 20.0f);
        }
    }

    @Override
    public int getMinimumTickRate() {
        return 10;
    }

    public byte getTeslaReceptionCapability() {
        return 2;
    }
}

