/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.item;

import com.gtnewhorizon.gtnhlib.item.FastImmutableItemStack;
import com.gtnewhorizon.gtnhlib.item.ImmutableItemStack;
import com.gtnewhorizon.gtnhlib.item.InventoryIterator;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import net.minecraft.item.ItemStack;

public abstract class AbstractInventoryIterator
implements InventoryIterator {
    public static final int[] NO_SLOTS = new int[0];
    private final int[] slots;
    private int i = 0;
    private int last = 0;
    private final FastImmutableItemStack pooled = new FastImmutableItemStack(null);

    protected AbstractInventoryIterator(int[] slots) {
        this.slots = slots;
    }

    protected AbstractInventoryIterator(int[] a, int[] b) {
        this.slots = a == null && b == null ? NO_SLOTS : (a == null || b == null ? (a == null ? b : a) : AbstractInventoryIterator.intersect(a, b));
    }

    public static int[] intersect(int[] a, int[] b) {
        IntLinkedOpenHashSet a2 = new IntLinkedOpenHashSet(a);
        IntLinkedOpenHashSet b2 = new IntLinkedOpenHashSet(b);
        IntArrayList out = new IntArrayList();
        a2.forEach(i -> {
            if (b2.contains(i)) {
                out.add(i);
            }
        });
        return out.toIntArray();
    }

    protected abstract ItemStack getStackInSlot(int var1);

    protected boolean canExtract(ItemStack stack, int slot) {
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.i < this.slots.length;
    }

    @Override
    public ImmutableItemStack next() {
        this.last = this.i++;
        this.pooled.stack = this.getStackInSlot(this.slots[this.last]);
        return this.pooled.stack == null || !this.canExtract(this.pooled.stack, this.slots[this.last]) ? null : this.pooled;
    }

    @Override
    public boolean hasPrevious() {
        return this.i > 0;
    }

    @Override
    public ImmutableItemStack previous() {
        this.last = --this.i;
        this.pooled.stack = this.getStackInSlot(this.slots[this.last]);
        return this.pooled.stack == null || !this.canExtract(this.pooled.stack, this.slots[this.last]) ? null : this.pooled;
    }

    @Override
    public int nextIndex() {
        return this.slots[this.last + 1];
    }

    @Override
    public int previousIndex() {
        return this.slots[this.last - 1];
    }

    @Override
    public boolean rewind() {
        this.i = 0;
        return true;
    }

    protected final int getCurrentSlot() {
        return this.slots[this.last];
    }
}

