/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.commands;

import com.mitchej123.hodgepodge.util.AnchorAlarm;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class DebugCommand
extends CommandBase {
    public String func_71517_b() {
        return "hp";
    }

    public String func_71518_a(ICommandSender sender) {
        return "Usage: hp <subcommand>. Valid subcommands are: toggle, anchor, randomNbt.";
    }

    private void printHelp(ICommandSender sender) {
        sender.func_145747_a((IChatComponent)new ChatComponentText("Usage: hp <toggle|anchor|randomNbt>"));
        sender.func_145747_a((IChatComponent)new ChatComponentText("\"toggle anchordebug\" - toggles RC anchor debugging"));
        sender.func_145747_a((IChatComponent)new ChatComponentText("\"anchor list [player]\" - list RC anchors placed by the player (empty for current player)"));
        sender.func_145747_a((IChatComponent)new ChatComponentText("\"randomNbt [bytes]\" - adds a random byte array of the given size to the held item"));
    }

    public List<String> func_71516_a(ICommandSender sender, String[] ss) {
        String test;
        ArrayList<String> l = new ArrayList<String>();
        String string = test = ss.length == 0 ? "" : ss[0].trim();
        if (ss.length == 0 || ss.length == 1 && (test.isEmpty() || Stream.of("toggle", "anchor", "randomNbt").anyMatch(s -> s.startsWith(test)))) {
            Stream.of("toggle", "anchor", "randomNbt").filter(s -> test.isEmpty() || s.startsWith(test)).forEach(l::add);
        } else if (test.equals("toggle")) {
            String test1 = ss[1].trim();
            if (test1.isEmpty() || "anchordebug".startsWith(test1)) {
                l.add("anchordebug");
            }
        } else if (test.equals("anchor")) {
            String test1 = ss[1].trim();
            if (test1.isEmpty() || "list".startsWith(test1) && !"list".equals(test1)) {
                l.add("list");
            } else if ("list".equals(test1) && ss.length > 2) {
                l.addAll(DebugCommand.func_71530_a((String[])ss, (String[])MinecraftServer.func_71276_C().func_71213_z()));
            }
        }
        return l;
    }

    public void func_71515_b(ICommandSender sender, String[] strings) {
        if (strings.length < 1) {
            this.printHelp(sender);
            return;
        }
        switch (strings[0]) {
            case "toggle": {
                if (strings.length < 2 || !strings[1].equals("anchordebug")) {
                    this.printHelp(sender);
                    return;
                }
                AnchorAlarm.AnchorDebug = !AnchorAlarm.AnchorDebug;
                sender.func_145747_a((IChatComponent)new ChatComponentText("Anchor debugging: " + AnchorAlarm.AnchorDebug));
                break;
            }
            case "anchor": {
                String playerName;
                if (strings.length < 2 || !strings[1].equals("list")) {
                    this.printHelp(sender);
                    return;
                }
                String string = playerName = strings.length > 2 ? strings[2] : sender.func_70005_c_();
                if (!AnchorAlarm.listSavedAnchors(playerName, sender.func_130014_f_())) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("No such player entity in the current world : " + playerName));
                    break;
                }
                sender.func_145747_a((IChatComponent)new ChatComponentText("Saved anchors dumped to the log for player: " + playerName));
                break;
            }
            case "randomNbt": {
                if (strings.length < 2) {
                    this.printHelp(sender);
                    return;
                }
                int byteCount = NumberUtils.toInt((String)strings[1], (int)-1);
                if (byteCount < 1) {
                    this.printHelp(sender);
                    return;
                }
                EntityPlayerMP player = DebugCommand.func_71521_c((ICommandSender)sender);
                if (player.field_71071_by == null) {
                    return;
                }
                ItemStack stack = player.field_71071_by.func_70448_g();
                if (stack == null || stack.func_77973_b() == null) {
                    return;
                }
                if (stack.field_77990_d == null) {
                    stack.field_77990_d = new NBTTagCompound();
                }
                byte[] randomData = RandomUtils.nextBytes((int)byteCount);
                stack.field_77990_d.func_74773_a("DebugJunk", randomData);
                player.field_71071_by.field_70459_e = true;
                player.field_71069_bz.func_75142_b();
            }
        }
    }
}

