/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.core.fml.transformers.mc;

import com.mitchej123.hodgepodge.core.HodgepodgeCore;
import com.mitchej123.hodgepodge.core.shared.HodgepodgeClassDump;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class NBTTagCompoundHashMapTransformer
implements IClassTransformer {
    private static final Logger LOGGER = LogManager.getLogger((String)"NBTTagCompoundHashMapTransformer");
    private static final String INIT = "<init>";
    private static final String EMPTY_DESC = "()V";
    private static final String HASHMAP = "java/util/HashMap";
    private static final String FASTUTIL_HASHMAP = "it/unimi/dsi/fastutil/objects/Object2ObjectOpenHashMap";
    private static final String NBT_TAG_COMPOUND = "net.minecraft.nbt.NBTTagCompound";

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if (NBT_TAG_COMPOUND.equals(transformedName)) {
            byte[] transformedBytes = NBTTagCompoundHashMapTransformer.transformBytes(basicClass);
            HodgepodgeClassDump.dumpClass(transformedName, basicClass, transformedBytes, this);
            return transformedBytes;
        }
        return basicClass;
    }

    private static byte[] transformBytes(byte[] basicClass) {
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        boolean changed = NBTTagCompoundHashMapTransformer.transformClassNode(cn);
        if (changed) {
            ClassWriter cw = new ClassWriter(1);
            cn.accept((ClassVisitor)cw);
            return cw.toByteArray();
        }
        return basicClass;
    }

    private static boolean transformClassNode(ClassNode cn) {
        boolean changed = false;
        for (MethodNode mn : cn.methods) {
            if (!mn.name.equals(INIT) || !mn.desc.equals(EMPTY_DESC)) continue;
            for (AbstractInsnNode node : mn.instructions.toArray()) {
                if (node.getOpcode() == 187 && node instanceof TypeInsnNode) {
                    TypeInsnNode tNode = (TypeInsnNode)node;
                    if (!tNode.desc.equals(HASHMAP)) continue;
                    HodgepodgeCore.logASM(LOGGER, "Found HashMap instantiation in NBTTagCompound.<init>");
                    mn.instructions.insertBefore((AbstractInsnNode)tNode, (AbstractInsnNode)new TypeInsnNode(187, FASTUTIL_HASHMAP));
                    mn.instructions.remove((AbstractInsnNode)tNode);
                    changed = true;
                    continue;
                }
                if (node.getOpcode() != 183 || !(node instanceof MethodInsnNode)) continue;
                MethodInsnNode mNode = (MethodInsnNode)node;
                if (!mNode.name.equals(INIT) || !mNode.desc.equals(EMPTY_DESC) || !mNode.owner.equals(HASHMAP)) continue;
                HodgepodgeCore.logASM(LOGGER, "Found HashMap constructor call in NBTTagCompound.<init>");
                mn.instructions.insertBefore((AbstractInsnNode)mNode, (AbstractInsnNode)new LdcInsnNode((Object)4));
                mn.instructions.insertBefore((AbstractInsnNode)mNode, (AbstractInsnNode)new MethodInsnNode(183, FASTUTIL_HASHMAP, INIT, "(I)V", false));
                mn.instructions.remove((AbstractInsnNode)mNode);
                changed = true;
            }
        }
        return changed;
    }
}

