/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.core.fml.transformers.mc;

import com.mitchej123.hodgepodge.core.HodgepodgeCore;
import com.mitchej123.hodgepodge.core.shared.HodgepodgeClassDump;
import java.util.ArrayList;
import java.util.ListIterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class SpeedupOreDictionaryTransformer
implements IClassTransformer,
Opcodes {
    private static final Logger LOGGER = LogManager.getLogger((String)"SpeedupOreDictionaryTransformer");
    private static final String ORE_DICTIONARY = "net/minecraftforge/oredict/OreDictionary";
    private static final String JAVA_HASH_SET = "java/util/HashSet";
    private static final String JAVA_HASH_MAP = "java/util/HashMap";
    private static final String JAVA_MAP = "java/util/Map";
    private static final String FASTUTIL_INT_OPEN_HASH_SET = "it/unimi/dsi/fastutil/ints/IntOpenHashSet";
    private static final String FASTUTIL_INT_COLLECTION = "it/unimi/dsi/fastutil/ints/IntCollection";
    private static final String FASTUTIL_OBJECT_2_INT_HASH_MAP = "it/unimi/dsi/fastutil/objects/Object2IntOpenHashMap";
    private static final String FASTUTIL_INT_2_OBJECT_HASH_MAP = "it/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap";
    private static final String INTEGER = "java/lang/Integer";
    private String itemStackClass;
    private String itemClass;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if ("net.minecraftforge.oredict.OreDictionary".equals(transformedName)) {
            boolean isObf = HodgepodgeCore.isObf();
            this.itemStackClass = isObf ? "add" : "net/minecraft/item/ItemStack";
            this.itemClass = isObf ? "adb" : "net/minecraft/item/Item";
            HodgepodgeCore.logASM(LOGGER, "OreDictionary is obfuscated: {" + isObf + "}");
            byte[] transformedBytes = this.transformOreDictionary(basicClass);
            HodgepodgeClassDump.dumpClass(transformedName, basicClass, transformedBytes, this);
            return transformedBytes;
        }
        return basicClass;
    }

    private byte[] transformOreDictionary(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        boolean modified = false;
        FieldNode emptyIntArrayField = new FieldNode(25, "EMPTY_INT_ARRAY", "[I", null, null);
        classNode.fields.add(emptyIntArrayField);
        HodgepodgeCore.logASM(LOGGER, "Transforming OreDictionary class");
        for (MethodNode method : classNode.methods) {
            if ("<clinit>".equals(method.name)) {
                HodgepodgeCore.logASM(LOGGER, "Transforming OreDictionary.<clinit>");
                modified |= this.transformClinitMethod(method);
            } else if ("getOreID".equals(method.name) && "(Ljava/lang/String;)I".equals(method.desc)) {
                HodgepodgeCore.logASM(LOGGER, "Transforming OreDictionary.getOreID(String)");
                modified |= this.transformGetOreIDStringMethod(method);
            } else if ("getOreID".equals(method.name) && ("(L" + this.itemStackClass + ";)I").equals(method.desc)) {
                HodgepodgeCore.logASM(LOGGER, "Transforming OreDictionary.getOreID(ItemStack)");
                modified |= this.transformGetOreIDItemStackMethod(method);
            } else if ("getOreIDs".equals(method.name) && ("(L" + this.itemStackClass + ";)[I").equals(method.desc)) {
                HodgepodgeCore.logASM(LOGGER, "Transforming OreDictionary.getOreIDs(ItemStack)");
                modified |= this.transformGetOreIDsMethod(method);
            } else if ("getOres".equals(method.name) && "(Ljava/lang/String;Z)Ljava/util/List;".equals(method.desc)) {
                HodgepodgeCore.logASM(LOGGER, "Transforming OreDictionary.getOres(String, boolean)");
                modified |= this.transformGetOresMethod(method);
            } else if ("getOres".equals(method.name) && "(I)Ljava/util/ArrayList;".equals(method.desc)) {
                HodgepodgeCore.logASM(LOGGER, "Transforming OreDictionary.getOres(int)");
                modified |= this.transformGetOresIntMethod(method);
            } else if ("registerOreImpl".equals(method.name) && ("(Ljava/lang/String;L" + this.itemStackClass + ";)V").equals(method.desc)) {
                HodgepodgeCore.logASM(LOGGER, "Transforming OreDictionary.registerOreImpl(String, ItemStack)");
                modified |= this.transformRegisterOreImplMethod(method);
            } else if ("rebakeMap".equals(method.name) && "()V".equals(method.desc)) {
                HodgepodgeCore.logASM(LOGGER, "Transforming OreDictionary.rebakeMap()");
                modified |= this.transformRebakeMapMethod(method);
            }
            for (LocalVariableNode localVar : method.localVariables) {
                if (!"Ljava/lang/Integer;".equals(localVar.desc)) continue;
                localVar.desc = "I";
                if (localVar.signature == null || !localVar.signature.contains("Integer")) continue;
                localVar.signature = null;
            }
        }
        if (modified) {
            try {
                HodgepodgeCore.logASM(LOGGER, "Writing transformed OreDictionary class");
                ClassWriter writer = new ClassWriter(3);
                classNode.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }
            catch (Exception e) {
                LOGGER.error("Failed to transform OreDictionary class", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return basicClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean transformClinitMethod(MethodNode method) {
        InsnList instructions = method.instructions;
        boolean modified = false;
        for (AbstractInsnNode node : instructions) {
            AbstractInsnNode next;
            if (node.getOpcode() == 179 && node instanceof FieldInsnNode) {
                FieldInsnNode fNode = (FieldInsnNode)node;
                if (fNode.owner.equals(ORE_DICTIONARY) && fNode.name.equals("idToName")) {
                    modified = true;
                    for (next = node.getNext(); next != null && next.getOpcode() != 187; next = next.getNext()) {
                    }
                    if (next == null || next.getOpcode() != 187 || !(next instanceof TypeInsnNode)) throw new RuntimeException("Unexpected instruction found in OreDictionary.<clinit>");
                    TypeInsnNode tNode = (TypeInsnNode)next;
                    if (!tNode.desc.equals(JAVA_HASH_MAP)) throw new RuntimeException("Unexpected instruction found in OreDictionary.<clinit>");
                    tNode.desc = FASTUTIL_OBJECT_2_INT_HASH_MAP;
                    while (next != null && next.getOpcode() != 183) {
                        next = next.getNext();
                    }
                    if (next == null || next.getOpcode() != 183 || !(next instanceof MethodInsnNode)) throw new RuntimeException("Unexpected instruction found in OreDictionary.<clinit>");
                    MethodInsnNode mNext = (MethodInsnNode)next;
                    if (!mNext.owner.equals(JAVA_HASH_MAP)) throw new RuntimeException("Unexpected instruction found in OreDictionary.<clinit>");
                    mNext.owner = FASTUTIL_OBJECT_2_INT_HASH_MAP;
                    continue;
                }
            }
            if (node.getOpcode() == 179 && node instanceof FieldInsnNode) {
                FieldInsnNode fNode = (FieldInsnNode)node;
                if (fNode.owner.equals(ORE_DICTIONARY) && fNode.name.equals("idToStackUn")) {
                    modified = true;
                    InsnList newInstructions = new InsnList();
                    newInstructions.add((AbstractInsnNode)new TypeInsnNode(187, FASTUTIL_INT_2_OBJECT_HASH_MAP));
                    newInstructions.add((AbstractInsnNode)new InsnNode(89));
                    instructions.insert(node, newInstructions);
                    for (next = node.getNext(); next != null && next.getOpcode() != 184; next = next.getNext()) {
                    }
                    if (next == null || next.getOpcode() != 184 || !(next instanceof MethodInsnNode)) throw new RuntimeException("Unexpected instruction found in OreDictionary.<clinit>");
                    instructions.insertBefore(next, (AbstractInsnNode)new MethodInsnNode(183, FASTUTIL_INT_2_OBJECT_HASH_MAP, "<init>", "(I)V", false));
                    instructions.remove(next);
                    continue;
                }
            }
            if (node.getOpcode() != 184 || !(node instanceof MethodInsnNode)) continue;
            MethodInsnNode mNode = (MethodInsnNode)node;
            if (!mNode.name.equals("initVanillaEntries")) continue;
            modified = true;
            InsnList newInstrList = new InsnList();
            newInstrList.add((AbstractInsnNode)new InsnNode(3));
            newInstrList.add((AbstractInsnNode)new IntInsnNode(188, 10));
            newInstrList.add((AbstractInsnNode)new FieldInsnNode(179, ORE_DICTIONARY, "EMPTY_INT_ARRAY", "[I"));
            newInstrList.add((AbstractInsnNode)new FieldInsnNode(178, ORE_DICTIONARY, "nameToId", "Ljava/util/Map;"));
            newInstrList.add((AbstractInsnNode)new TypeInsnNode(192, FASTUTIL_OBJECT_2_INT_HASH_MAP));
            newInstrList.add((AbstractInsnNode)new InsnNode(2));
            newInstrList.add((AbstractInsnNode)new MethodInsnNode(182, FASTUTIL_OBJECT_2_INT_HASH_MAP, "defaultReturnValue", "(I)V", false));
            instructions.insertBefore(node, newInstrList);
        }
        return modified;
    }

    private boolean transformGetOreIDStringMethod(MethodNode method) {
        InsnList instructions = method.instructions;
        boolean modified = false;
        for (AbstractInsnNode node : instructions) {
            block25: {
                MethodInsnNode mNext;
                AbstractInsnNode next;
                block27: {
                    block26: {
                        if (node.getOpcode() != 178 || !(node instanceof FieldInsnNode)) break block25;
                        FieldInsnNode fNode = (FieldInsnNode)node;
                        if (!fNode.owner.equals(ORE_DICTIONARY) || !fNode.name.equals("nameToId")) break block25;
                        modified = true;
                        instructions.insert(node, (AbstractInsnNode)new TypeInsnNode(192, FASTUTIL_OBJECT_2_INT_HASH_MAP));
                        for (next = node.getNext(); next != null && next.getOpcode() != 185; next = next.getNext()) {
                        }
                        if (!(next instanceof MethodInsnNode)) break block26;
                        mNext = (MethodInsnNode)next;
                        if (mNext.owner.equals(JAVA_MAP)) break block27;
                    }
                    throw new RuntimeException("Unexpected instruction found in OreDictionary.getOreID(String) method");
                }
                mNext.setOpcode(182);
                mNext.owner = FASTUTIL_OBJECT_2_INT_HASH_MAP;
                mNext.itf = false;
                ArrayList<AbstractInsnNode> toRemove = new ArrayList<AbstractInsnNode>();
                if (mNext.name.equals("put")) {
                    mNext.desc = "(Ljava/lang/Object;I)I";
                } else if (mNext.name.equals("get")) {
                    VarInsnNode vNode;
                    mNext.name = "getInt";
                    mNext.desc = "(Ljava/lang/Object;)I";
                    while (next != null && next.getOpcode() != 192) {
                        next = next.getNext();
                    }
                    if (next != null && next.getOpcode() == 192) {
                        toRemove.add(next);
                    }
                    while (next != null && next.getOpcode() != 58) {
                        next = next.getNext();
                    }
                    if (next.getOpcode() == 58 && next instanceof VarInsnNode) {
                        vNode = (VarInsnNode)next;
                        if (vNode.var == 1) {
                            vNode.setOpcode(54);
                        }
                    }
                    while (next != null && next.getOpcode() != 25) {
                        next = next.getNext();
                    }
                    if (next != null && next.getOpcode() == 25 && next instanceof VarInsnNode) {
                        vNode = (VarInsnNode)next;
                        if (vNode.var == 1) {
                            vNode.setOpcode(21);
                        }
                    }
                    while (next != null && next.getOpcode() != 199) {
                        next = next.getNext();
                    }
                    if (next instanceof JumpInsnNode) {
                        JumpInsnNode jNode = (JumpInsnNode)next;
                        jNode.setOpcode(160);
                        instructions.insertBefore(next, (AbstractInsnNode)new InsnNode(2));
                    }
                } else {
                    throw new RuntimeException("Unexpected instruction found in OreDictionary.getOreID(String) method");
                }
                for (AbstractInsnNode toRemoveNode : toRemove) {
                    instructions.remove(toRemoveNode);
                }
                continue;
            }
            if ((node.getOpcode() == 184 || node.getOpcode() == 182) && node instanceof MethodInsnNode) {
                MethodInsnNode mNode = (MethodInsnNode)node;
                if (mNode.owner.equals(INTEGER) && (mNode.name.equals("valueOf") || mNode.name.equals("intValue"))) {
                    modified = true;
                    instructions.remove(node);
                    continue;
                }
            }
            if (node.getOpcode() == 58 && node instanceof VarInsnNode) {
                VarInsnNode vNode = (VarInsnNode)node;
                if (vNode.var > 0) {
                    modified = true;
                    vNode.setOpcode(54);
                    continue;
                }
            }
            if (node.getOpcode() != 25 || !(node instanceof VarInsnNode)) continue;
            VarInsnNode vNode = (VarInsnNode)node;
            if (vNode.var <= 0) continue;
            modified = true;
            vNode.setOpcode(21);
        }
        return modified;
    }

    private boolean transformGetOreIDItemStackMethod(MethodNode method) {
        InsnList instructions = method.instructions;
        boolean modified = false;
        for (AbstractInsnNode node : instructions) {
            if (node.getOpcode() == 192 && node instanceof TypeInsnNode) {
                TypeInsnNode checkCastNode = (TypeInsnNode)node;
                if (checkCastNode.desc.equals("java/util/List")) {
                    modified = true;
                    checkCastNode.desc = "it/unimi/dsi/fastutil/ints/IntList";
                    continue;
                }
            }
            if (node.getOpcode() == 185 && node instanceof MethodInsnNode) {
                MethodInsnNode methodNode = (MethodInsnNode)node;
                if (methodNode.owner.equals("java/util/List")) {
                    if (methodNode.name.equals("size")) {
                        modified = true;
                        methodNode.owner = "it/unimi/dsi/fastutil/ints/IntList";
                        continue;
                    }
                    if (!methodNode.name.equals("get")) continue;
                    modified = true;
                    methodNode.owner = "it/unimi/dsi/fastutil/ints/IntList";
                    methodNode.name = "getInt";
                    methodNode.desc = "(I)I";
                    continue;
                }
            }
            if (node.getOpcode() == 192 && node instanceof TypeInsnNode) {
                TypeInsnNode checkCastNode = (TypeInsnNode)node;
                if (checkCastNode.desc.equals(INTEGER)) {
                    modified = true;
                    instructions.remove(node);
                    continue;
                }
            }
            if (node.getOpcode() == 182 && node instanceof MethodInsnNode) {
                MethodInsnNode methodNode = (MethodInsnNode)node;
                if (methodNode.owner.equals(INTEGER) && methodNode.name.equals("intValue")) {
                    modified = true;
                    instructions.remove(node);
                    continue;
                }
            }
            if (node.getOpcode() == 184 && node instanceof MethodInsnNode) {
                MethodInsnNode methodNode = (MethodInsnNode)node;
                if (methodNode.owner.equals(INTEGER) && methodNode.name.equals("valueOf")) {
                    modified = true;
                    instructions.remove(node);
                    continue;
                }
            }
            if (node.getOpcode() == 178 && node instanceof FieldInsnNode) {
                FieldInsnNode fieldNode = (FieldInsnNode)node;
                if (fieldNode.owner.equals(ORE_DICTIONARY) && fieldNode.name.equals("stackToId")) {
                    modified = true;
                    instructions.insert(node, (AbstractInsnNode)new TypeInsnNode(192, FASTUTIL_INT_2_OBJECT_HASH_MAP));
                    continue;
                }
            }
            if (node.getOpcode() != 185 || !(node instanceof MethodInsnNode)) continue;
            MethodInsnNode methodNode = (MethodInsnNode)node;
            if (!methodNode.owner.equals(JAVA_MAP) || !methodNode.name.equals("get")) continue;
            modified = true;
            methodNode.setOpcode(182);
            methodNode.owner = FASTUTIL_INT_2_OBJECT_HASH_MAP;
            methodNode.desc = "(I)Ljava/lang/Object;";
            methodNode.itf = false;
        }
        return modified;
    }

    private boolean transformGetOresMethod(MethodNode method) {
        InsnList instructions = method.instructions;
        boolean modified = false;
        for (AbstractInsnNode node : instructions) {
            AbstractInsnNode next;
            if (node.getOpcode() == 178 && node instanceof FieldInsnNode) {
                FieldInsnNode fNode = (FieldInsnNode)node;
                if (fNode.owner.equals(ORE_DICTIONARY) && fNode.name.equals("nameToId")) {
                    modified = true;
                    instructions.insert(node, (AbstractInsnNode)new TypeInsnNode(192, FASTUTIL_OBJECT_2_INT_HASH_MAP));
                    continue;
                }
            }
            if (node.getOpcode() != 185 || !(node instanceof MethodInsnNode)) continue;
            MethodInsnNode methodNode = (MethodInsnNode)node;
            if (!methodNode.owner.equals(JAVA_MAP) || !methodNode.name.equals("get")) continue;
            modified = true;
            instructions.insertBefore(node, (AbstractInsnNode)new InsnNode(2));
            methodNode.setOpcode(182);
            methodNode.owner = FASTUTIL_OBJECT_2_INT_HASH_MAP;
            methodNode.name = "getOrDefault";
            methodNode.desc = "(Ljava/lang/Object;I)I";
            methodNode.itf = false;
            for (next = node.getNext(); next != null && next.getOpcode() != 198; next = next.getNext()) {
            }
            if (!(next instanceof JumpInsnNode)) continue;
            JumpInsnNode jNode = (JumpInsnNode)next;
            jNode.setOpcode(159);
            instructions.insertBefore(next, (AbstractInsnNode)new InsnNode(2));
        }
        return modified;
    }

    private boolean transformGetOreIDsMethod(MethodNode method) {
        InsnList instructions = method.instructions;
        boolean modified = false;
        Label returnLabel = new Label();
        Label toIntArrayBeforeReturnLabel = new Label();
        LabelNode returnLabelNode = new LabelNode(returnLabel);
        LabelNode toIntArrayBeforeReturnLabelNode = new LabelNode(toIntArrayBeforeReturnLabel);
        ArrayList<AbstractInsnNode> toRemove = new ArrayList<AbstractInsnNode>();
        ListIterator iterator = instructions.iterator();
        boolean foundFirstReturn = false;
        while (iterator.hasNext()) {
            MethodInsnNode methodNode;
            AbstractInsnNode next;
            MethodInsnNode getItemMethodNode;
            AbstractInsnNode node = (AbstractInsnNode)iterator.next();
            if (!foundFirstReturn && node instanceof MethodInsnNode && (getItemMethodNode = (MethodInsnNode)node).getOpcode() == 182 && getItemMethodNode.owner.equals(this.itemStackClass) && getItemMethodNode.name.equals("getItem") && getItemMethodNode.desc.equals("()L" + this.itemClass + ";")) {
                AbstractInsnNode current;
                foundFirstReturn = true;
                modified = true;
                for (next = node.getNext(); next != null && next.getOpcode() != 3; next = next.getNext()) {
                }
                if (next == null) {
                    throw new RuntimeException("Could not find ICONST_0");
                }
                for (current = next; current != null && current.getOpcode() != 176; current = current.getNext()) {
                    toRemove.add(current);
                }
                if (current == null || current.getOpcode() != 176) {
                    throw new RuntimeException("Could not find ARETURN");
                }
                instructions.insertBefore(current, (AbstractInsnNode)new FieldInsnNode(178, ORE_DICTIONARY, "EMPTY_INT_ARRAY", "[I"));
                continue;
            }
            if (node instanceof MethodInsnNode && (methodNode = (MethodInsnNode)node).getOpcode() == 184 && methodNode.owner.equals("cpw/mods/fml/common/FMLLog") && methodNode.name.equals("log") && methodNode.desc.equals("(Lorg/apache/logging/log4j/Level;Ljava/lang/String;[Ljava/lang/Object;)V")) {
                modified = true;
                for (next = (AbstractInsnNode)iterator.next(); next != null && next.getOpcode() != 176; next = next.getNext()) {
                    toRemove.add(next);
                }
                instructions.insert(node, (AbstractInsnNode)new FieldInsnNode(178, ORE_DICTIONARY, "EMPTY_INT_ARRAY", "[I"));
                continue;
            }
            if (node.getOpcode() == 187 && node instanceof TypeInsnNode) {
                TypeInsnNode tNode = (TypeInsnNode)node;
                if (tNode.desc.equals(JAVA_HASH_SET)) {
                    modified = true;
                    tNode.desc = FASTUTIL_INT_OPEN_HASH_SET;
                    continue;
                }
            }
            if (node.getOpcode() == 183 && node instanceof MethodInsnNode) {
                MethodInsnNode mNode = (MethodInsnNode)node;
                if (mNode.owner.equals(JAVA_HASH_SET)) {
                    modified = true;
                    mNode.owner = FASTUTIL_INT_OPEN_HASH_SET;
                    continue;
                }
            }
            if (node.getOpcode() == 178 && node instanceof FieldInsnNode) {
                FieldInsnNode fNode = (FieldInsnNode)node;
                if (fNode.owner.equals(ORE_DICTIONARY) && fNode.name.equals("stackToId")) {
                    modified = true;
                    instructions.insert(node, (AbstractInsnNode)new TypeInsnNode(192, FASTUTIL_INT_2_OBJECT_HASH_MAP));
                    continue;
                }
            }
            if (node.getOpcode() == 184 && node instanceof MethodInsnNode) {
                MethodInsnNode methodNode2 = (MethodInsnNode)node;
                if (methodNode2.owner.equals(INTEGER) && methodNode2.name.equals("valueOf")) {
                    modified = true;
                    toRemove.add(node);
                    continue;
                }
            }
            if (node.getOpcode() == 185 && node instanceof MethodInsnNode) {
                MethodInsnNode methodNode3 = (MethodInsnNode)node;
                if (methodNode3.owner.equals(JAVA_MAP) && methodNode3.name.equals("get")) {
                    modified = true;
                    methodNode3.setOpcode(182);
                    methodNode3.owner = FASTUTIL_INT_2_OBJECT_HASH_MAP;
                    methodNode3.desc = "(I)Ljava/lang/Object;";
                    methodNode3.itf = false;
                    continue;
                }
            }
            if (node.getOpcode() == 192 && node instanceof TypeInsnNode) {
                TypeInsnNode checkCastNode = (TypeInsnNode)node;
                if (checkCastNode.desc.equals("java/util/List")) {
                    modified = true;
                    checkCastNode.desc = "it/unimi/dsi/fastutil/ints/IntList";
                    continue;
                }
            }
            if (node.getOpcode() == 185 && node instanceof MethodInsnNode) {
                MethodInsnNode methodNode4 = (MethodInsnNode)node;
                if (methodNode4.owner.equals("java/util/Set") && methodNode4.name.equals("addAll")) {
                    modified = true;
                    methodNode4.setOpcode(182);
                    methodNode4.owner = FASTUTIL_INT_OPEN_HASH_SET;
                    methodNode4.desc = "(Lit/unimi/dsi/fastutil/ints/IntCollection;)Z";
                    methodNode4.itf = false;
                    continue;
                }
            }
            if (node.getOpcode() != 185 || !(node instanceof MethodInsnNode)) continue;
            MethodInsnNode methodNode5 = (MethodInsnNode)node;
            if (!methodNode5.owner.equals("java/util/Set") || !methodNode5.name.equals("size")) continue;
            modified = true;
            AbstractInsnNode loadNode = node.getPrevious();
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(182, FASTUTIL_INT_OPEN_HASH_SET, "isEmpty", "()Z", false));
            newInstructions.add((AbstractInsnNode)new JumpInsnNode(153, toIntArrayBeforeReturnLabelNode));
            newInstructions.add((AbstractInsnNode)new FieldInsnNode(178, ORE_DICTIONARY, "EMPTY_INT_ARRAY", "[I"));
            newInstructions.add((AbstractInsnNode)new JumpInsnNode(167, returnLabelNode));
            newInstructions.add((AbstractInsnNode)toIntArrayBeforeReturnLabelNode);
            instructions.insertBefore(loadNode, newInstructions);
            AbstractInsnNode current = node;
            while (current != null && current.getOpcode() != 176) {
                AbstractInsnNode next2 = current.getNext();
                toRemove.add(current);
                current = next2;
            }
            if (current == null || current.getOpcode() != 176) {
                throw new RuntimeException("Unexpected opcode found in Set.size()");
            }
            InsnList insnList = new InsnList();
            insnList.add((AbstractInsnNode)new MethodInsnNode(182, FASTUTIL_INT_OPEN_HASH_SET, "toIntArray", "()[I", false));
            insnList.add((AbstractInsnNode)returnLabelNode);
            instructions.insertBefore(current, insnList);
        }
        for (AbstractInsnNode toRemoveNode : toRemove) {
            instructions.remove(toRemoveNode);
        }
        return modified;
    }

    private boolean overwriteGetOreIDsMethod(MethodNode method) {
        if (!method.name.equals("getOreIDs") || !method.desc.equals("(L" + this.itemStackClass + ";)[I")) {
            return false;
        }
        method.instructions.clear();
        method.localVariables.clear();
        method.tryCatchBlocks.clear();
        InsnList insns = new InsnList();
        LabelNode L0 = new LabelNode(new Label());
        LabelNode L1 = new LabelNode(new Label());
        LabelNode L2 = new LabelNode(new Label());
        LabelNode L3 = new LabelNode(new Label());
        LabelNode L4 = new LabelNode(new Label());
        LabelNode L5 = new LabelNode(new Label());
        LabelNode L6 = new LabelNode(new Label());
        LabelNode L7 = new LabelNode(new Label());
        LabelNode L8 = new LabelNode(new Label());
        LabelNode L9 = new LabelNode(new Label());
        LabelNode L10 = new LabelNode(new Label());
        LabelNode L11 = new LabelNode(new Label());
        LabelNode L12 = new LabelNode(new Label());
        LabelNode L13 = new LabelNode(new Label());
        LabelNode L14 = new LabelNode(new Label());
        insns.add((AbstractInsnNode)L0);
        insns.add((AbstractInsnNode)new LineNumberNode(336, L0));
        insns.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insns.add((AbstractInsnNode)new JumpInsnNode(198, L1));
        insns.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insns.add((AbstractInsnNode)new MethodInsnNode(182, this.itemStackClass, "getItem", "()L" + this.itemClass + ";", false));
        insns.add((AbstractInsnNode)new JumpInsnNode(199, L2));
        insns.add((AbstractInsnNode)L1);
        insns.add((AbstractInsnNode)new FieldInsnNode(178, ORE_DICTIONARY, "EMPTY_INT_ARRAY", "[I"));
        insns.add((AbstractInsnNode)new InsnNode(176));
        insns.add((AbstractInsnNode)L2);
        insns.add((AbstractInsnNode)new LineNumberNode(338, L2));
        insns.add((AbstractInsnNode)new TypeInsnNode(187, FASTUTIL_INT_OPEN_HASH_SET));
        insns.add((AbstractInsnNode)new InsnNode(89));
        insns.add((AbstractInsnNode)new MethodInsnNode(183, FASTUTIL_INT_OPEN_HASH_SET, "<init>", "()V", false));
        insns.add((AbstractInsnNode)new VarInsnNode(58, 1));
        insns.add((AbstractInsnNode)L3);
        insns.add((AbstractInsnNode)new LineNumberNode(343, L3));
        insns.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insns.add((AbstractInsnNode)new MethodInsnNode(182, this.itemStackClass, "getItem", "()L" + this.itemClass + ";", false));
        insns.add((AbstractInsnNode)new FieldInsnNode(180, this.itemClass, "delegate", "Lcpw/mods/fml/common/registry/RegistryDelegate;"));
        insns.add((AbstractInsnNode)new MethodInsnNode(185, "cpw/mods/fml/common/registry/RegistryDelegate", "name", "()Ljava/lang/String;", true));
        insns.add((AbstractInsnNode)new VarInsnNode(58, 2));
        insns.add((AbstractInsnNode)L4);
        insns.add((AbstractInsnNode)new LineNumberNode(345, L4));
        insns.add((AbstractInsnNode)new VarInsnNode(25, 2));
        insns.add((AbstractInsnNode)new JumpInsnNode(199, L5));
        insns.add((AbstractInsnNode)L6);
        insns.add((AbstractInsnNode)new LineNumberNode(347, L6));
        insns.add((AbstractInsnNode)new FieldInsnNode(178, "org/apache/logging/log4j/Level", "DEBUG", "Lorg/apache/logging/log4j/Level;"));
        insns.add((AbstractInsnNode)new LdcInsnNode((Object)"Attempted to find the oreIDs for an unregistered object (%s). This won't work very well."));
        insns.add((AbstractInsnNode)new InsnNode(4));
        insns.add((AbstractInsnNode)new TypeInsnNode(189, "java/lang/Object"));
        insns.add((AbstractInsnNode)new InsnNode(89));
        insns.add((AbstractInsnNode)new InsnNode(3));
        insns.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insns.add((AbstractInsnNode)new InsnNode(83));
        insns.add((AbstractInsnNode)new MethodInsnNode(184, "cpw/mods/fml/common/FMLLog", "log", "(Lorg/apache/logging/log4j/Level;Ljava/lang/String;[Ljava/lang/Object;)V", false));
        insns.add((AbstractInsnNode)new FieldInsnNode(178, ORE_DICTIONARY, "EMPTY_INT_ARRAY", "[I"));
        insns.add((AbstractInsnNode)new InsnNode(176));
        insns.add((AbstractInsnNode)L5);
        insns.add((AbstractInsnNode)new LineNumberNode(352, L5));
        insns.add((AbstractInsnNode)new MethodInsnNode(184, "cpw/mods/fml/common/registry/GameData", "getItemRegistry", "()Lcpw/mods/fml/common/registry/FMLControlledNamespacedRegistry;", false));
        insns.add((AbstractInsnNode)new VarInsnNode(25, 2));
        insns.add((AbstractInsnNode)new MethodInsnNode(182, "cpw/mods/fml/common/registry/FMLControlledNamespacedRegistry", "getId", "(Ljava/lang/String;)I", false));
        insns.add((AbstractInsnNode)new VarInsnNode(54, 3));
        insns.add((AbstractInsnNode)L7);
        insns.add((AbstractInsnNode)new LineNumberNode(354, L7));
        insns.add((AbstractInsnNode)new FieldInsnNode(178, ORE_DICTIONARY, "stackToId", "Ljava/util/Map;"));
        insns.add((AbstractInsnNode)new TypeInsnNode(192, FASTUTIL_INT_2_OBJECT_HASH_MAP));
        insns.add((AbstractInsnNode)new VarInsnNode(21, 3));
        insns.add((AbstractInsnNode)new MethodInsnNode(182, FASTUTIL_INT_2_OBJECT_HASH_MAP, "get", "(I)Ljava/lang/Object;", false));
        insns.add((AbstractInsnNode)new TypeInsnNode(192, "it/unimi/dsi/fastutil/ints/IntList"));
        insns.add((AbstractInsnNode)new VarInsnNode(58, 4));
        insns.add((AbstractInsnNode)L8);
        insns.add((AbstractInsnNode)new LineNumberNode(355, L8));
        insns.add((AbstractInsnNode)new VarInsnNode(25, 4));
        insns.add((AbstractInsnNode)new JumpInsnNode(198, L9));
        insns.add((AbstractInsnNode)new VarInsnNode(25, 1));
        insns.add((AbstractInsnNode)new VarInsnNode(25, 4));
        insns.add((AbstractInsnNode)new MethodInsnNode(182, FASTUTIL_INT_OPEN_HASH_SET, "addAll", "(Lit/unimi/dsi/fastutil/ints/IntCollection;)Z", false));
        insns.add((AbstractInsnNode)new InsnNode(87));
        insns.add((AbstractInsnNode)L9);
        insns.add((AbstractInsnNode)new LineNumberNode(356, L9));
        insns.add((AbstractInsnNode)new FieldInsnNode(178, ORE_DICTIONARY, "stackToId", "Ljava/util/Map;"));
        insns.add((AbstractInsnNode)new TypeInsnNode(192, FASTUTIL_INT_2_OBJECT_HASH_MAP));
        insns.add((AbstractInsnNode)new VarInsnNode(21, 3));
        insns.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insns.add((AbstractInsnNode)new MethodInsnNode(182, this.itemStackClass, "getItemDamage", "()I", false));
        insns.add((AbstractInsnNode)new InsnNode(4));
        insns.add((AbstractInsnNode)new InsnNode(96));
        insns.add((AbstractInsnNode)new IntInsnNode(16, 16));
        insns.add((AbstractInsnNode)new InsnNode(120));
        insns.add((AbstractInsnNode)new InsnNode(128));
        insns.add((AbstractInsnNode)new MethodInsnNode(182, FASTUTIL_INT_2_OBJECT_HASH_MAP, "get", "(I)Ljava/lang/Object;", false));
        insns.add((AbstractInsnNode)new TypeInsnNode(192, "it/unimi/dsi/fastutil/ints/IntList"));
        insns.add((AbstractInsnNode)new VarInsnNode(58, 4));
        insns.add((AbstractInsnNode)L10);
        insns.add((AbstractInsnNode)new LineNumberNode(357, L10));
        insns.add((AbstractInsnNode)new VarInsnNode(25, 4));
        insns.add((AbstractInsnNode)new JumpInsnNode(198, L11));
        insns.add((AbstractInsnNode)new VarInsnNode(25, 1));
        insns.add((AbstractInsnNode)new VarInsnNode(25, 4));
        insns.add((AbstractInsnNode)new MethodInsnNode(182, FASTUTIL_INT_OPEN_HASH_SET, "addAll", "(Lit/unimi/dsi/fastutil/ints/IntCollection;)Z", false));
        insns.add((AbstractInsnNode)new InsnNode(87));
        insns.add((AbstractInsnNode)L11);
        insns.add((AbstractInsnNode)new LineNumberNode(359, L11));
        insns.add((AbstractInsnNode)new VarInsnNode(25, 1));
        insns.add((AbstractInsnNode)new MethodInsnNode(182, FASTUTIL_INT_OPEN_HASH_SET, "isEmpty", "()Z", false));
        insns.add((AbstractInsnNode)new JumpInsnNode(153, L12));
        insns.add((AbstractInsnNode)new FieldInsnNode(178, ORE_DICTIONARY, "EMPTY_INT_ARRAY", "[I"));
        insns.add((AbstractInsnNode)new JumpInsnNode(167, L13));
        insns.add((AbstractInsnNode)L12);
        insns.add((AbstractInsnNode)new VarInsnNode(25, 1));
        insns.add((AbstractInsnNode)new MethodInsnNode(182, FASTUTIL_INT_OPEN_HASH_SET, "toIntArray", "()[I", false));
        insns.add((AbstractInsnNode)L13);
        insns.add((AbstractInsnNode)new InsnNode(176));
        insns.add((AbstractInsnNode)L14);
        method.localVariables.add(new LocalVariableNode("x", "I", null, L0, L0, 7));
        method.localVariables.add(new LocalVariableNode("stack", "L" + this.itemStackClass + ";", null, L0, L14, 0));
        method.localVariables.add(new LocalVariableNode("set", "Ljava/util/Set;", "Ljava/util/Set<Ljava/lang/Integer;>;", L3, L14, 1));
        method.localVariables.add(new LocalVariableNode("registryName", "Ljava/lang/String;", null, L4, L14, 2));
        method.localVariables.add(new LocalVariableNode("id", "I", null, L7, L14, 3));
        method.localVariables.add(new LocalVariableNode("ids", "Ljava/util/List;", "Ljava/util/List<Ljava/lang/Integer;>;", L8, L14, 4));
        method.localVariables.add(new LocalVariableNode("tmp", "[Ljava/lang/Integer;", null, L0, L14, 5));
        method.localVariables.add(new LocalVariableNode("ret", "[I", null, L0, L14, 6));
        method.maxStack = 6;
        method.maxLocals = 8;
        method.instructions = insns;
        return true;
    }

    private boolean transformGetOresIntMethod(MethodNode method) {
        boolean modified = false;
        InsnList instructions = method.instructions;
        for (AbstractInsnNode node : instructions) {
            if (node.getOpcode() == 178 && node instanceof FieldInsnNode) {
                FieldInsnNode fNode = (FieldInsnNode)node;
                if (fNode.owner.equals(ORE_DICTIONARY) && fNode.name.equals("nameToId")) {
                    modified = true;
                    instructions.insert(node, (AbstractInsnNode)new TypeInsnNode(192, FASTUTIL_OBJECT_2_INT_HASH_MAP));
                    continue;
                }
            }
            if (node.getOpcode() == 184 && node instanceof MethodInsnNode) {
                MethodInsnNode methodNode = (MethodInsnNode)node;
                if (methodNode.owner.equals(INTEGER) && methodNode.name.equals("valueOf")) {
                    modified = true;
                    instructions.remove(node);
                    continue;
                }
            }
            if (node.getOpcode() != 185 || !(node instanceof MethodInsnNode)) continue;
            MethodInsnNode methodNode = (MethodInsnNode)node;
            if (!methodNode.owner.equals(JAVA_MAP) || !methodNode.name.equals("put")) continue;
            modified = true;
            methodNode.setOpcode(182);
            methodNode.owner = FASTUTIL_OBJECT_2_INT_HASH_MAP;
            methodNode.name = "put";
            methodNode.desc = "(Ljava/lang/Object;I)I";
            methodNode.itf = false;
        }
        return modified;
    }

    private boolean transformRegisterOreImplMethod(MethodNode method) {
        InsnList instructions = method.instructions;
        boolean modified = false;
        for (AbstractInsnNode node : instructions) {
            if (node.getOpcode() == 178 && node instanceof FieldInsnNode) {
                FieldInsnNode fNode = (FieldInsnNode)node;
                if (fNode.owner.equals(ORE_DICTIONARY) && fNode.name.equals("stackToId")) {
                    modified = true;
                    instructions.insert(node, (AbstractInsnNode)new TypeInsnNode(192, FASTUTIL_INT_2_OBJECT_HASH_MAP));
                    continue;
                }
            }
            if (node.getOpcode() == 184 && node instanceof MethodInsnNode) {
                MethodInsnNode methodNode = (MethodInsnNode)node;
                if (methodNode.owner.equals(INTEGER) && methodNode.name.equals("valueOf")) {
                    modified = true;
                    instructions.remove(node);
                    continue;
                }
            }
            if (node.getOpcode() == 185 && node instanceof MethodInsnNode) {
                MethodInsnNode methodNode = (MethodInsnNode)node;
                if (methodNode.owner.equals(JAVA_MAP) && methodNode.name.equals("get")) {
                    AbstractInsnNode next;
                    modified = true;
                    methodNode.setOpcode(182);
                    methodNode.owner = FASTUTIL_INT_2_OBJECT_HASH_MAP;
                    methodNode.desc = "(I)Ljava/lang/Object;";
                    methodNode.itf = false;
                    for (next = node.getNext(); next != null && next.getOpcode() != 192; next = next.getNext()) {
                    }
                    if (next == null || next.getOpcode() != 192 || !(next instanceof TypeInsnNode)) continue;
                    TypeInsnNode checkCastNode = (TypeInsnNode)next;
                    if (!checkCastNode.desc.equals("java/util/List")) continue;
                    checkCastNode.desc = "it/unimi/dsi/fastutil/ints/IntList";
                    continue;
                }
            }
            if (node.getOpcode() == 185 && node instanceof MethodInsnNode) {
                MethodInsnNode methodNode = (MethodInsnNode)node;
                if (methodNode.owner.equals("java/util/List") && methodNode.name.equals("contains")) {
                    modified = true;
                    methodNode.owner = "it/unimi/dsi/fastutil/ints/IntList";
                    methodNode.desc = "(I)Z";
                    continue;
                }
            }
            if (node.getOpcode() == 184 && node instanceof MethodInsnNode) {
                MethodInsnNode methodNode = (MethodInsnNode)node;
                if (methodNode.owner.equals("com/google/common/collect/Lists") && methodNode.name.equals("newArrayList") && methodNode.desc.equals("()Ljava/util/ArrayList;")) {
                    modified = true;
                    instructions.insertBefore(node, (AbstractInsnNode)new TypeInsnNode(187, "it/unimi/dsi/fastutil/ints/IntArrayList"));
                    instructions.insertBefore(node, (AbstractInsnNode)new InsnNode(89));
                    instructions.insertBefore(node, (AbstractInsnNode)new MethodInsnNode(183, "it/unimi/dsi/fastutil/ints/IntArrayList", "<init>", "()V", false));
                    instructions.remove(node);
                    continue;
                }
            }
            if (node.getOpcode() == 185 && node instanceof MethodInsnNode) {
                MethodInsnNode methodNode = (MethodInsnNode)node;
                if (methodNode.owner.equals(JAVA_MAP) && methodNode.name.equals("put")) {
                    modified = true;
                    methodNode.setOpcode(182);
                    methodNode.owner = FASTUTIL_INT_2_OBJECT_HASH_MAP;
                    methodNode.desc = "(ILjava/lang/Object;)Ljava/lang/Object;";
                    methodNode.itf = false;
                    continue;
                }
            }
            if (node.getOpcode() != 185 || !(node instanceof MethodInsnNode)) continue;
            MethodInsnNode methodNode = (MethodInsnNode)node;
            if (!methodNode.owner.equals("java/util/List") || !methodNode.name.equals("add")) continue;
            modified = true;
            methodNode.owner = "it/unimi/dsi/fastutil/ints/IntList";
            methodNode.desc = "(I)Z";
        }
        return modified;
    }

    private boolean transformRebakeMapMethod(MethodNode method) {
        InsnList instructions = method.instructions;
        boolean modified = false;
        boolean inIdToStackContext = false;
        for (AbstractInsnNode node : instructions) {
            if (node.getOpcode() == 178 && node instanceof FieldInsnNode) {
                FieldInsnNode fieldNode = (FieldInsnNode)node;
                if (fieldNode.owner.equals(ORE_DICTIONARY) && fieldNode.name.equals("stackToId")) {
                    inIdToStackContext = false;
                } else if (fieldNode.owner.equals(ORE_DICTIONARY) && fieldNode.name.equals("idToStack")) {
                    inIdToStackContext = true;
                }
            }
            if (node.getOpcode() == 184 && node instanceof MethodInsnNode) {
                MethodInsnNode methodNode = (MethodInsnNode)node;
                if (methodNode.owner.equals("com/google/common/collect/Lists") && methodNode.name.equals("newArrayList") && methodNode.desc.equals("()Ljava/util/ArrayList;")) {
                    if (inIdToStackContext) continue;
                    modified = true;
                    instructions.insertBefore(node, (AbstractInsnNode)new TypeInsnNode(187, "it/unimi/dsi/fastutil/ints/IntArrayList"));
                    instructions.insertBefore(node, (AbstractInsnNode)new InsnNode(89));
                    instructions.insertBefore(node, (AbstractInsnNode)new MethodInsnNode(183, "it/unimi/dsi/fastutil/ints/IntArrayList", "<init>", "()V", false));
                    instructions.remove(node);
                    continue;
                }
            }
            if (node.getOpcode() == 185 && node instanceof MethodInsnNode) {
                MethodInsnNode methodNode = (MethodInsnNode)node;
                if (methodNode.owner.equals("java/util/List") && methodNode.name.equals("add") && !inIdToStackContext) {
                    modified = true;
                    methodNode.owner = "it/unimi/dsi/fastutil/ints/IntList";
                    methodNode.desc = "(I)Z";
                    continue;
                }
            }
            if (node.getOpcode() == 192 && node instanceof TypeInsnNode) {
                TypeInsnNode checkCastNode = (TypeInsnNode)node;
                if (checkCastNode.desc.equals("java/util/List") && !inIdToStackContext) {
                    modified = true;
                    checkCastNode.desc = "it/unimi/dsi/fastutil/ints/IntList";
                    continue;
                }
            }
            if (node.getOpcode() == 185 && node instanceof MethodInsnNode) {
                MethodInsnNode methodNode = (MethodInsnNode)node;
                if (methodNode.owner.equals("java/util/List") && methodNode.name.equals("contains")) {
                    modified = true;
                    methodNode.owner = "it/unimi/dsi/fastutil/ints/IntList";
                    methodNode.desc = "(I)Z";
                    continue;
                }
            }
            if (node.getOpcode() == 184 && node instanceof MethodInsnNode) {
                MethodInsnNode methodNode = (MethodInsnNode)node;
                if (methodNode.owner.equals(INTEGER) && methodNode.name.equals("valueOf")) {
                    modified = true;
                    instructions.remove(node);
                    continue;
                }
            }
            if (node.getOpcode() == 182 && node instanceof MethodInsnNode) {
                MethodInsnNode methodNode = (MethodInsnNode)node;
                if (methodNode.owner.equals(INTEGER) && methodNode.name.equals("intValue")) {
                    modified = true;
                    instructions.remove(node);
                    continue;
                }
            }
            if (node.getOpcode() == 192 && node instanceof TypeInsnNode) {
                TypeInsnNode checkCastNode = (TypeInsnNode)node;
                if (checkCastNode.desc.equals(INTEGER)) {
                    modified = true;
                    instructions.remove(node);
                    continue;
                }
            }
            if (node.getOpcode() == 178 && node instanceof FieldInsnNode) {
                FieldInsnNode fNode = (FieldInsnNode)node;
                if (fNode.owner.equals(ORE_DICTIONARY) && fNode.name.equals("stackToId")) {
                    modified = true;
                    instructions.insert(node, (AbstractInsnNode)new TypeInsnNode(192, FASTUTIL_INT_2_OBJECT_HASH_MAP));
                    continue;
                }
            }
            if (node.getOpcode() == 185 && node instanceof MethodInsnNode) {
                MethodInsnNode methodNode = (MethodInsnNode)node;
                if (methodNode.owner.equals(JAVA_MAP) && methodNode.name.equals("put")) {
                    modified = true;
                    methodNode.setOpcode(182);
                    methodNode.owner = FASTUTIL_INT_2_OBJECT_HASH_MAP;
                    methodNode.desc = "(ILjava/lang/Object;)Ljava/lang/Object;";
                    methodNode.itf = false;
                    continue;
                }
            }
            if (node.getOpcode() != 185 || !(node instanceof MethodInsnNode)) continue;
            MethodInsnNode methodNode = (MethodInsnNode)node;
            if (!methodNode.owner.equals(JAVA_MAP) || !methodNode.name.equals("get")) continue;
            modified = true;
            methodNode.setOpcode(182);
            methodNode.owner = FASTUTIL_INT_2_OBJECT_HASH_MAP;
            methodNode.desc = "(I)Ljava/lang/Object;";
            methodNode.itf = false;
        }
        return modified;
    }
}

