/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.core.rfb.hooks;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class ForgeConfigurationHook {
    private static final String INT_MIN_STRING = Integer.toString(Integer.MIN_VALUE);
    private static final String INT_MAX_STRING = Integer.toString(Integer.MAX_VALUE);
    private static final String DOUBLE_MAX_STRING = Double.toString(Double.MAX_VALUE);
    private static final String DOUBLE_NEG_MAX_STRING = Double.toString(-1.7976931348623157E308);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static String intToCachedString(int value) {
        String string;
        switch (value) {
            case -2147483648: {
                string = INT_MIN_STRING;
                break;
            }
            case 0x7FFFFFFF: {
                string = INT_MAX_STRING;
                break;
            }
            case 0: {
                string = "0";
                break;
            }
            case 1: {
                string = "1";
                break;
            }
            case 2: {
                string = "2";
                break;
            }
            case 3: {
                string = "3";
                break;
            }
            case 4: {
                string = "4";
                break;
            }
            case 5: {
                string = "5";
                break;
            }
            case 10: {
                string = "10";
                break;
            }
            case 100: {
                string = "100";
                break;
            }
            default: {
                string = String.valueOf(value).intern();
            }
        }
        return string;
    }

    public static String doubleToCachedString(double value) {
        if (value == Double.MAX_VALUE) {
            return DOUBLE_MAX_STRING;
        }
        if (value == -1.7976931348623157E308) {
            return DOUBLE_NEG_MAX_STRING;
        }
        return String.valueOf(value).intern();
    }

    public static String[] internArray(String[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_STRING_ARRAY;
        }
        for (int i = 0; i < array.length; ++i) {
            array[i] = array[i] == null ? null : array[i].intern();
        }
        return array;
    }

    public static String[] emptyStringArray() {
        return EMPTY_STRING_ARRAY;
    }

    public static <V> Collection<V> keySortedMapValues(Map<String, V> map) {
        TreeMap<String, V> sortedMap = new TreeMap<String, V>(map);
        return sortedMap.values();
    }
}

