/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.util;

import com.mitchej123.hodgepodge.Common;
import com.mitchej123.hodgepodge.config.FixesConfig;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class TravellersGear {
    private static NBTTagCompound cachedRoot;
    private static NBTTagCompound cachedData;
    private static NBTTagList cachedPlayerList;
    private static File dataFile;
    private static boolean dirty;

    public static void returnTGItems(EntityPlayer player) {
        if (cachedPlayerList == null) {
            Common.log.info("[TG Recovery] No player data loaded.");
            return;
        }
        UUID playerUUID = player.func_110124_au();
        boolean found = false;
        NBTTagList updatedList = new NBTTagList();
        for (int i = 0; i < cachedPlayerList.func_74745_c(); ++i) {
            NBTTagCompound playerTag = cachedPlayerList.func_150305_b(i);
            UUID tagUUID = new UUID(playerTag.func_74763_f("UUIDMost"), playerTag.func_74763_f("UUIDLeast"));
            if (playerUUID.equals(tagUUID)) {
                TravellersGear.restoreInventory(player, playerTag);
                found = true;
                continue;
            }
            updatedList.func_74742_a((NBTBase)playerTag);
        }
        if (found) {
            cachedPlayerList = updatedList;
            dirty = true;
            TravellersGear.saveIfDirty();
        }
    }

    private static void restoreInventory(EntityPlayer player, NBTTagCompound playerTag) {
        if (!playerTag.func_150297_b("Inventory", 9)) {
            return;
        }
        NBTTagList inventory = playerTag.func_150295_c("Inventory", 10);
        for (int j2 = 0; j2 < inventory.func_74745_c(); ++j2) {
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)inventory.func_150305_b(j2));
            if (stack == null || player.field_71071_by.func_70441_a(stack)) continue;
            player.func_70099_a(stack, 0.0f);
        }
        player.field_71069_bz.func_75142_b();
        Common.log.info("[TG Recovery] Restored items to {}.", new Object[]{player.func_70005_c_()});
    }

    public static void initialize() {
        WorldServer world = DimensionManager.getWorld((int)0);
        dataFile = new File(world.func_72860_G().func_75765_b(), "data/TG-SaveData.dat");
        if (!dataFile.exists() || dataFile.length() == 0L) {
            Common.log.info("[TG Recovery] No TG-SaveData.dat file found.");
            TravellersGear.clearCache();
            return;
        }
        try {
            boolean isCompressed;
            try (DataInputStream din = new DataInputStream(new FileInputStream(dataFile));){
                int b0 = din.readUnsignedByte();
                int b1 = din.readUnsignedByte();
                isCompressed = b0 == 31 && b1 == 139;
            }
            if (isCompressed) {
                try (FileInputStream in = new FileInputStream(dataFile);){
                    cachedRoot = CompressedStreamTools.func_74796_a((InputStream)in);
                    Common.log.info("[TG Recovery] Loaded compressed TG-SaveData.dat");
                }
            } else {
                cachedRoot = CompressedStreamTools.func_74797_a((File)dataFile);
                Common.log.warn("[TG Recovery] Loaded uncompressed TG-SaveData.dat (fallback)");
            }
            cachedData = cachedRoot.func_74775_l("data");
            cachedPlayerList = cachedData.func_150295_c("playerList", 10);
            Common.log.info("[TG Recovery] Loaded TG-SaveData.dat with {} entries.", new Object[]{cachedPlayerList.func_74745_c()});
        }
        catch (Exception e) {
            Common.log.error("[TG Recovery] Failed to load TG-SaveData.dat.", (Throwable)e);
            TravellersGear.clearCache();
        }
    }

    private static void saveIfDirty() {
        if (!dirty || dataFile == null) {
            return;
        }
        if (cachedPlayerList.func_74745_c() == 0) {
            TravellersGear.deleteFile();
            return;
        }
        try (FileOutputStream out = new FileOutputStream(dataFile);){
            CompressedStreamTools.func_74799_a((NBTTagCompound)cachedRoot, (OutputStream)out);
            dirty = false;
            Common.log.info("[TG Recovery] Saved updated TG-SaveData.dat.");
        }
        catch (IOException e) {
            Common.log.error("[TG Recovery] Failed to save TG-SaveData.dat.", (Throwable)e);
        }
    }

    private static void deleteFile() {
        if (dataFile.delete()) {
            Common.log.info("[TG Recovery] TG-SaveData.dat is empty, file deleted.");
        } else {
            Common.log.warn("[TG Recovery] Failed to delete empty TG-SaveData.dat.");
        }
        TravellersGear.clearCache();
        if (FMLCommonHandler.instance().getSide().isServer()) {
            FixesConfig.returnTravellersGearItems = false;
            Common.log.info("[TG Recovery] Automatically disabled recovery config on server with no TG-SaveData.dat.");
        }
    }

    private static void clearCache() {
        cachedRoot = new NBTTagCompound();
        cachedData = new NBTTagCompound();
        cachedPlayerList = new NBTTagList();
        dirty = false;
    }
}

