/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.core.fml.transformers.fml;

import com.mitchej123.hodgepodge.core.HodgepodgeCore;
import com.mitchej123.hodgepodge.core.shared.HodgepodgeClassDump;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class FMLIndexedMessageToMessageCodecTransformer
implements IClassTransformer,
Opcodes {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if ("cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec".equals(transformedName)) {
            byte[] transformedBytes = FMLIndexedMessageToMessageCodecTransformer.transformBytes(basicClass);
            HodgepodgeClassDump.dumpClass(transformedName, basicClass, transformedBytes, this);
            return transformedBytes;
        }
        return basicClass;
    }

    private static byte[] transformBytes(byte[] basicClass) {
        Logger LOGGER = LogManager.getLogger((String)"FMLIndexedMessageToMessageCodecTransformer");
        HodgepodgeCore.logASM(LOGGER, "TRANSFORMING cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec");
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        if (cn.methods != null) {
            for (MethodNode m : cn.methods) {
                if (!"encode".equals(m.name)) continue;
                HodgepodgeCore.logASM(LOGGER, "Adding dispatcher safety");
                int ctxIdx = 1;
                int proxyIdx = 7;
                if (m.localVariables != null) {
                    for (LocalVariableNode local : m.localVariables) {
                        if ("ctx".equals(local.name)) {
                            ctxIdx = local.index;
                            continue;
                        }
                        if (!"proxy".equals(local.name)) continue;
                        proxyIdx = local.index;
                    }
                }
                for (AbstractInsnNode insnNode : m.instructions.toArray()) {
                    if (insnNode.getOpcode() != 177) continue;
                    InsnList list = new InsnList();
                    list.add((AbstractInsnNode)new VarInsnNode(25, ctxIdx));
                    list.add((AbstractInsnNode)new VarInsnNode(25, proxyIdx));
                    list.add((AbstractInsnNode)new MethodInsnNode(184, "com/mitchej123/hodgepodge/core/fml/hooks/fml/FMLIndexedMessageToMessageCodecHook", "addMissingDispatcher", "(Lio/netty/channel/ChannelHandlerContext;Lcpw/mods/fml/common/network/internal/FMLProxyPacket;)V", false));
                    m.instructions.insertBefore(insnNode, list);
                }
            }
        }
        ClassWriter cw = new ClassWriter(cr, 0);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }
}

