/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.core.fml.transformers.thermos;

import com.mitchej123.hodgepodge.config.ASMConfig;
import com.mitchej123.hodgepodge.core.HodgepodgeCore;
import com.mitchej123.hodgepodge.core.shared.HodgepodgeClassDump;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ThermosFurnaceSledgeHammer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if (ASMConfig.thermosCraftServerClass.equals(transformedName)) {
            byte[] transformedBytes = ThermosFurnaceSledgeHammer.transformBytes(basicClass);
            HodgepodgeClassDump.dumpClass(transformedName, basicClass, transformedBytes, this);
            return transformedBytes;
        }
        return basicClass;
    }

    private static byte[] transformBytes(byte[] basicClass) {
        Logger LOGGER = LogManager.getLogger((String)"ThermosFurnaceSledgeHammer");
        HodgepodgeCore.logASM(LOGGER, "Patching Thermos or derivative to not break our furnace fix");
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode(327680);
        cr.accept((ClassVisitor)cn, 0);
        for (MethodNode m : cn.methods) {
            if (!"resetRecipes".equals(m.name)) continue;
            HodgepodgeCore.logASM(LOGGER, "Taking a sledgehammer to CraftServer.resetRecipes()");
            InsnList insnList = new InsnList();
            insnList.add((AbstractInsnNode)new InsnNode(177));
            m.instructions = insnList;
            m.maxStack = 0;
        }
        ClassWriter cw = new ClassWriter(0);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }
}

