/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.util;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;

public class PooledGzipInputStream
extends InflaterInputStream {
    private static final ThreadLocal<Inflater> INFLATER_POOL = ThreadLocal.withInitial(() -> new Inflater(true));

    private PooledGzipInputStream(InputStream in, Inflater inf) throws IOException {
        super(in, inf, 512);
        this.readHeader();
    }

    public static PooledGzipInputStream create(byte[] data) throws IOException {
        Inflater inflater = INFLATER_POOL.get();
        inflater.reset();
        return new PooledGzipInputStream(new ByteArrayInputStream(data), inflater);
    }

    public static NBTTagCompound readNBT(byte[] data, NBTSizeTracker sizeTracker) throws IOException {
        try (PooledGzipInputStream gzis = PooledGzipInputStream.create(data);){
            NBTTagCompound nBTTagCompound;
            try (DataInputStream dis = new DataInputStream(gzis);){
                nBTTagCompound = CompressedStreamTools.func_152456_a((DataInput)dis, (NBTSizeTracker)sizeTracker);
            }
            return nBTTagCompound;
        }
    }

    @Override
    public void close() throws IOException {
        this.inf.reset();
        this.in.close();
    }

    private void readHeader() throws IOException {
        if (this.readUShort() != 35615) {
            throw new ZipException("Not in GZIP format");
        }
        if (this.readUByte() != 8) {
            throw new ZipException("Unsupported compression method");
        }
        int flg = this.readUByte();
        this.skipBytes(6);
        if ((flg & 4) != 0) {
            this.skipBytes(this.readUShort());
        }
        if ((flg & 8) != 0) {
            while (this.readUByte() != 0) {
            }
        }
        if ((flg & 0x10) != 0) {
            while (this.readUByte() != 0) {
            }
        }
        if ((flg & 2) != 0) {
            this.skipBytes(2);
        }
    }

    private int readUByte() throws IOException {
        int b2 = this.in.read();
        if (b2 == -1) {
            throw new EOFException();
        }
        return b2;
    }

    private int readUShort() throws IOException {
        int b1 = this.readUByte();
        int b2 = this.readUByte();
        return b2 << 8 | b1;
    }

    private void skipBytes(int n) throws IOException {
        while (n-- > 0) {
            if (this.in.read() != -1) continue;
            throw new EOFException();
        }
    }
}

