/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class PooledGzipOutputStream
extends DeflaterOutputStream {
    private static final ThreadLocal<Deflater> DEFLATER_POOL = ThreadLocal.withInitial(() -> new Deflater(-1, true));
    private static final byte[] GZIP_HEADER = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0};
    private final CRC32 crc = new CRC32();
    private int size;

    private PooledGzipOutputStream(ByteArrayOutputStream out, Deflater deflater) throws IOException {
        super(out, deflater, 512, true);
        out.write(GZIP_HEADER);
    }

    public static byte[] compressNBT(NBTTagCompound nbt) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(256);
        Deflater deflater = DEFLATER_POOL.get();
        deflater.reset();
        try (PooledGzipOutputStream gzos = new PooledGzipOutputStream(baos, deflater);
             DataOutputStream dos = new DataOutputStream(gzos);){
            CompressedStreamTools.func_150663_a((NBTBase)nbt, (DataOutput)dos);
        }
        return baos.toByteArray();
    }

    @Override
    public void write(int b2) throws IOException {
        super.write(b2);
        this.crc.update(b2);
        ++this.size;
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        super.write(buf, off, len);
        this.crc.update(buf, off, len);
        this.size += len;
    }

    @Override
    public void close() throws IOException {
        this.finish();
        this.writeTrailer();
        this.out.close();
        this.def.reset();
    }

    private void writeTrailer() throws IOException {
        int crcVal = (int)this.crc.getValue();
        this.out.write(crcVal & 0xFF);
        this.out.write(crcVal >> 8 & 0xFF);
        this.out.write(crcVal >> 16 & 0xFF);
        this.out.write(crcVal >> 24 & 0xFF);
        this.out.write(this.size & 0xFF);
        this.out.write(this.size >> 8 & 0xFF);
        this.out.write(this.size >> 16 & 0xFF);
        this.out.write(this.size >> 24 & 0xFF);
    }
}

