/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy.client.gui;

import com.sinthoras.hydroenergy.HE;
import com.sinthoras.hydroenergy.client.HEClient;
import com.sinthoras.hydroenergy.client.HEDam;
import com.sinthoras.hydroenergy.client.gui.HEPopupLimitGui;
import com.sinthoras.hydroenergy.client.gui.widgets.HEWidgetModes;
import com.sinthoras.hydroenergy.network.container.HEHydroDamConfigContainer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class HEHydroDamConfigGuiContainer
extends GuiContainer {
    public static final ResourceLocation backgroundTextureLocation = new ResourceLocation("hydroenergy", HE.damBackgroundLocation);
    private HEDam dam;
    private HEWidgetModes widgetModes;
    private GuiButton changeWest;
    private GuiButton changeEast;
    private GuiButton changeDown;
    private GuiButton changeUp;
    private GuiButton changeNorth;
    private GuiButton changeSouth;
    private HEPopupLimitGui[] limitGuis = new HEPopupLimitGui[6];
    private int centerX = 0;
    private int centerY = 0;
    private static final Color lineGrey = new Color(155, 155, 155);
    private static final Color textGrey = new Color(104, 104, 104);

    public HEHydroDamConfigGuiContainer(HEHydroDamConfigContainer hydroDamConfigContainer) {
        super((Container)hydroDamConfigContainer);
        this.field_146999_f = 256;
        this.field_147000_g = 176;
        this.dam = HEClient.getDam(hydroDamConfigContainer.getWaterId());
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.centerX = this.field_147003_i + this.field_146999_f / 2;
        this.centerY = this.field_147009_r + this.field_147000_g / 2;
        int popupLeft = this.centerX - 84;
        int popupTop = this.centerY - 70;
        int id = 0;
        int pixelX = this.field_147003_i + 10;
        int pixelY = this.field_147009_r + 32;
        int width = 42;
        int height = 20;
        this.changeWest = new GuiButton(id, pixelX, pixelY, width, height, "Change");
        this.field_146292_n.add(this.changeWest);
        this.limitGuis[0] = new HEPopupLimitGui("Western limit (-X)", popupLeft, popupTop, this.dam.getLimitWest());
        this.changeDown = new GuiButton(id, pixelX, pixelY += 30, width, height, "Change");
        this.field_146292_n.add(this.changeDown);
        this.limitGuis[1] = new HEPopupLimitGui("Lower limit (-Y)", popupLeft, popupTop, this.dam.getLimitDown());
        this.changeNorth = new GuiButton(id, pixelX, pixelY += 30, width, height, "Change");
        this.field_146292_n.add(this.changeNorth);
        this.limitGuis[2] = new HEPopupLimitGui("Northern limit (-Z)", popupLeft, popupTop, this.dam.getLimitNorth());
        pixelX = this.field_147003_i + this.field_146999_f - width - 10;
        pixelY = this.field_147009_r + 32;
        this.changeEast = new GuiButton(id, pixelX, pixelY, width, height, "Change");
        this.field_146292_n.add(this.changeEast);
        this.limitGuis[3] = new HEPopupLimitGui("Eastern limit (+X)", popupLeft, popupTop, this.dam.getLimitEast());
        this.changeUp = new GuiButton(id, pixelX, pixelY += 30, width, height, "Change");
        this.field_146292_n.add(this.changeUp);
        this.limitGuis[4] = new HEPopupLimitGui("Upper limit (+Y)", popupLeft, popupTop, this.dam.getLimitUp());
        this.changeSouth = new GuiButton(id, pixelX, pixelY += 30, width, height, "Change");
        this.field_146292_n.add(this.changeSouth);
        this.limitGuis[5] = new HEPopupLimitGui("Southern limit (+Z)", popupLeft, popupTop, this.dam.getLimitSouth());
        this.widgetModes = new HEWidgetModes(this.dam, this.field_147003_i + this.field_146999_f - 75, this.field_147009_r + 5);
        this.widgetModes.init(this.field_146292_n);
        for (HEPopupLimitGui limitGui : this.limitGuis) {
            limitGui.init(0, this.field_146292_n);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button == this.changeWest) {
            this.widgetModes.setEnabled(false);
            this.limitGuis[0].show();
        } else if (button == this.changeDown) {
            this.widgetModes.setEnabled(false);
            this.limitGuis[1].show();
        } else if (button == this.changeNorth) {
            this.widgetModes.setEnabled(false);
            this.limitGuis[2].show();
        } else if (button == this.changeEast) {
            this.widgetModes.setEnabled(false);
            this.limitGuis[3].show();
        } else if (button == this.changeUp) {
            this.widgetModes.setEnabled(false);
            this.limitGuis[4].show();
        } else if (button == this.changeSouth) {
            this.widgetModes.setEnabled(false);
            this.limitGuis[5].show();
        }
        for (HEPopupLimitGui limitGui : this.limitGuis) {
            limitGui.actionPerformed(button);
        }
        this.widgetModes.actionPerformed(button);
    }

    private void updateValues() {
        if (this.limitGuis[0].getValueChangedAndReset()) {
            this.dam.setLimitWest(this.limitGuis[0].getValue());
            this.dam.applyChanges();
        }
        if (this.limitGuis[1].getValueChangedAndReset()) {
            this.dam.setLimitDown(this.limitGuis[1].getValue());
            this.dam.applyChanges();
        }
        if (this.limitGuis[2].getValueChangedAndReset()) {
            this.dam.setLimitNorth(this.limitGuis[2].getValue());
            this.dam.applyChanges();
        }
        if (this.limitGuis[3].getValueChangedAndReset()) {
            this.dam.setLimitEast(this.limitGuis[3].getValue());
            this.dam.applyChanges();
        }
        if (this.limitGuis[4].getValueChangedAndReset()) {
            this.dam.setLimitUp(this.limitGuis[4].getValue());
            this.dam.applyChanges();
        }
        if (this.limitGuis[5].getValueChangedAndReset()) {
            this.dam.setLimitSouth(this.limitGuis[5].getValue());
            this.dam.applyChanges();
        }
        this.limitGuis[0].updateOriginalValue(this.dam.getLimitWest());
        this.limitGuis[1].updateOriginalValue(this.dam.getLimitDown());
        this.limitGuis[2].updateOriginalValue(this.dam.getLimitNorth());
        this.limitGuis[3].updateOriginalValue(this.dam.getLimitEast());
        this.limitGuis[4].updateOriginalValue(this.dam.getLimitUp());
        this.limitGuis[5].updateOriginalValue(this.dam.getLimitSouth());
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.updateValues();
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fontRenderer = minecraft.field_71466_p;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        minecraft.func_110434_K().func_110577_a(backgroundTextureLocation);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        fontRenderer.func_78276_b("Hydro Dam", this.field_147003_i + 15, this.field_147009_r + 6, Color.BLACK.getRGB());
        fontRenderer.func_78276_b("Water Spread Limits", this.field_147003_i + 15, this.field_147009_r + 18, textGrey.getRGB());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.widgetModes.draw(minecraft, mouseX, mouseY);
        boolean enableElements = !this.isAnyLimitGuiOpen();
        this.widgetModes.setEnabled(enableElements);
        this.changeWest.field_146124_l = enableElements;
        this.changeDown.field_146124_l = enableElements;
        this.changeNorth.field_146124_l = enableElements;
        this.changeEast.field_146124_l = enableElements;
        this.changeUp.field_146124_l = enableElements;
        this.changeSouth.field_146124_l = enableElements;
        if (!enableElements) {
            this.changeWest.field_146125_m = true;
            this.changeDown.field_146125_m = true;
            this.changeNorth.field_146125_m = true;
            this.changeEast.field_146125_m = true;
            this.changeUp.field_146125_m = true;
            this.changeSouth.field_146125_m = true;
            this.changeWest.func_146112_a(minecraft, mouseX, mouseY);
            this.changeDown.func_146112_a(minecraft, mouseX, mouseY);
            this.changeNorth.func_146112_a(minecraft, mouseX, mouseY);
            this.changeEast.func_146112_a(minecraft, mouseX, mouseY);
            this.changeUp.func_146112_a(minecraft, mouseX, mouseY);
            this.changeSouth.func_146112_a(minecraft, mouseX, mouseY);
        }
        this.changeWest.field_146125_m = enableElements;
        this.changeDown.field_146125_m = enableElements;
        this.changeNorth.field_146125_m = enableElements;
        this.changeEast.field_146125_m = enableElements;
        this.changeUp.field_146125_m = enableElements;
        this.changeSouth.field_146125_m = enableElements;
        String limitWest = "" + this.dam.getLimitWest();
        String limitDown = "" + this.dam.getLimitDown();
        String limitNorth = "" + this.dam.getLimitNorth();
        String limitEast = "" + this.dam.getLimitEast();
        String limitUp = "" + this.dam.getLimitUp();
        String limitSouth = "" + this.dam.getLimitSouth();
        int constStringWidthHalf = fontRenderer.func_78256_a(" < X < ") / 2;
        fontRenderer.func_78276_b(" < X < ", this.centerX - constStringWidthHalf, this.field_147009_r + 38, Color.BLACK.getRGB());
        fontRenderer.func_78276_b(" < Y < ", this.centerX - constStringWidthHalf, this.field_147009_r + 68, Color.BLACK.getRGB());
        fontRenderer.func_78276_b(" < Z < ", this.centerX - constStringWidthHalf, this.field_147009_r + 98, Color.BLACK.getRGB());
        int stringWidth = fontRenderer.func_78256_a(limitWest);
        this.func_73730_a(this.field_147003_i + 57, this.centerX - constStringWidthHalf - stringWidth - 5, this.field_147009_r + 41, lineGrey.getRGB());
        fontRenderer.func_78276_b(limitWest, this.centerX - constStringWidthHalf - stringWidth, this.field_147009_r + 38, Color.BLACK.getRGB());
        stringWidth = fontRenderer.func_78256_a(limitDown);
        this.func_73730_a(this.field_147003_i + 57, this.centerX - constStringWidthHalf - stringWidth - 5, this.field_147009_r + 71, lineGrey.getRGB());
        fontRenderer.func_78276_b(limitDown, this.centerX - constStringWidthHalf - stringWidth, this.field_147009_r + 68, Color.BLACK.getRGB());
        stringWidth = fontRenderer.func_78256_a(limitNorth);
        this.func_73730_a(this.field_147003_i + 57, this.centerX - constStringWidthHalf - stringWidth - 5, this.field_147009_r + 101, lineGrey.getRGB());
        fontRenderer.func_78276_b(limitNorth, this.centerX - constStringWidthHalf - stringWidth, this.field_147009_r + 98, Color.BLACK.getRGB());
        stringWidth = fontRenderer.func_78256_a(limitEast);
        this.func_73730_a(this.centerX + constStringWidthHalf + stringWidth + 5, this.field_147003_i + this.field_146999_f - 57, this.field_147009_r + 41, lineGrey.getRGB());
        fontRenderer.func_78276_b(limitEast, this.centerX + constStringWidthHalf, this.field_147009_r + 38, Color.BLACK.getRGB());
        stringWidth = fontRenderer.func_78256_a(limitUp);
        this.func_73730_a(this.centerX + constStringWidthHalf + stringWidth + 5, this.field_147003_i + this.field_146999_f - 57, this.field_147009_r + 71, lineGrey.getRGB());
        fontRenderer.func_78276_b(limitUp, this.centerX + constStringWidthHalf, this.field_147009_r + 68, Color.BLACK.getRGB());
        stringWidth = fontRenderer.func_78256_a(limitSouth);
        this.func_73730_a(this.centerX + constStringWidthHalf + stringWidth + 5, this.field_147003_i + this.field_146999_f - 57, this.field_147009_r + 101, lineGrey.getRGB());
        fontRenderer.func_78276_b(limitSouth, this.centerX + constStringWidthHalf, this.field_147009_r + 98, Color.BLACK.getRGB());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (HEPopupLimitGui limitGui : this.limitGuis) {
            limitGui.draw(mouseX, mouseY);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GL11.glTranslatef((float)(-this.field_147003_i), (float)(-this.field_147009_r), (float)0.0f);
        this.widgetModes.drawTooltip(Minecraft.func_71410_x().field_71466_p, mouseX, mouseY, this.field_146294_l);
        GL11.glTranslatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
    }

    protected void func_73864_a(int pixelX, int pixelY, int mouseButtonId) {
        super.func_73864_a(pixelX, pixelY, mouseButtonId);
        for (HEPopupLimitGui limitGui : this.limitGuis) {
            limitGui.mouseClicked(pixelX, pixelY, mouseButtonId);
        }
    }

    protected void func_73869_a(char c, int keyCode) {
        if (!this.passKeyTypesToLimitGuis(c, keyCode)) {
            super.func_73869_a(c, keyCode);
        }
    }

    private boolean passKeyTypesToLimitGuis(char c, int keyCode) {
        for (HEPopupLimitGui limitGui : this.limitGuis) {
            if (!limitGui.keyTyped(c, keyCode)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnyLimitGuiOpen() {
        for (HEPopupLimitGui limitGui : this.limitGuis) {
            if (!limitGui.visible) continue;
            return true;
        }
        return false;
    }
}

