/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy.client.renderer;

import com.sinthoras.hydroenergy.HEUtil;
import com.sinthoras.hydroenergy.blocks.HEWater;
import com.sinthoras.hydroenergy.blocks.HEWaterStill;
import com.sinthoras.hydroenergy.client.HEClient;
import com.sinthoras.hydroenergy.client.renderer.HETessalator;
import com.sinthoras.hydroenergy.config.HEConfig;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.RenderBlockFluid;
import org.lwjgl.opengl.GLContext;

public class HEWaterRenderer
extends RenderBlockFluid {
    public static HEWaterRenderer instance = new HEWaterRenderer();
    private final int renderID = RenderingRegistry.getNextAvailableRenderId();
    private static final Block[] neighbors = new Block[6];
    private static final boolean[] shouldSidesBeRendered = new boolean[6];

    public float getFluidHeightForRender(IBlockAccess world, int blockX, int blockY, int blockZ, BlockFluidBase block) {
        HEWaterStill water = (HEWaterStill)block;
        float val = water.getWaterLevel() - (float)blockY;
        return HEUtil.clamp(val, 0.0f, 1.0f);
    }

    public int getRenderId() {
        return this.renderID;
    }

    public boolean renderWorldBlock(IBlockAccess world, int blockX, int blockY, int blockZ, Block block, int modelId, RenderBlocks renderer) {
        if (!(block instanceof HEWater)) {
            return false;
        }
        if (GLContext.getCapabilities().OpenGL32 && !HEConfig.useLimitedRendering) {
            HEWaterRenderer.neighbors[0] = world.func_147439_a(blockX - 1, blockY, blockZ);
            HEWaterRenderer.neighbors[1] = world.func_147439_a(blockX + 1, blockY, blockZ);
            HEWaterRenderer.neighbors[2] = world.func_147439_a(blockX, blockY - 1, blockZ);
            HEWaterRenderer.neighbors[3] = world.func_147439_a(blockX, blockY + 1, blockZ);
            HEWaterRenderer.neighbors[4] = world.func_147439_a(blockX, blockY, blockZ - 1);
            HEWaterRenderer.neighbors[5] = world.func_147439_a(blockX, blockY, blockZ + 1);
            HEWaterRenderer.shouldSidesBeRendered[0] = !neighbors[0].func_149662_c() && neighbors[0] != block;
            HEWaterRenderer.shouldSidesBeRendered[1] = !neighbors[1].func_149662_c() && neighbors[1] != block;
            HEWaterRenderer.shouldSidesBeRendered[2] = neighbors[2] != block;
            HEWaterRenderer.shouldSidesBeRendered[3] = !neighbors[3].func_149662_c() && neighbors[3] != block;
            HEWaterRenderer.shouldSidesBeRendered[4] = !neighbors[4].func_149662_c() && neighbors[4] != block;
            HEWaterRenderer.shouldSidesBeRendered[5] = !neighbors[5].func_149662_c() && neighbors[5] != block;
            int worldColorModifier = block.func_149720_d(world, blockX, blockY, blockZ);
            HETessalator.addBlock(blockX, blockY, blockZ, ((HEWater)block).getWaterId(), worldColorModifier, shouldSidesBeRendered);
            return false;
        }
        HEWater water = (HEWater)block;
        float renderedWaterLevel = HEClient.getDam(water.getWaterId()).getWaterLevelForRendering();
        if (renderedWaterLevel < (float)blockY) {
            return false;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        int color = block.func_149720_d(world, blockX, blockY, blockZ);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        Block waterBlock = Block.func_149684_b((String)"water");
        BlockFluidBase theFluid = (BlockFluidBase)block;
        int densityDir = -1;
        int bMeta = world.func_72805_g(blockX, blockY, blockZ);
        boolean renderTop = renderedWaterLevel > (float)blockY && renderedWaterLevel <= (float)(blockY + 1);
        boolean renderBottom = block.func_149646_a(world, blockX, blockY + densityDir, blockZ, 0) && world.func_147439_a(blockX, blockY + densityDir, blockZ) != theFluid;
        boolean[] renderSides = new boolean[]{block.func_149646_a(world, blockX, blockY, blockZ - 1, 2), block.func_149646_a(world, blockX, blockY, blockZ + 1, 3), block.func_149646_a(world, blockX - 1, blockY, blockZ, 4), block.func_149646_a(world, blockX + 1, blockY, blockZ, 5)};
        if (!(renderTop || renderBottom || renderSides[0] || renderSides[1] || renderSides[2] || renderSides[3])) {
            return false;
        }
        boolean rendered = false;
        float flow = this.getFluidHeightForRender(world, blockX, blockY, blockZ, theFluid);
        if (!(flow > 0.0f)) {
            return false;
        }
        double heightNW = flow;
        double heightSW = flow;
        double heightSE = flow;
        double heightNE = flow;
        float LIGHT_Y_NEG = 0.5f;
        float LIGHT_Y_POS = 1.0f;
        float LIGHT_XZ_NEG = 0.8f;
        float LIGHT_XZ_POS = 0.6f;
        double RENDER_OFFSET = 0.001f;
        if (renderer.field_147837_f || renderTop) {
            rendered = true;
            IIcon iconStill = waterBlock.func_149691_a(1, bMeta);
            heightNW -= (double)0.001f;
            heightSW -= (double)0.001f;
            heightSE -= (double)0.001f;
            heightNE -= (double)0.001f;
            double u2 = iconStill.func_94214_a(0.0);
            double v2 = iconStill.func_94207_b(0.0);
            double u1 = u2;
            double v1 = iconStill.func_94207_b(16.0);
            double u4 = iconStill.func_94214_a(16.0);
            double v4 = v1;
            double u3 = u4;
            double v3 = v2;
            tessellator.func_78380_c(block.func_149677_c(world, blockX, blockY, blockZ));
            tessellator.func_78386_a(1.0f * red, 1.0f * green, 1.0f * blue);
            tessellator.func_78374_a((double)blockX, (double)blockY + heightNW, (double)blockZ, u2, v2);
            tessellator.func_78374_a((double)blockX, (double)blockY + heightSW, (double)(blockZ + 1), u1, v1);
            tessellator.func_78374_a((double)(blockX + 1), (double)blockY + heightSE, (double)(blockZ + 1), u4, v4);
            tessellator.func_78374_a((double)(blockX + 1), (double)blockY + heightNE, (double)blockZ, u3, v3);
            tessellator.func_78374_a((double)blockX, (double)blockY + heightNW, (double)blockZ, u2, v2);
            tessellator.func_78374_a((double)(blockX + 1), (double)blockY + heightNE, (double)blockZ, u3, v3);
            tessellator.func_78374_a((double)(blockX + 1), (double)blockY + heightSE, (double)(blockZ + 1), u4, v4);
            tessellator.func_78374_a((double)blockX, (double)blockY + heightSW, (double)(blockZ + 1), u1, v1);
        }
        if (renderer.field_147837_f || renderBottom) {
            rendered = true;
            tessellator.func_78380_c(block.func_149677_c(world, blockX, blockY - 1, blockZ));
            tessellator.func_78386_a(0.5f * red, 0.5f * green, 0.5f * blue);
            renderer.func_147768_a(block, (double)blockX, (double)blockY + (double)0.001f, (double)blockZ, waterBlock.func_149691_a(0, bMeta));
        }
        for (int side = 0; side < 4; ++side) {
            double tz2;
            double tz1;
            double tx2;
            double tx1;
            double ty2;
            double ty1;
            int x2 = blockX;
            int z2 = blockZ;
            switch (side) {
                case 0: {
                    --z2;
                    break;
                }
                case 1: {
                    ++z2;
                    break;
                }
                case 2: {
                    --x2;
                    break;
                }
                case 3: {
                    ++x2;
                }
            }
            IIcon iconFlow = waterBlock.func_149691_a(side + 2, bMeta);
            if (!renderer.field_147837_f && !renderSides[side]) continue;
            rendered = true;
            if (side == 0) {
                ty1 = heightNW;
                ty2 = heightNE;
                tx1 = blockX;
                tx2 = blockX + 1;
                tz1 = (double)blockZ + (double)0.001f;
                tz2 = (double)blockZ + (double)0.001f;
            } else if (side == 1) {
                ty1 = heightSE;
                ty2 = heightSW;
                tx1 = blockX + 1;
                tx2 = blockX;
                tz1 = (double)(blockZ + 1) - (double)0.001f;
                tz2 = (double)(blockZ + 1) - (double)0.001f;
            } else if (side == 2) {
                ty1 = heightSW;
                ty2 = heightNW;
                tx1 = (double)blockX + (double)0.001f;
                tx2 = (double)blockX + (double)0.001f;
                tz1 = blockZ + 1;
                tz2 = blockZ;
            } else {
                ty1 = heightNE;
                ty2 = heightSE;
                tx1 = (double)(blockX + 1) - (double)0.001f;
                tx2 = (double)(blockX + 1) - (double)0.001f;
                tz1 = blockZ;
                tz2 = blockZ + 1;
            }
            float u1Flow = iconFlow.func_94214_a(0.0);
            float u2Flow = iconFlow.func_94214_a(8.0);
            float v1Flow = iconFlow.func_94207_b((1.0 - ty1) * 16.0 * 0.5);
            float v2Flow = iconFlow.func_94207_b((1.0 - ty2) * 16.0 * 0.5);
            float v3Flow = iconFlow.func_94207_b(8.0);
            tessellator.func_78380_c(block.func_149677_c(world, x2, blockY, z2));
            float sideLighting = 1.0f;
            sideLighting = side < 2 ? 0.8f : 0.6f;
            tessellator.func_78386_a(1.0f * sideLighting * red, 1.0f * sideLighting * green, 1.0f * sideLighting * blue);
            tessellator.func_78374_a(tx1, (double)blockY + ty1, tz1, (double)u1Flow, (double)v1Flow);
            tessellator.func_78374_a(tx2, (double)blockY + ty2, tz2, (double)u2Flow, (double)v2Flow);
            tessellator.func_78374_a(tx2, (double)blockY, tz2, (double)u2Flow, (double)v3Flow);
            tessellator.func_78374_a(tx1, (double)blockY, tz1, (double)u1Flow, (double)v3Flow);
            tessellator.func_78374_a(tx1, (double)blockY + ty1, tz1, (double)u1Flow, (double)v1Flow);
            tessellator.func_78374_a(tx1, (double)blockY, tz1, (double)u1Flow, (double)v3Flow);
            tessellator.func_78374_a(tx2, (double)blockY, tz2, (double)u2Flow, (double)v3Flow);
            tessellator.func_78374_a(tx2, (double)blockY + ty2, tz2, (double)u2Flow, (double)v2Flow);
        }
        renderer.field_147855_j = 0.0;
        renderer.field_147857_k = 1.0;
        return rendered;
    }
}

