/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy.network.packet;

import com.sinthoras.hydroenergy.HE;
import com.sinthoras.hydroenergy.client.HEClient;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;

public class HEPacketConfigUpdate
implements IMessage {
    public int waterId;
    public int blockX;
    public int blockY;
    public int blockZ;
    public HE.DamMode mode;
    public int limitWest;
    public int limitDown;
    public int limitNorth;
    public int limitEast;
    public int limitUp;
    public int limitSouth;

    public HEPacketConfigUpdate(int waterId, int blockX, int blockY, int blockZ, HE.DamMode mode, int limitWest, int limitDown, int limitNorth, int limitEast, int limitUp, int limitSouth) {
        this.waterId = waterId;
        this.blockX = blockX;
        this.blockY = blockY;
        this.blockZ = blockZ;
        this.mode = mode;
        this.limitWest = limitWest;
        this.limitDown = limitDown;
        this.limitNorth = limitNorth;
        this.limitEast = limitEast;
        this.limitUp = limitUp;
        this.limitSouth = limitSouth;
    }

    public HEPacketConfigUpdate() {
    }

    public void fromBytes(ByteBuf buf) {
        this.waterId = buf.readInt();
        this.blockX = buf.readInt();
        this.blockY = buf.readInt();
        this.blockZ = buf.readInt();
        this.mode = HE.DamMode.getMode(buf.readInt());
        this.limitWest = buf.readInt();
        this.limitDown = buf.readInt();
        this.limitNorth = buf.readInt();
        this.limitEast = buf.readInt();
        this.limitUp = buf.readInt();
        this.limitSouth = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.waterId);
        buf.writeInt(this.blockX);
        buf.writeInt(this.blockY);
        buf.writeInt(this.blockZ);
        buf.writeInt(this.mode.getValue());
        buf.writeInt(this.limitWest);
        buf.writeInt(this.limitDown);
        buf.writeInt(this.limitNorth);
        buf.writeInt(this.limitEast);
        buf.writeInt(this.limitUp);
        buf.writeInt(this.limitSouth);
    }

    public static class Handler
    implements IMessageHandler<HEPacketConfigUpdate, IMessage> {
        public IMessage onMessage(HEPacketConfigUpdate message, MessageContext ctx) {
            HEClient.onConfigUpdate(message.waterId, message.blockX, message.blockY, message.blockZ, message.mode, message.limitWest, message.limitDown, message.limitNorth, message.limitEast, message.limitUp, message.limitSouth);
            return null;
        }
    }
}

