/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy.client.light;

import com.sinthoras.hydroenergy.HEUtil;
import com.sinthoras.hydroenergy.blocks.HEWater;
import com.sinthoras.hydroenergy.client.HEClient;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.BitSet;
import net.minecraft.block.Block;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

@SideOnly(value=Side.CLIENT)
class HELightChunk {
    public BitSet[] lightFlags = new BitSet[16];
    public short subChunkHasWaterFlags;
    public short requiresPatching;
    public short neighborRequiresPatchingWest;
    public short neighborRequiresPatchingNorth;
    public short neighborRequiresPatchingEast;
    public short neighborRequiresPatchingSouth;
    public int[][] waterIds;

    public HELightChunk() {
        for (int chunkY = 0; chunkY < 16; ++chunkY) {
            this.lightFlags[chunkY] = new BitSet(4096);
        }
        this.waterIds = new int[16][16];
        this.subChunkHasWaterFlags = 0;
        this.requiresPatching = 0;
        this.neighborRequiresPatchingWest = 0;
        this.neighborRequiresPatchingNorth = 0;
        this.neighborRequiresPatchingEast = 0;
        this.neighborRequiresPatchingSouth = 0;
    }

    public void reset() {
        for (int chunkY = 0; chunkY < 16; ++chunkY) {
            this.lightFlags[chunkY].clear();
        }
        this.subChunkHasWaterFlags = 0;
        this.neighborRequiresPatchingWest = 0;
        this.neighborRequiresPatchingNorth = 0;
        this.neighborRequiresPatchingEast = 0;
        this.neighborRequiresPatchingSouth = 0;
    }

    public void parseChunk(Chunk chunk) {
        ExtendedBlockStorage[] chunkStorage = chunk.func_76587_i();
        for (int chunkY = 0; chunkY < 16; ++chunkY) {
            ExtendedBlockStorage subChunkStorage = chunkStorage[chunkY];
            if (subChunkStorage == null) continue;
            BitSet flags = this.lightFlags[chunkY];
            int[] bucketsBlockX = new int[16];
            int[] bucketsBlockZ = new int[16];
            short flagChunkY = HEUtil.chunkYToFlag(chunkY);
            for (int blockX = 0; blockX < 16; ++blockX) {
                for (int blockY = 0; blockY < 16; ++blockY) {
                    for (int blockZ = 0; blockZ < 16; ++blockZ) {
                        Block block = subChunkStorage.func_150819_a(blockX, blockY, blockZ);
                        if (!(block instanceof HEWater)) continue;
                        int n = blockX;
                        bucketsBlockX[n] = bucketsBlockX[n] + 1;
                        int n2 = blockZ;
                        bucketsBlockZ[n2] = bucketsBlockZ[n2] + 1;
                        flags.set(blockX << 8 | blockY << 4 | blockZ);
                        this.waterIds[blockX][blockZ] = ((HEWater)block).getWaterId();
                        this.subChunkHasWaterFlags = (short)(this.subChunkHasWaterFlags | flagChunkY);
                    }
                }
            }
            this.neighborRequiresPatchingWest = (short)(this.neighborRequiresPatchingWest | (bucketsBlockX[0] > 0 ? flagChunkY : (short)0));
            this.neighborRequiresPatchingNorth = (short)(this.neighborRequiresPatchingNorth | (bucketsBlockZ[0] > 0 ? flagChunkY : (short)0));
            this.neighborRequiresPatchingEast = (short)(this.neighborRequiresPatchingEast | (bucketsBlockX[15] > 0 ? flagChunkY : (short)0));
            this.neighborRequiresPatchingSouth = (short)(this.neighborRequiresPatchingSouth | (bucketsBlockZ[15] > 0 ? flagChunkY : (short)0));
        }
        this.requiresPatching = this.subChunkHasWaterFlags;
    }

    public void removeWaterBlock(int blockX, int blockY, int blockZ) {
        BitSet flags = this.lightFlags[blockY >> 4];
        flags.clear((blockX &= 0xF) << 8 | (blockY &= 0xF) << 4 | (blockZ &= 0xF));
    }

    public void addWaterBlock(int blockX, int blockY, int blockZ, int waterId) {
        int chunkY = HEUtil.coordBlockToChunk(blockY);
        BitSet flags = this.lightFlags[chunkY];
        this.subChunkHasWaterFlags = (short)(this.subChunkHasWaterFlags | HEUtil.chunkYToFlag(chunkY));
        flags.set((blockX &= 0xF) << 8 | (blockY &= 0xF) << 4 | (blockZ &= 0xF));
        this.waterIds[blockX][blockZ] = waterId;
    }

    public void patchBlock(Chunk chunk, int blockX, int blockY, int blockZ) {
        int chunkY = HEUtil.coordBlockToChunk(blockY);
        int waterId = this.waterIds[blockX][blockZ];
        float blockDiff = Math.min((float)blockY - HEClient.getDam(waterId).getWaterLevelForPhysicsAndLighting(), 0.0f);
        int lightVal = (int)(15.0f + blockDiff * 3.0f);
        lightVal = Math.max(lightVal, 0);
        chunk.func_76587_i()[chunkY].func_76671_l().func_76581_a(blockX, blockY & 0xF, blockZ, lightVal);
    }

    public void patchSubChunk(Chunk chunk, int chunkY) {
        short flagChunkY = HEUtil.chunkYToFlag(chunkY);
        if (this.hasWaterInSubchunk(flagChunkY) && this.subChunkRequiresPatching(flagChunkY)) {
            float[] waterLevels = HEClient.getAllWaterLevelForPhysicsAndLighting();
            BitSet flags = this.lightFlags[chunkY];
            NibbleArray skyLightArray = chunk.func_76587_i()[chunkY].func_76671_l();
            int linearCoord = flags.nextSetBit(0);
            while (linearCoord != -1) {
                int blockX = linearCoord >> 8;
                int blockY = linearCoord >> 4 & 0xF;
                int blockZ = linearCoord & 0xF;
                int waterId = this.waterIds[blockX][blockZ];
                float blockDiff = Math.min((float)(HEUtil.coordChunkToBlock(chunkY) + blockY) - waterLevels[waterId], 0.0f);
                int lightVal = (int)(15.0f + blockDiff * 3.0f);
                lightVal = Math.max(lightVal, 0);
                skyLightArray.func_76581_a(blockX, blockY, blockZ, lightVal);
                linearCoord = flags.nextSetBit(linearCoord + 1);
            }
            this.subChunkWasPatched(flagChunkY);
        }
    }

    private void subChunkWasPatched(int flagChunkY) {
        this.requiresPatching = (short)(this.requiresPatching & ~flagChunkY);
    }

    public void subChunkMustBePatched(int flagChunkY) {
        this.requiresPatching = (short)(this.requiresPatching | flagChunkY);
    }

    private boolean subChunkRequiresPatching(int flagChunkY) {
        return (this.requiresPatching & flagChunkY) > 0;
    }

    public boolean hasWaterInSubchunk(int flagChunkY) {
        return (this.subChunkHasWaterFlags & flagChunkY) > 0;
    }

    public boolean hasUpdateForDam(int waterId) {
        for (int blockX = 0; blockX < 16; ++blockX) {
            for (int blockZ = 0; blockZ < 16; ++blockZ) {
                if (this.waterIds[blockX][blockZ] != waterId) continue;
                return true;
            }
        }
        return false;
    }

    public boolean requiresPatchingWest(int flagChunkY) {
        return (this.neighborRequiresPatchingWest & flagChunkY) > 0;
    }

    public boolean requiresPatchingNorth(int flagChunkY) {
        return (this.neighborRequiresPatchingNorth & flagChunkY) > 0;
    }

    public boolean requiresPatchingEast(int flagChunkY) {
        return (this.neighborRequiresPatchingEast & flagChunkY) > 0;
    }

    public boolean requiresPatchingSouth(int flagChunkY) {
        return (this.neighborRequiresPatchingSouth & flagChunkY) > 0;
    }
}

